/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import javax.naming.directory.DirContext;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.Store;
import org.apache.catalina.Valve;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.session.PersistentManager;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.WARDirContext;

public final class StandardServer
implements Lifecycle,
Server {
    private static String[][] exceptions = new String[][]{{"org.apache.catalina.core.StandardContext", "available"}, {"org.apache.catalina.core.StandardContext", "configured"}, {"org.apache.catalina.core.StandardContext", "distributable"}, {"org.apache.catalina.core.StandardContext", "name"}, {"org.apache.catalina.core.StandardContext", "override"}, {"org.apache.catalina.core.StandardContext", "publicId"}, {"org.apache.catalina.core.StandardContext", "replaceWelcomeFiles"}, {"org.apache.catalina.core.StandardContext", "sessionTimeout"}, {"org.apache.catalina.core.StandardContext", "workDir"}, {"org.apache.catalina.session.StandardManager", "distributable"}, {"org.apache.catalina.session.StandardManager", "entropy"}};
    private static Class[] persistables = new Class[]{class$java$lang$String == null ? (class$java$lang$String = StandardServer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = StandardServer.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = StandardServer.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = StandardServer.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = StandardServer.class$("java.lang.Character")) : class$java$lang$Character, Character.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = StandardServer.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = StandardServer.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = StandardServer.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = StandardServer.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE};
    private static String[] skippables = new String[]{"org.apache.catalina.authenticator.BasicAuthenticator", "org.apache.catalina.authenticator.DigestAuthenticator", "org.apache.catalina.authenticator.FormAuthenticator", "org.apache.catalina.authenticator.NonLoginAuthenticator", "org.apache.catalina.authenticator.SSLAuthenticator", "org.apache.catalina.core.NamingContextListener", "org.apache.catalina.core.StandardContextValve", "org.apache.catalina.core.StandardEngineValve", "org.apache.catalina.core.StandardHostValve", "org.apache.catalina.startup.ContextConfig", "org.apache.catalina.startup.EngineConfig", "org.apache.catalina.startup.HostConfig", "org.apache.catalina.valves.CertificatesValve", "org.apache.catalina.valves.ErrorDispatcherValve", "org.apache.catalina.valves.ErrorReportValve"};
    private static String SERVER_LISTENER_CLASS_NAME = "org.apache.catalina.mbeans.ServerLifecycleListener";
    private int debug = 0;
    private javax.naming.Context globalNamingContext = null;
    private NamingResources globalNamingResources = null;
    private static final String info = "org.apache.catalina.core.StandardServer/1.0";
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private NamingContextListener namingContextListener = null;
    private int port = 8005;
    private Random random = null;
    private Service[] services = new Service[0];
    private String shutdown = "SHUTDOWN";
    private static final StringManager sm;
    private boolean started = false;
    private boolean initialized = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public StandardServer() {
        ServerFactory.setServer(this);
        this.globalNamingResources = new NamingResources();
        this.globalNamingResources.setContainer(this);
        if (this.isUseNaming() && this.namingContextListener == null) {
            this.namingContextListener = new NamingContextListener();
            this.namingContextListener.setDebug(this.getDebug());
            this.addLifecycleListener(this.namingContextListener);
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public javax.naming.Context getGlobalNamingContext() {
        return this.globalNamingContext;
    }

    public void setGlobalNamingContext(javax.naming.Context globalNamingContext) {
        this.globalNamingContext = globalNamingContext;
    }

    public NamingResources getGlobalNamingResources() {
        return this.globalNamingResources;
    }

    public void setGlobalNamingResources(NamingResources globalNamingResources) {
        NamingResources oldGlobalNamingResources = this.globalNamingResources;
        this.globalNamingResources = globalNamingResources;
        this.globalNamingResources.setContainer(this);
        this.support.firePropertyChange("globalNamingResources", oldGlobalNamingResources, this.globalNamingResources);
    }

    public String getInfo() {
        return info;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getShutdown() {
        return this.shutdown;
    }

    public void setShutdown(String shutdown) {
        this.shutdown = shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(Service service) {
        service.setServer(this);
        Service[] serviceArray = this.services;
        synchronized (serviceArray) {
            Service[] results = new Service[this.services.length + 1];
            System.arraycopy(this.services, 0, results, 0, this.services.length);
            results[this.services.length] = service;
            this.services = results;
            if (this.initialized) {
                try {
                    service.initialize();
                }
                catch (LifecycleException e) {
                    e.printStackTrace(System.err);
                }
            }
            if (this.started && service instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)service)).start();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("service", null, service);
        }
    }

    public void await() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port, 1, InetAddress.getByName("127.0.0.1"));
        }
        catch (IOException e) {
            System.err.println("StandardServer.await: create[" + this.port + "]: " + e);
            e.printStackTrace();
            System.exit(1);
        }
        while (true) {
            Socket socket = null;
            InputStream stream = null;
            try {
                socket = serverSocket.accept();
                socket.setSoTimeout(10000);
                stream = socket.getInputStream();
            }
            catch (AccessControlException ace) {
                System.err.println("StandardServer.accept security exception: " + ace.getMessage());
                continue;
            }
            catch (IOException e) {
                System.err.println("StandardServer.await: accept: " + e);
                e.printStackTrace();
                System.exit(1);
            }
            StringBuffer command = new StringBuffer();
            int expected = 1024;
            while (expected < this.shutdown.length()) {
                if (this.random == null) {
                    this.random = new Random(System.currentTimeMillis());
                }
                expected += this.random.nextInt() % 1024;
            }
            while (expected > 0) {
                int ch = -1;
                try {
                    ch = stream.read();
                }
                catch (IOException e) {
                    System.err.println("StandardServer.await: read: " + e);
                    e.printStackTrace();
                    ch = -1;
                }
                if (ch < 32) break;
                command.append((char)ch);
                --expected;
            }
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            boolean match = command.toString().equals(this.shutdown);
            if (match) break;
            System.err.println("StandardServer.await: Invalid command '" + command.toString() + "' received");
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Service findService(String name) {
        if (name == null) {
            return null;
        }
        Service[] serviceArray = this.services;
        synchronized (serviceArray) {
            int i = 0;
            while (i < this.services.length) {
                if (name.equals(this.services[i].getName())) {
                    return this.services[i];
                }
                ++i;
            }
            return null;
        }
    }

    public Service[] findServices() {
        return this.services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(Service service) {
        Service[] serviceArray = this.services;
        synchronized (serviceArray) {
            int j = -1;
            int i = 0;
            while (i < this.services.length) {
                if (service == this.services[i]) {
                    j = i;
                    break;
                }
                ++i;
            }
            if (j < 0) {
                return;
            }
            if (this.services[j] instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.services[j])).stop();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            int k = 0;
            Service[] results = new Service[this.services.length - 1];
            int i2 = 0;
            while (i2 < this.services.length) {
                if (i2 != j) {
                    results[k++] = this.services[i2];
                }
                ++i2;
            }
            this.services = results;
            this.support.firePropertyChange("service", service, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardServer[");
        sb.append(this.getPort());
        sb.append("]");
        return sb.toString();
    }

    public synchronized void store() throws Exception {
        File configNew;
        String configFile = "conf/server.xml";
        File configOld = new File(configFile);
        if (!configOld.isAbsolute()) {
            configOld = new File(System.getProperty("catalina.base"), configFile);
        }
        if (!(configNew = new File(configFile + ".new")).isAbsolute()) {
            configNew = new File(System.getProperty("catalina.base"), configFile + ".new");
        }
        String ts = new Timestamp(System.currentTimeMillis()).toString();
        StringBuffer sb = new StringBuffer(".");
        sb.append(ts.substring(0, 10));
        sb.append('.');
        sb.append(ts.substring(11, 13));
        sb.append('-');
        sb.append(ts.substring(14, 16));
        sb.append('-');
        sb.append(ts.substring(17, 19));
        File configSave = new File(configFile + sb.toString());
        if (!configSave.isAbsolute()) {
            configSave = new File(System.getProperty("catalina.base"), configFile + sb.toString());
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configNew), "UTF8"));
        }
        catch (IOException e) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            throw e;
        }
        try {
            this.storeServer(writer, 0, this);
        }
        catch (Exception e) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            throw e;
        }
        writer.flush();
        writer.close();
        if (configOld.renameTo(configSave)) {
            if (configNew.renameTo(configOld)) {
                return;
            }
            configSave.renameTo(configOld);
            throw new IOException("Cannot rename " + configNew.getAbsolutePath() + " to " + configOld.getAbsolutePath());
        }
        throw new IOException("Cannot rename " + configOld.getAbsolutePath() + " to " + configSave.getAbsolutePath());
    }

    private String convertStr(String input) {
        StringBuffer filtered = new StringBuffer(input.length());
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == '<') {
                filtered.append("&lt;");
            } else if (c == '>') {
                filtered.append("&gt;");
            } else if (c == '\'') {
                filtered.append("&apos;");
            } else if (c == '\"') {
                filtered.append("&quot;");
            } else if (c == '&') {
                filtered.append("&amp;");
            } else {
                filtered.append(c);
            }
            ++i;
        }
        return filtered.toString();
    }

    private boolean isDefaultLoader(Loader loader) {
        if (!(loader instanceof WebappLoader)) {
            return false;
        }
        WebappLoader wloader = (WebappLoader)loader;
        return wloader.getCheckInterval() == 15 && wloader.getDebug() == 0 && !wloader.getDelegate() && wloader.getLoaderClass().equals("org.apache.catalina.loader.WebappClassLoader");
    }

    private boolean isDefaultManager(Manager manager) {
        if (!(manager instanceof StandardManager)) {
            return false;
        }
        StandardManager smanager = (StandardManager)manager;
        return smanager.getDebug() == 0 && smanager.getPathname().equals("SESSIONS.ser") && smanager.getCheckInterval() == 60 && smanager.getRandomClass().equals("java.security.SecureRandom") && smanager.getMaxActiveSessions() == -1 && smanager.getAlgorithm().equals("MD5");
    }

    private boolean isException(String className, String property) {
        int i = 0;
        while (i < exceptions.length) {
            if (className.equals(exceptions[i][0]) && property.equals(exceptions[i][1])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isPersistable(Class clazz) {
        int i = 0;
        while (i < persistables.length) {
            if (persistables[i] == clazz) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isSkippable(String className) {
        int i = 0;
        while (i < skippables.length) {
            if (skippables[i] == className) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void storeAttributes(PrintWriter writer, Object bean) throws Exception {
        this.storeAttributes(writer, true, bean);
    }

    private void storeAttributes(PrintWriter writer, boolean include, Object bean) throws Exception {
        PropertyDescriptor[] descriptors;
        if (include) {
            writer.print(" className=\"");
            writer.print(bean.getClass().getName());
            writer.print("\"");
        }
        if ((descriptors = PropertyUtils.getPropertyDescriptors((Object)bean)) == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        String className = bean.getClass().getName();
        int i = 0;
        while (i < descriptors.length) {
            Object value;
            if (!(descriptors[i] instanceof IndexedPropertyDescriptor) && this.isPersistable(descriptors[i].getPropertyType()) && descriptors[i].getReadMethod() != null && descriptors[i].getWriteMethod() != null && (value = PropertyUtils.getSimpleProperty((Object)bean, (String)descriptors[i].getName())) != null && !this.isException(className, descriptors[i].getName())) {
                if (!(value instanceof String)) {
                    value = value.toString();
                }
                writer.print(' ');
                writer.print(descriptors[i].getName());
                writer.print("=\"");
                String strValue = this.convertStr((String)value);
                writer.print(strValue);
                writer.print("\"");
            }
            ++i;
        }
    }

    private void storeConnector(PrintWriter writer, int indent, Connector connector) throws Exception {
        int i = 0;
        while (i < indent) {
            writer.print(' ');
            ++i;
        }
        writer.print("<Connector");
        this.storeAttributes(writer, connector);
        writer.println(">");
        ServerSocketFactory factory = connector.getFactory();
        if (factory != null) {
            this.storeFactory(writer, indent + 2, factory);
        }
        if (connector instanceof Lifecycle) {
            LifecycleListener[] listeners = ((Lifecycle)((Object)connector)).findLifecycleListeners();
            if (listeners == null) {
                listeners = new LifecycleListener[]{};
            }
            int i2 = 0;
            while (i2 < listeners.length) {
                if (!listeners[i2].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) {
                    this.storeListener(writer, indent + 2, listeners[i2]);
                }
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < indent) {
            writer.print(' ');
            ++i3;
        }
        writer.println("</Connector>");
    }

    private void storeContext(PrintWriter writer, int indent, Context context) throws Exception {
        int i;
        DirContext resources;
        Manager manager;
        Logger logger;
        Loader loader;
        int i2 = 0;
        while (i2 < indent) {
            writer.print(' ');
            ++i2;
        }
        writer.print("<Context");
        this.storeAttributes(writer, context);
        writer.println(">");
        String[] iListeners = context.findInstanceListeners();
        int i3 = 0;
        while (i3 < iListeners.length) {
            int j = 0;
            while (j < indent) {
                writer.print(' ');
                ++j;
            }
            writer.print("<InstanceListener>");
            writer.print(iListeners[i3]);
            writer.println("</InstanceListener>");
            ++i3;
        }
        if (context instanceof Lifecycle) {
            LifecycleListener[] listeners = ((Lifecycle)((Object)context)).findLifecycleListeners();
            int i4 = 0;
            while (i4 < listeners.length) {
                if (!listeners[i4].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) {
                    this.storeListener(writer, indent + 2, listeners[i4]);
                }
                ++i4;
            }
        }
        if ((loader = context.getLoader()) != null) {
            this.storeLoader(writer, indent + 2, loader);
        }
        if ((logger = context.getLogger()) != null) {
            Logger parentLogger = null;
            if (context.getParent() != null) {
                parentLogger = context.getParent().getLogger();
            }
            if (logger != parentLogger) {
                this.storeLogger(writer, indent + 2, logger);
            }
        }
        if ((manager = context.getManager()) != null) {
            this.storeManager(writer, indent + 2, manager);
        }
        ApplicationParameter[] appParams = context.findApplicationParameters();
        int i5 = 0;
        while (i5 < appParams.length) {
            int j = 0;
            while (j < indent + 2) {
                writer.print(' ');
                ++j;
            }
            writer.print("<Parameter");
            this.storeAttributes(writer, false, appParams[i5]);
            writer.println("/>");
            ++i5;
        }
        Realm realm = context.getRealm();
        if (realm != null) {
            Realm parentRealm = null;
            if (context.getParent() != null) {
                parentRealm = context.getParent().getRealm();
            }
            if (realm != parentRealm) {
                this.storeRealm(writer, indent + 2, realm);
            }
        }
        if ((resources = context.getResources()) != null) {
            this.storeResources(writer, indent + 2, resources);
        }
        if (context instanceof Pipeline) {
            Valve[] valves = ((Pipeline)((Object)context)).getValves();
            i = 0;
            while (i < valves.length) {
                this.storeValve(writer, indent + 2, valves[i]);
                ++i;
            }
        }
        String[] wLifecycles = context.findWrapperLifecycles();
        i = 0;
        while (i < wLifecycles.length) {
            int j = 0;
            while (j < indent) {
                writer.print(' ');
                ++j;
            }
            writer.print("<WrapperLifecycle>");
            writer.print(wLifecycles[i]);
            writer.println("</WrapperLifecycle>");
            ++i;
        }
        String[] wListeners = context.findWrapperListeners();
        int i6 = 0;
        while (i6 < wListeners.length) {
            int j = 0;
            while (j < indent) {
                writer.print(' ');
                ++j;
            }
            writer.print("<WrapperListener>");
            writer.print(wListeners[i6]);
            writer.println("</WrapperListener>");
            ++i6;
        }
        NamingResources nresources = context.getNamingResources();
        if (nresources != null) {
            this.storeNamingResources(writer, indent + 2, nresources);
        }
        int i7 = 0;
        while (i7 < indent) {
            writer.print(' ');
            ++i7;
        }
        writer.println("</Context>");
    }

    private void storeDefaultContext(PrintWriter writer, int indent, DefaultContext dcontext) throws Exception {
        int i;
        Manager manager;
        Loader loader;
        int i2 = 0;
        while (i2 < indent) {
            writer.print(' ');
            ++i2;
        }
        writer.print("<DefaultContext");
        this.storeAttributes(writer, dcontext);
        writer.println(">");
        String[] iListeners = dcontext.findInstanceListeners();
        int i3 = 0;
        while (i3 < iListeners.length) {
            int j = 0;
            while (j < indent) {
                writer.print(' ');
                ++j;
            }
            writer.print("<InstanceListener>");
            writer.print(iListeners[i3]);
            writer.println("</InstanceListener>");
            ++i3;
        }
        if (dcontext instanceof Lifecycle) {
            LifecycleListener[] listeners = ((Lifecycle)((Object)dcontext)).findLifecycleListeners();
            int i4 = 0;
            while (i4 < listeners.length) {
                if (!listeners[i4].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) {
                    this.storeListener(writer, indent + 2, listeners[i4]);
                }
                ++i4;
            }
        }
        if ((loader = dcontext.getLoader()) != null) {
            this.storeLoader(writer, indent + 2, loader);
        }
        if ((manager = dcontext.getManager()) != null) {
            this.storeManager(writer, indent + 2, manager);
        }
        ApplicationParameter[] appParams = dcontext.findApplicationParameters();
        int i5 = 0;
        while (i5 < appParams.length) {
            int j = 0;
            while (j < indent + 2) {
                writer.print(' ');
                ++j;
            }
            writer.print("<Parameter");
            this.storeAttributes(writer, false, appParams[i5]);
            writer.println("/>");
            ++i5;
        }
        DirContext resources = dcontext.getResources();
        if (resources != null) {
            this.storeResources(writer, indent + 2, resources);
        }
        if (dcontext instanceof Pipeline) {
            Valve[] valves = ((Pipeline)((Object)dcontext)).getValves();
            i = 0;
            while (i < valves.length) {
                this.storeValve(writer, indent + 2, valves[i]);
                ++i;
            }
        }
        String[] wLifecycles = dcontext.findWrapperLifecycles();
        i = 0;
        while (i < wLifecycles.length) {
            int j = 0;
            while (j < indent) {
                writer.print(' ');
                ++j;
            }
            writer.print("<WrapperLifecycle>");
            writer.print(wLifecycles[i]);
            writer.println("</WrapperLifecycle>");
            ++i;
        }
        String[] wListeners = dcontext.findWrapperListeners();
        int i6 = 0;
        while (i6 < wListeners.length) {
            int j = 0;
            while (j < indent) {
                writer.print(' ');
                ++j;
            }
            writer.print("<WrapperListener>");
            writer.print(wListeners[i6]);
            writer.println("</WrapperListener>");
            ++i6;
        }
        NamingResources nresources = dcontext.getNamingResources();
        if (nresources != null) {
            this.storeNamingResources(writer, indent + 2, nresources);
        }
        int i7 = 0;
        while (i7 < indent) {
            writer.print(' ');
            ++i7;
        }
        writer.println("</DefaultContext>");
    }

    private void storeEngine(PrintWriter writer, int indent, Engine engine) throws Exception {
        Realm realm;
        Logger logger;
        DefaultContext dcontext;
        int i = 0;
        while (i < indent) {
            writer.print(' ');
            ++i;
        }
        writer.print("<Engine");
        this.storeAttributes(writer, engine);
        writer.println(">");
        if (engine instanceof StandardEngine && (dcontext = ((StandardEngine)engine).getDefaultContext()) != null) {
            this.storeDefaultContext(writer, indent + 2, dcontext);
        }
        Container[] children = engine.findChildren();
        int i2 = 0;
        while (i2 < children.length) {
            if (children[i2] instanceof Context) {
                this.storeContext(writer, indent + 2, (Context)children[i2]);
            } else if (children[i2] instanceof Engine) {
                this.storeEngine(writer, indent + 2, (Engine)children[i2]);
            } else if (children[i2] instanceof Host) {
                this.storeHost(writer, indent + 2, (Host)children[i2]);
            }
            ++i2;
        }
        if (engine instanceof Lifecycle) {
            LifecycleListener[] listeners = ((Lifecycle)((Object)engine)).findLifecycleListeners();
            int i3 = 0;
            while (i3 < listeners.length) {
                if (!listeners[i3].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) {
                    this.storeListener(writer, indent + 2, listeners[i3]);
                }
                ++i3;
            }
        }
        if ((logger = engine.getLogger()) != null) {
            Logger parentLogger = null;
            if (engine.getParent() != null) {
                parentLogger = engine.getParent().getLogger();
            }
            if (logger != parentLogger) {
                this.storeLogger(writer, indent + 2, logger);
            }
        }
        if ((realm = engine.getRealm()) != null) {
            Realm parentRealm = null;
            if (engine.getParent() != null) {
                parentRealm = engine.getParent().getRealm();
            }
            if (realm != parentRealm) {
                this.storeRealm(writer, indent + 2, realm);
            }
        }
        if (engine instanceof Pipeline) {
            Valve[] valves = ((Pipeline)((Object)engine)).getValves();
            int i4 = 0;
            while (i4 < valves.length) {
                this.storeValve(writer, indent + 2, valves[i4]);
                ++i4;
            }
        }
        int i5 = 0;
        while (i5 < indent) {
            writer.print(' ');
            ++i5;
        }
        writer.println("</Engine>");
    }

    private void storeFactory(PrintWriter writer, int indent, ServerSocketFactory factory) throws Exception {
        int i = 0;
        while (i < indent) {
            writer.print(' ');
            ++i;
        }
        writer.print("<Factory");
        this.storeAttributes(writer, factory);
        writer.println("/>");
    }

    private void storeHost(PrintWriter writer, int indent, Host host) throws Exception {
        Realm realm;
        Logger logger;
        DefaultContext pcontext;
        Container parent;
        DefaultContext dcontext;
        int i = 0;
        while (i < indent) {
            writer.print(' ');
            ++i;
        }
        writer.print("<Host");
        this.storeAttributes(writer, host);
        writer.println(">");
        String[] aliases = host.findAliases();
        int i2 = 0;
        while (i2 < aliases.length) {
            int j = 0;
            while (j < indent) {
                writer.print(' ');
                ++j;
            }
            writer.print("<Alias>");
            writer.print(aliases[i2]);
            writer.println("</Alias>");
            ++i2;
        }
        Container[] children = host.findChildren();
        int i3 = 0;
        while (i3 < children.length) {
            if (children[i3] instanceof Context) {
                this.storeContext(writer, indent + 2, (Context)children[i3]);
            } else if (children[i3] instanceof Engine) {
                this.storeEngine(writer, indent + 2, (Engine)children[i3]);
            } else if (children[i3] instanceof Host) {
                this.storeHost(writer, indent + 2, (Host)children[i3]);
            }
            ++i3;
        }
        if (host instanceof StandardHost && (dcontext = ((StandardHost)host).getDefaultContext()) != null && (parent = host.getParent()) != null && parent instanceof StandardEngine && dcontext != (pcontext = ((StandardEngine)parent).getDefaultContext())) {
            this.storeDefaultContext(writer, indent + 2, dcontext);
        }
        if (host instanceof Lifecycle) {
            LifecycleListener[] listeners = ((Lifecycle)((Object)host)).findLifecycleListeners();
            int i4 = 0;
            while (i4 < listeners.length) {
                if (!listeners[i4].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) {
                    this.storeListener(writer, indent + 2, listeners[i4]);
                }
                ++i4;
            }
        }
        if ((logger = host.getLogger()) != null) {
            Logger parentLogger = null;
            if (host.getParent() != null) {
                parentLogger = host.getParent().getLogger();
            }
            if (logger != parentLogger) {
                this.storeLogger(writer, indent + 2, logger);
            }
        }
        if ((realm = host.getRealm()) != null) {
            Realm parentRealm = null;
            if (host.getParent() != null) {
                parentRealm = host.getParent().getRealm();
            }
            if (realm != parentRealm) {
                this.storeRealm(writer, indent + 2, realm);
            }
        }
        if (host instanceof Pipeline) {
            Valve[] valves = ((Pipeline)((Object)host)).getValves();
            int i5 = 0;
            while (i5 < valves.length) {
                this.storeValve(writer, indent + 2, valves[i5]);
                ++i5;
            }
        }
        int i6 = 0;
        while (i6 < indent) {
            writer.print(' ');
            ++i6;
        }
        writer.println("</Host>");
    }

    private void storeListener(PrintWriter writer, int indent, LifecycleListener listener) throws Exception {
        if (this.isSkippable(listener.getClass().getName())) {
            return;
        }
        int i = 0;
        while (i < indent) {
            writer.print(' ');
            ++i;
        }
        writer.print("<Listener");
        this.storeAttributes(writer, listener);
        writer.println("/>");
    }

    private void storeLoader(PrintWriter writer, int indent, Loader loader) throws Exception {
        if (this.isDefaultLoader(loader)) {
            return;
        }
        int i = 0;
        while (i < indent) {
            writer.print(' ');
            ++i;
        }
        writer.print("<Loader");
        this.storeAttributes(writer, loader);
        writer.println("/>");
    }

    private void storeLogger(PrintWriter writer, int indent, Logger logger) throws Exception {
        int i = 0;
        while (i < indent) {
            writer.print(' ');
            ++i;
        }
        writer.print("<Logger");
        this.storeAttributes(writer, logger);
        writer.println("/>");
    }

    private void storeManager(PrintWriter writer, int indent, Manager manager) throws Exception {
        Store store;
        if (this.isDefaultManager(manager)) {
            return;
        }
        int i = 0;
        while (i < indent) {
            writer.print(' ');
            ++i;
        }
        writer.print("<Manager");
        this.storeAttributes(writer, manager);
        writer.println(">");
        if (manager instanceof PersistentManager && (store = ((PersistentManager)manager).getStore()) != null) {
            this.storeStore(writer, indent + 2, store);
        }
        int i2 = 0;
        while (i2 < indent) {
            writer.print(' ');
            ++i2;
        }
        writer.println("</Manager>");
    }

    private void storeNamingResources(PrintWriter writer, int indent, NamingResources resources) throws Exception {
        int j;
        ContextLocalEjb[] lejbs;
        ContextEnvironment[] envs;
        ContextEjb[] ejbs = resources.findEjbs();
        if (ejbs.length > 0) {
            int i = 0;
            while (i < ejbs.length) {
                int j2 = 0;
                while (j2 < indent) {
                    writer.print(' ');
                    ++j2;
                }
                writer.print("<Ejb");
                this.storeAttributes(writer, false, ejbs[i]);
                writer.println("/>");
                ++i;
            }
        }
        if ((envs = resources.findEnvironments()).length > 0) {
            int i = 0;
            while (i < envs.length) {
                int j3 = 0;
                while (j3 < indent) {
                    writer.print(' ');
                    ++j3;
                }
                writer.print("<Environment");
                this.storeAttributes(writer, false, envs[i]);
                writer.println("/>");
                ++i;
            }
        }
        if ((lejbs = resources.findLocalEjbs()).length > 0) {
            int i = 0;
            while (i < lejbs.length) {
                int j4 = 0;
                while (j4 < indent) {
                    writer.print(' ');
                    ++j4;
                }
                writer.print("<LocalEjb");
                this.storeAttributes(writer, false, lejbs[i]);
                writer.println("/>");
                ++i;
            }
        }
        ContextResource[] dresources = resources.findResources();
        int i = 0;
        while (i < dresources.length) {
            int j5 = 0;
            while (j5 < indent) {
                writer.print(' ');
                ++j5;
            }
            writer.print("<Resource");
            this.storeAttributes(writer, false, dresources[i]);
            writer.println("/>");
            ++i;
        }
        String[] eresources = resources.findResourceEnvRefs();
        int i2 = 0;
        while (i2 < eresources.length) {
            int j6 = 0;
            while (j6 < indent) {
                writer.print(' ');
                ++j6;
            }
            writer.println("<ResourceEnvRef>");
            int j7 = 0;
            while (j7 < indent + 2) {
                writer.print(' ');
                ++j7;
            }
            writer.print("<name>");
            writer.print(eresources[i2]);
            writer.println("</name>");
            j = 0;
            while (j < indent + 2) {
                writer.print(' ');
                ++j;
            }
            writer.print("<type>");
            writer.print(resources.findResourceEnvRef(eresources[i2]));
            writer.println("</type>");
            int j8 = 0;
            while (j8 < indent) {
                writer.print(' ');
                ++j8;
            }
            writer.println("</ResourceEnvRef>");
            ++i2;
        }
        ResourceParams[] params = resources.findResourceParams();
        int i3 = 0;
        while (i3 < params.length) {
            j = 0;
            while (j < indent) {
                writer.print(' ');
                ++j;
            }
            writer.print("<ResourceParams");
            this.storeAttributes(writer, false, params[i3]);
            writer.println(">");
            Hashtable resourceParams = params[i3].getParameters();
            Enumeration nameEnum = resourceParams.keys();
            while (nameEnum.hasMoreElements()) {
                String name = (String)nameEnum.nextElement();
                String value = (String)resourceParams.get(name);
                int j9 = 0;
                while (j9 < indent + 2) {
                    writer.print(' ');
                    ++j9;
                }
                writer.println("<parameter>");
                int j10 = 0;
                while (j10 < indent + 4) {
                    writer.print(' ');
                    ++j10;
                }
                writer.print("<name>");
                writer.print(name);
                writer.println("</name>");
                int j11 = 0;
                while (j11 < indent + 4) {
                    writer.print(' ');
                    ++j11;
                }
                writer.print("<value>");
                writer.print(value);
                writer.println("</value>");
                int j12 = 0;
                while (j12 < indent + 2) {
                    writer.print(' ');
                    ++j12;
                }
                writer.println("</parameter>");
            }
            int j13 = 0;
            while (j13 < indent) {
                writer.print(' ');
                ++j13;
            }
            writer.println("</ResourceParams>");
            ++i3;
        }
        ContextResourceLink[] resourceLinks = resources.findResourceLinks();
        int i4 = 0;
        while (i4 < resourceLinks.length) {
            int j14 = 0;
            while (j14 < indent) {
                writer.print(' ');
                ++j14;
            }
            writer.print("<ResourceLink");
            this.storeAttributes(writer, false, resourceLinks[i4]);
            writer.println("/>");
            ++i4;
        }
    }

    private void storeRealm(PrintWriter writer, int indent, Realm realm) throws Exception {
        int i = 0;
        while (i < indent) {
            writer.print(' ');
            ++i;
        }
        writer.print("<Realm");
        this.storeAttributes(writer, realm);
        writer.println("/>");
    }

    private void storeResources(PrintWriter writer, int indent, DirContext resources) throws Exception {
        if (resources instanceof FileDirContext) {
            return;
        }
        if (resources instanceof ProxyDirContext) {
            return;
        }
        if (resources instanceof WARDirContext) {
            return;
        }
        int i = 0;
        while (i < indent) {
            writer.print(' ');
            ++i;
        }
        writer.print("<Resources");
        this.storeAttributes(writer, resources);
        writer.println("/>");
    }

    private void storeServer(PrintWriter writer, int indent, Server server) throws Exception {
        int i;
        NamingResources globalNamingResources;
        int i2;
        writer.println("<?xml version='1.0' encoding='utf-8'?>");
        int i3 = 0;
        while (i3 < indent) {
            writer.print(' ');
            ++i3;
        }
        writer.print("<Server");
        this.storeAttributes(writer, server);
        writer.println(">");
        if (server instanceof Lifecycle) {
            LifecycleListener[] listeners = ((Lifecycle)((Object)server)).findLifecycleListeners();
            i2 = 0;
            while (i2 < listeners.length) {
                this.storeListener(writer, indent + 2, listeners[i2]);
                ++i2;
            }
        }
        if ((globalNamingResources = server.getGlobalNamingResources()) != null) {
            i2 = 0;
            while (i2 < indent + 2) {
                writer.print(' ');
                ++i2;
            }
            writer.println("<GlobalNamingResources>");
            this.storeNamingResources(writer, indent + 4, globalNamingResources);
            i = 0;
            while (i < indent + 2) {
                writer.print(' ');
                ++i;
            }
            writer.println("</GlobalNamingResources>");
        }
        Service[] services = server.findServices();
        i = 0;
        while (i < services.length) {
            this.storeService(writer, indent + 2, services[i]);
            ++i;
        }
        int i4 = 0;
        while (i4 < indent) {
            writer.print(' ');
            ++i4;
        }
        writer.println("</Server>");
    }

    private void storeService(PrintWriter writer, int indent, Service service) throws Exception {
        int i = 0;
        while (i < indent) {
            writer.print(' ');
            ++i;
        }
        writer.print("<Service");
        this.storeAttributes(writer, service);
        writer.println(">");
        Connector[] connectors = service.findConnectors();
        int i2 = 0;
        while (i2 < connectors.length) {
            this.storeConnector(writer, indent + 2, connectors[i2]);
            ++i2;
        }
        Container container = service.getContainer();
        if (container != null) {
            if (container instanceof Context) {
                this.storeContext(writer, indent + 2, (Context)container);
            } else if (container instanceof Engine) {
                this.storeEngine(writer, indent + 2, (Engine)container);
            } else if (container instanceof Host) {
                this.storeHost(writer, indent + 2, (Host)container);
            }
        }
        if (service instanceof Lifecycle) {
            LifecycleListener[] listeners = ((Lifecycle)((Object)service)).findLifecycleListeners();
            int i3 = 0;
            while (i3 < listeners.length) {
                if (!listeners[i3].getClass().getName().equals(SERVER_LISTENER_CLASS_NAME)) {
                    this.storeListener(writer, indent + 2, listeners[i3]);
                }
                ++i3;
            }
        }
        int i4 = 0;
        while (i4 < indent) {
            writer.print(' ');
            ++i4;
        }
        writer.println("</Service>");
    }

    private void storeStore(PrintWriter writer, int indent, Store store) throws Exception {
        int i = 0;
        while (i < indent) {
            writer.print(' ');
            ++i;
        }
        writer.print("<Store");
        this.storeAttributes(writer, store);
        writer.println("/>");
    }

    private void storeValve(PrintWriter writer, int indent, Valve valve) throws Exception {
        if (this.isSkippable(valve.getClass().getName())) {
            return;
        }
        int i = 0;
        while (i < indent) {
            writer.print(' ');
            ++i;
        }
        writer.print("<Valve");
        this.storeAttributes(writer, valve);
        writer.println("/>");
    }

    private boolean isSameAddress(InetAddress server, InetAddress client) {
        byte[] clientAddr;
        byte[] serverAddr = server.getAddress();
        if (serverAddr.length != (clientAddr = client.getAddress()).length) {
            return false;
        }
        boolean match = true;
        int i = 0;
        while (i < serverAddr.length) {
            if (serverAddr[i] != clientAddr[i]) {
                match = false;
                break;
            }
            ++i;
        }
        if (match) {
            return true;
        }
        int i2 = 0;
        while (i2 < serverAddr.length) {
            if (serverAddr[i2] != clientAddr[serverAddr.length - 1 - i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private boolean isUseNaming() {
        boolean useNaming = true;
        String useNamingProperty = System.getProperty("catalina.useNaming");
        if (useNamingProperty != null && useNamingProperty.equals("false")) {
            useNaming = false;
        }
        return useNaming;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardServer.start.started"));
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Service[] serviceArray = this.services;
        synchronized (serviceArray) {
            int i = 0;
            while (i < this.services.length) {
                if (this.services[i] instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.services[i])).start();
                }
                ++i;
            }
        }
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardServer.stop.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        int i = 0;
        while (i < this.services.length) {
            if (this.services[i] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.services[i])).stop();
            }
            ++i;
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    public void initialize() throws LifecycleException {
        if (this.initialized) {
            throw new LifecycleException(sm.getString("standardServer.initialize.initialized"));
        }
        this.initialized = true;
        int i = 0;
        while (i < this.services.length) {
            this.services[i].initialize();
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        info = info;
        sm = StringManager.getManager("org.apache.catalina.core");
    }
}

