/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.io.PrintStream;
import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.catalina.Group;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.commons.modeler.Registry;

public class GlobalResourcesLifecycleListener
implements LifecycleListener {
    protected Lifecycle component = null;
    protected static Registry registry = MBeanUtils.createRegistry();
    protected int debug = 0;
    protected PrintStream stream = System.out;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            this.component = event.getLifecycle();
            this.createMBeans();
        } else if ("stop".equals(event.getType())) {
            this.destroyMBeans();
            this.component = null;
        }
    }

    protected void createMBeans() {
        Context context = null;
        try {
            context = (Context)new InitialContext().lookup("java:/");
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new IllegalStateException("No global naming context defined for server");
        }
        try {
            this.createMBeans("", context);
        }
        catch (NamingException e) {
            this.log("Exception processing Global JNDI Resources", e);
        }
    }

    protected void createMBeans(String prefix, Context context) throws NamingException {
        if (this.debug >= 1) {
            this.log("Creating MBeans for Global JNDI Resources in Context '" + prefix + "'");
        }
        NamingEnumeration<Binding> bindings = context.listBindings("");
        while (bindings.hasMore()) {
            Binding binding = bindings.next();
            String name = prefix + binding.getName();
            Object value = context.lookup(binding.getName());
            if (this.debug >= 2) {
                this.log("Checking resource " + name);
            }
            if (value instanceof Context) {
                this.createMBeans(name + "/", (Context)value);
                continue;
            }
            if (!(value instanceof UserDatabase)) continue;
            try {
                this.createMBeans(name, (UserDatabase)value);
            }
            catch (Exception e) {
                this.log("Exception creating UserDatabase MBeans for " + name, e);
            }
        }
    }

    protected void createMBeans(String name, UserDatabase database) throws Exception {
        if (this.debug >= 2) {
            this.log("Creating UserDatabase MBeans for resource " + name);
            this.log("Database=" + database);
        }
        if (MBeanUtils.createMBean(database) == null) {
            throw new IllegalArgumentException("Cannot create UserDatabase MBean for resource " + name);
        }
        Iterator roles = database.getRoles();
        while (roles.hasNext()) {
            Role role = (Role)roles.next();
            if (this.debug >= 3) {
                this.log("  Creating Role MBean for role " + role);
            }
            if (MBeanUtils.createMBean(role) != null) continue;
            throw new IllegalArgumentException("Cannot create Role MBean for role " + role);
        }
        Iterator groups = database.getGroups();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            if (this.debug >= 3) {
                this.log("  Creating Group MBean for group " + group);
            }
            if (MBeanUtils.createMBean(group) != null) continue;
            throw new IllegalArgumentException("Cannot create Group MBean for group " + group);
        }
        Iterator users = database.getUsers();
        while (users.hasNext()) {
            User user = (User)users.next();
            if (this.debug >= 3) {
                this.log("  Creating User MBean for user " + user);
            }
            if (MBeanUtils.createMBean(user) != null) continue;
            throw new IllegalArgumentException("Cannot create User MBean for user " + user);
        }
    }

    protected void destroyMBeans() {
        if (this.debug >= 1) {
            this.log("Destroying MBeans for Global JNDI Resources");
        }
    }

    protected void log(String message) {
        this.stream.print("GlobalResourcesLifecycleListener: ");
        this.stream.println(message);
    }

    protected void log(String message, Throwable throwable) {
        this.log(message);
        throwable.printStackTrace(this.stream);
    }
}

