/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.Context;
import org.apache.catalina.Group;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Role;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;

public class UserDatabaseRealm
extends RealmBase {
    protected UserDatabase database = null;
    protected final String info = "org.apache.catalina.realm.UserDatabaseRealm/1.0";
    protected static final String name = "UserDatabaseRealm";
    protected String resourceName = "UserDatabase";
    private static StringManager sm;

    public String getInfo() {
        return "org.apache.catalina.realm.UserDatabaseRealm/1.0";
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Principal authenticate(String username, String credentials) {
        User user = this.database.findUser(username);
        if (user == null) {
            return null;
        }
        boolean validated = false;
        validated = this.hasMessageDigest() ? this.digest(credentials).equalsIgnoreCase(user.getPassword()) : this.digest(credentials).equals(user.getPassword());
        if (!validated) {
            if (this.debug >= 2) {
                this.log(sm.getString("userDatabaseRealm.authenticateFailure", username));
            }
            return null;
        }
        if (this.debug >= 2) {
            this.log(sm.getString("userDatabaseRealm.authenticateSuccess", username));
        }
        ArrayList<String> combined = new ArrayList<String>();
        Iterator roles = user.getRoles();
        while (roles.hasNext()) {
            Role role = (Role)roles.next();
            String rolename = role.getRolename();
            if (combined.contains(rolename)) continue;
            combined.add(rolename);
        }
        Iterator groups = user.getGroups();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            roles = group.getRoles();
            while (roles.hasNext()) {
                Role role = (Role)roles.next();
                String rolename = role.getRolename();
                if (combined.contains(rolename)) continue;
                combined.add(rolename);
            }
        }
        return new GenericPrincipal(this, user.getUsername(), user.getPassword(), combined);
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return null;
    }

    public synchronized void start() throws LifecycleException {
        try {
            StandardServer server = (StandardServer)ServerFactory.getServer();
            Context context = server.getGlobalNamingContext();
            this.database = (UserDatabase)context.lookup(this.resourceName);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log(sm.getString("userDatabaseRealm.lookup", this.resourceName), e);
            this.database = null;
        }
        if (this.database == null) {
            throw new LifecycleException(sm.getString("userDatabaseRealm.noDatabase", this.resourceName));
        }
        super.start();
    }

    public synchronized void stop() throws LifecycleException {
        super.stop();
        this.database = null;
    }

    static {
        name = name;
        sm = StringManager.getManager("org.apache.catalina.realm");
    }
}

