/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import java.util.Vector;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Service;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpLogger;
import org.apache.catalina.net.DefaultServerSocketFactory;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.util.LifecycleSupport;

public class WarpConnector
implements Connector,
Lifecycle,
Runnable {
    private Thread thread = null;
    private ServerSocket server = null;
    private WarpLogger logger = null;
    private Vector applications = new Vector();
    protected int uniqueId = -1;
    private Container container = null;
    private boolean enableLookups = false;
    private ServerSocketFactory factory = null;
    private int redirectPort = 443;
    private String scheme = "warp";
    private boolean secure = false;
    private Service service = null;
    private String info = null;
    private String address = null;
    private int port = 8008;
    private int acceptCount = 10;
    private String appBase = "webapps";
    private int debug = 0;
    private LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private boolean initialized = false;
    private boolean started = false;

    public WarpConnector() {
        this.logger = new WarpLogger(this);
        this.uniqueId = new Random().nextInt();
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    protected Context applicationContext(int n) {
        try {
            return (Context)this.applications.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    protected int applicationId(Context context) {
        int n = this.applications.indexOf(context);
        if (n == -1) {
            this.applications.add(context);
            n = this.applications.indexOf(context);
        }
        return n;
    }

    public Request createRequest() {
        return null;
    }

    public Response createResponse() {
        return null;
    }

    public LifecycleListener[] findLifecycleListeners() {
        return null;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAppBase() {
        return this.appBase;
    }

    public Container getContainer() {
        return this.container;
    }

    public int getDebug() {
        return this.debug;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public ServerSocketFactory getFactory() {
        if (this.factory == null) {
            WarpConnector warpConnector = this;
            synchronized (warpConnector) {
                this.factory = new DefaultServerSocketFactory();
            }
        }
        return this.factory;
    }

    public String getInfo() {
        if (this.info == null) {
            WarpConnector warpConnector = this;
            synchronized (warpConnector) {
                this.info = String.valueOf(this.getClass().getName()) + "/" + 10 + 0;
            }
        }
        return this.info;
    }

    public int getPort() {
        return this.port;
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public Service getService() {
        return this.service;
    }

    public void initialize() throws LifecycleException {
        if (this.initialized) {
            throw new LifecycleException("Already initialized");
        }
        this.initialized = true;
        try {
            ServerSocketFactory serverSocketFactory = this.getFactory();
            int n = this.getPort();
            int n2 = this.getAcceptCount();
            if (this.getAddress() == null) {
                this.server = serverSocketFactory.createSocket(n, n2);
            } else {
                InetAddress inetAddress = InetAddress.getByName(this.getAddress());
                this.server = serverSocketFactory.createSocket(n, n2, inetAddress);
            }
        }
        catch (Exception exception) {
            throw new LifecycleException("Error creating server socket (" + exception.getClass().getName() + ")", (Throwable)exception);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void run() {
        try {
            while (this.isStarted()) {
                Socket socket = this.server.accept();
                InetAddress inetAddress = socket.getInetAddress();
                InetAddress inetAddress2 = socket.getLocalAddress();
                int n = socket.getPort();
                int n2 = socket.getLocalPort();
                this.logger.log("Connection from " + inetAddress + ":" + n + " to " + inetAddress2 + ":" + n2);
                WarpConnection warpConnection = new WarpConnection();
                warpConnection.setConnector(this);
                warpConnection.setSocket(socket);
                this.addLifecycleListener(warpConnection);
                warpConnection.start();
            }
        }
        catch (IOException iOException) {
            this.logger.log("Error accepting requests", iOException);
        }
    }

    public void setAcceptCount(int n) {
        this.acceptCount = n;
    }

    public void setAddress(int n) {
        if (n < 1 || n > 65535) {
            throw new IllegalArgumentException("Invalid port " + n);
        }
        this.port = n;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public void setAppBase(String string) {
        this.appBase = string;
    }

    public void setContainer(Container container) {
        this.container = container;
        this.logger.setContainer(container);
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public void setEnableLookups(boolean bl) {
        this.enableLookups = bl;
    }

    public void setFactory(ServerSocketFactory serverSocketFactory) {
        if (serverSocketFactory == null) {
            throw new NullPointerException();
        }
        this.factory = serverSocketFactory;
    }

    public void setInfo(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.info = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setRedirectPort(int n) {
        if (n < 1 || n > 65535) {
            throw new IllegalArgumentException("Invalid port " + n);
        }
        this.redirectPort = n;
    }

    public void setScheme(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.scheme = string;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.started) {
            throw new LifecycleException("Already started");
        }
        if (this.server == null) {
            throw new LifecycleException("Server socket not created");
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() throws LifecycleException {
        block3: {
            if (!this.started) {
                throw new LifecycleException("Not started");
            }
            this.lifecycle.fireLifecycleEvent("stop", null);
            this.started = false;
            if (this.server == null) break block3;
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                this.logger.log("Cannot close ServerSocket", iOException);
            }
        }
    }
}

