/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.UnsupportedEncodingException;

public class WarpPacket {
    protected byte[] buffer = new byte[65535];
    protected int size = 0;
    protected int pointer = 0;
    private int type = -1;
    private static final int MAX_LENGTH = 65535;

    public WarpPacket() {
        this.reset();
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer("DATA=");
        int n = 0;
        while (n < this.size) {
            if (this.buffer[n] > 32 && this.buffer[n] < 127) {
                stringBuffer.append((char)this.buffer[n]);
            } else {
                stringBuffer.append("0x");
                String string = Integer.toHexString(this.buffer[n]);
                if (string.length() < 2) {
                    stringBuffer.append('0');
                }
                if (string.length() > 2) {
                    string = string.substring(string.length() - 2);
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(" ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getType() {
        return this.type;
    }

    public int readInteger() {
        if (this.pointer + 4 > this.size) {
            throw new ArrayIndexOutOfBoundsException("No data available");
        }
        int n = this.buffer[this.pointer++] & 0xFF;
        n = (n << 8) + (this.buffer[this.pointer++] & 0xFF);
        n = (n << 8) + (this.buffer[this.pointer++] & 0xFF);
        n = (n << 8) + (this.buffer[this.pointer++] & 0xFF);
        return n;
    }

    public String readString() {
        int n = this.readUnsignedShort();
        try {
            String string = new String(this.buffer, this.pointer, n, "UTF-8");
            this.pointer += n;
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unsupported encoding UTF-8");
        }
    }

    public int readUnsignedShort() {
        if (this.pointer + 2 > this.size) {
            throw new ArrayIndexOutOfBoundsException("No data available");
        }
        int n = this.buffer[this.pointer++] & 0xFF;
        n = (n << 8) + (this.buffer[this.pointer++] & 0xFF);
        return n;
    }

    public void reset() {
        this.pointer = 0;
        this.size = 0;
        this.type = -1;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void writeInteger(int n) {
        if (this.size + 4 >= 65535) {
            throw new ArrayIndexOutOfBoundsException("Too much data");
        }
        this.buffer[this.size++] = (byte)(n >> 24 & 0xFF);
        this.buffer[this.size++] = (byte)(n >> 16 & 0xFF);
        this.buffer[this.size++] = (byte)(n >> 8 & 0xFF);
        this.buffer[this.size++] = (byte)(n & 0xFF);
    }

    public void writeString(String string) {
        try {
            byte[] byArray;
            if (string == null) {
                string = "";
            }
            if (this.size + (byArray = string.getBytes("UTF-8")).length + 2 > 65535) {
                throw new ArrayIndexOutOfBoundsException("Too much data");
            }
            this.writeUnsignedShort(byArray.length);
            System.arraycopy(byArray, 0, this.buffer, this.size, byArray.length);
            this.size += byArray.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unsupported encoding UTF-8");
        }
    }

    public void writeUnsignedShort(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative unsigned short");
        }
        if (n > 65535) {
            throw new IllegalArgumentException("Unsigned short is too big");
        }
        if (this.size + 2 >= 65535) {
            throw new ArrayIndexOutOfBoundsException("Too much data");
        }
        this.buffer[this.size++] = (byte)(n >> 8 & 0xFF);
        this.buffer[this.size++] = (byte)(n & 0xFF);
    }
}

