/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.catalina.Host;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.connector.warp.WarpCertificates;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.connector.warp.WarpSSLData;

public class WarpRequest
extends HttpRequestBase {
    private Stream localstream = new Stream(this);
    private WarpConnection connection;
    private Host host = null;

    public WarpRequest() {
        this.setStream(this.localstream);
    }

    public Object getAttribute(String string) {
        Object object;
        Object object2 = super.getAttribute(string);
        if (object2 != null) {
            return object2;
        }
        if (!this.localstream.request.isSecure()) {
            return null;
        }
        if (string.equals("javax.servlet.request.X509Certificate")) {
            object = null;
            try {
                object = new WarpCertificates(this.localstream.getX509Certificates());
            }
            catch (IOException iOException) {
                return null;
            }
            super.setAttribute("javax.servlet.request.X509Certificate", (Object)((WarpCertificates)object).getCertificates());
        }
        if (string.equals("javax.servlet.request.cipher_suite") || string.equals("javax.servlet.request.key_size") || string.equals("javax.servlet.request.ssl_session")) {
            object = null;
            try {
                object = this.localstream.getSSL();
            }
            catch (IOException iOException) {
                return null;
            }
            if (object == null) {
                return null;
            }
            super.setAttribute("javax.servlet.request.cipher_suite", (Object)((WarpSSLData)object).ciph);
            if (((WarpSSLData)object).size != 0) {
                super.setAttribute("javax.servlet.request.key_size", (Object)new Integer(((WarpSSLData)object).size));
            }
            super.setAttribute("javax.servlet.request.ssl_session", (Object)((WarpSSLData)object).sess);
        }
        return super.getAttribute(string);
    }

    public WarpConnection getConnection() {
        return this.connection;
    }

    public Host getHost() {
        return this.host;
    }

    public void recycle() {
        super.recycle();
        this.localstream.recycle();
        this.setStream(this.localstream);
    }

    public void setConnection(WarpConnection warpConnection) {
        this.connection = warpConnection;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    protected class Stream
    extends InputStream {
        private WarpRequest request = null;
        private WarpPacket packet = null;
        private boolean closed = false;

        protected Stream(WarpRequest warpRequest2) {
            this.request = warpRequest2;
            this.packet = new WarpPacket();
            this.packet.setType(65);
        }

        public void close() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.packet.reset();
            this.packet.setType(66);
            this.closed = true;
        }

        public WarpSSLData getSSL() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.packet.reset();
            this.packet.setType(67);
            this.request.getConnection().send(this.packet);
            this.packet.reset();
            this.request.getConnection().recv(this.packet);
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.packet.getType() == 95) {
                return null;
            }
            if (this.packet.getType() != 83) {
                throw new IOException("Invalid WARP packet type for SSL data");
            }
            WarpSSLData warpSSLData = new WarpSSLData();
            warpSSLData.ciph = this.packet.readString();
            warpSSLData.sess = this.packet.readString();
            warpSSLData.size = this.packet.readInteger();
            return warpSSLData;
        }

        public String getX509Certificates() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.packet.reset();
            this.packet.setType(68);
            this.request.getConnection().send(this.packet);
            this.packet.reset();
            this.request.getConnection().recv(this.packet);
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.packet.getType() == 95) {
                return null;
            }
            if (this.packet.getType() != 82) {
                throw new IOException("Invalid WARP packet type for CC");
            }
            return this.packet.readString();
        }

        public int read() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.packet.pointer < this.packet.size) {
                return this.packet.buffer[this.packet.pointer++] & 0xFF;
            }
            this.packet.reset();
            this.packet.setType(64);
            this.packet.writeUnsignedShort(65535);
            this.request.getConnection().send(this.packet);
            this.packet.reset();
            this.request.getConnection().recv(this.packet);
            if (this.packet.getType() == 66) {
                return -1;
            }
            if (this.packet.getType() != 65) {
                throw new IOException("Invalid WARP packet type for body");
            }
            return this.read();
        }

        public void recycle() {
            this.packet.reset();
            this.packet.setType(65);
            this.closed = false;
        }
    }
}

