/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageDataImpl;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.xml.sax.Attributes;

public class Validator {
    public static void validate(Compiler compiler, Node.Nodes page) throws JasperException {
        page.visit(new PageDirectiveVisitor(compiler));
        PageInfo pageInfo = compiler.getPageInfo();
        String contentType = pageInfo.getContentType();
        if (contentType == null || contentType.indexOf("charset=") < 0) {
            boolean isXml = page.getRoot().isXmlSyntax();
            String defaultType = contentType == null ? (isXml ? "text/xml" : "text/html") : contentType;
            String charset = pageInfo.getPageEncoding();
            if (charset == null) {
                charset = isXml ? "UTF-8" : "ISO-8859-1";
            }
            pageInfo.setContentType(defaultType + ";charset=" + charset);
        }
        page.visit(new ValidateVisitor(compiler));
        Validator.validateXmlView(new PageDataImpl(page), compiler);
        page.visit(new TagExtraInfoVisitor(compiler));
    }

    private static void validateXmlView(PageData xmlView, Compiler compiler) throws JasperException {
        StringBuffer errMsg = null;
        ErrorDispatcher errDisp = compiler.getErrorDispatcher();
        Enumeration enumeration = compiler.getPageInfo().getTagLibraries().elements();
        while (enumeration.hasMoreElements()) {
            TagLibraryInfo tli = (TagLibraryInfo)enumeration.nextElement();
            ValidationMessage[] errors = ((TagLibraryInfoImpl)tli).validate(xmlView);
            if (errors == null || errors.length == 0) continue;
            if (errMsg == null) {
                errMsg = new StringBuffer();
            }
            errMsg.append("<h3>");
            errMsg.append(errDisp.getString("jsp.error.tlv.invalid.page", tli.getShortName()));
            errMsg.append("</h3>");
            int i = 0;
            while (i < errors.length) {
                errMsg.append("<p>");
                errMsg.append(errors[i].getId());
                errMsg.append(": ");
                errMsg.append(errors[i].getMessage());
                errMsg.append("</p>");
                ++i;
            }
        }
        if (errMsg != null) {
            errDisp.jspError(errMsg.toString());
        }
    }

    static class TagExtraInfoVisitor
    extends Node.Visitor {
        private PageInfo pageInfo;
        private ErrorDispatcher err;

        TagExtraInfoVisitor(Compiler compiler) {
            this.pageInfo = compiler.getPageInfo();
            this.err = compiler.getErrorDispatcher();
        }

        public void visit(Node.CustomTag n) throws JasperException {
            TagLibraryInfo tagLibInfo = (TagLibraryInfo)this.pageInfo.getTagLibraries().get(n.getPrefix());
            TagInfo tagInfo = tagLibInfo.getTag(n.getShortName());
            if (tagInfo == null) {
                this.err.jspError(n, "jsp.error.missing.tagInfo", n.getName());
            }
            if (!tagInfo.isValid(n.getTagData())) {
                this.err.jspError(n, "jsp.error.invalid.attributes");
            }
            this.visitBody(n);
        }
    }

    static class ValidateVisitor
    extends Node.Visitor {
        private PageInfo pageInfo;
        private ErrorDispatcher err;
        private static final JspUtil.ValidAttribute[] jspRootAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("version", true)};
        private static final JspUtil.ValidAttribute[] includeDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("file", true)};
        private static final JspUtil.ValidAttribute[] taglibDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("uri", true), new JspUtil.ValidAttribute("prefix", true)};
        private static final JspUtil.ValidAttribute[] includeActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true), new JspUtil.ValidAttribute("flush")};
        private static final JspUtil.ValidAttribute[] paramActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("value", true)};
        private static final JspUtil.ValidAttribute[] forwardActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true)};
        private static final JspUtil.ValidAttribute[] getPropertyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true)};
        private static final JspUtil.ValidAttribute[] setPropertyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true), new JspUtil.ValidAttribute("value"), new JspUtil.ValidAttribute("param")};
        private static final JspUtil.ValidAttribute[] useBeanAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("id", true), new JspUtil.ValidAttribute("scope"), new JspUtil.ValidAttribute("class"), new JspUtil.ValidAttribute("type"), new JspUtil.ValidAttribute("beanName")};
        private static final JspUtil.ValidAttribute[] plugInAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("type", true), new JspUtil.ValidAttribute("code", true), new JspUtil.ValidAttribute("codebase"), new JspUtil.ValidAttribute("align"), new JspUtil.ValidAttribute("archive"), new JspUtil.ValidAttribute("height"), new JspUtil.ValidAttribute("hspace"), new JspUtil.ValidAttribute("jreversion"), new JspUtil.ValidAttribute("name"), new JspUtil.ValidAttribute("vspace"), new JspUtil.ValidAttribute("width"), new JspUtil.ValidAttribute("nspluginurl"), new JspUtil.ValidAttribute("iepluginurl")};

        ValidateVisitor(Compiler compiler) {
            this.pageInfo = compiler.getPageInfo();
            this.err = compiler.getErrorDispatcher();
        }

        public void visit(Node.JspRoot n) throws JasperException {
            JspUtil.checkAttributes("Jsp:root", n.getAttributes(), jspRootAttrs, n.getStart(), this.err);
            this.visitBody(n);
        }

        public void visit(Node.IncludeDirective n) throws JasperException {
            JspUtil.checkAttributes("Include directive", n.getAttributes(), includeDirectiveAttrs, n.getStart(), this.err);
            this.visitBody(n);
        }

        public void visit(Node.TaglibDirective n) throws JasperException {
            JspUtil.checkAttributes("Taglib directive", n.getAttributes(), taglibDirectiveAttrs, n.getStart(), this.err);
        }

        public void visit(Node.ParamAction n) throws JasperException {
            JspUtil.checkAttributes("Param action", n.getAttributes(), paramActionAttrs, n.getStart(), this.err);
            n.setValue(this.getJspAttribute("value", n.getAttributeValue("value"), n.isXmlSyntax()));
        }

        public void visit(Node.IncludeAction n) throws JasperException {
            JspUtil.checkAttributes("Include action", n.getAttributes(), includeActionAttrs, n.getStart(), this.err);
            n.setPage(this.getJspAttribute("page", n.getAttributeValue("page"), n.isXmlSyntax()));
            this.visitBody(n);
        }

        public void visit(Node.ForwardAction n) throws JasperException {
            JspUtil.checkAttributes("Forward", n.getAttributes(), forwardActionAttrs, n.getStart(), this.err);
            n.setPage(this.getJspAttribute("page", n.getAttributeValue("page"), n.isXmlSyntax()));
            this.visitBody(n);
        }

        public void visit(Node.GetProperty n) throws JasperException {
            JspUtil.checkAttributes("GetProperty", n.getAttributes(), getPropertyAttrs, n.getStart(), this.err);
        }

        public void visit(Node.SetProperty n) throws JasperException {
            JspUtil.checkAttributes("SetProperty", n.getAttributes(), setPropertyAttrs, n.getStart(), this.err);
            String name = n.getAttributeValue("name");
            String property = n.getAttributeValue("property");
            String param = n.getAttributeValue("param");
            String value = n.getAttributeValue("value");
            if ("*".equals(property)) {
                if (param != null || value != null) {
                    this.err.jspError(n, "jsp.error.setProperty.invalid");
                }
            } else if (param != null && value != null) {
                this.err.jspError(n, "jsp.error.setProperty.invalid");
            }
            n.setValue(this.getJspAttribute("value", value, n.isXmlSyntax()));
        }

        public void visit(Node.UseBean n) throws JasperException {
            JspUtil.checkAttributes("UseBean", n.getAttributes(), useBeanAttrs, n.getStart(), this.err);
            String name = n.getAttributeValue("id");
            String scope = n.getAttributeValue("scope");
            String className = n.getAttributeValue("class");
            String type = n.getAttributeValue("type");
            BeanRepository beanInfo = this.pageInfo.getBeanRepository();
            if (className == null && type == null) {
                this.err.jspError(n, "jsp.error.useBean.missingType");
            }
            if (beanInfo.checkVariable(name)) {
                this.err.jspError(n, "jsp.error.useBean.duplicate");
            }
            if ("session".equals(scope) && !this.pageInfo.isSession()) {
                this.err.jspError(n, "jsp.error.useBean.noSession");
            }
            Node.JspAttribute jattr = this.getJspAttribute("beanName", n.getAttributeValue("beanName"), n.isXmlSyntax());
            n.setBeanName(jattr);
            if (className != null && jattr != null) {
                this.err.jspError(n, "jsp.error.useBean.notBoth");
            }
            if (className == null) {
                className = type;
            }
            if (scope == null || scope.equals("page")) {
                beanInfo.addPageBean(name, className);
            } else if (scope.equals("request")) {
                beanInfo.addRequestBean(name, className);
            } else if (scope.equals("session")) {
                beanInfo.addSessionBean(name, className);
            } else if (scope.equals("application")) {
                beanInfo.addApplicationBean(name, className);
            } else {
                this.err.jspError(n, "jsp.error.useBean.badScope");
            }
            this.visitBody(n);
        }

        public void visit(Node.PlugIn n) throws JasperException {
            JspUtil.checkAttributes("Plugin", n.getAttributes(), plugInAttrs, n.getStart(), this.err);
            String type = n.getAttributeValue("type");
            if (type == null) {
                this.err.jspError(n, "jsp.error.plugin.notype");
            }
            if (!type.equals("bean") && !type.equals("applet")) {
                this.err.jspError(n, "jsp.error.plugin.badtype");
            }
            if (n.getAttributeValue("code") == null) {
                this.err.jspError(n, "jsp.error.plugin.nocode");
            }
            n.setHeight(this.getJspAttribute("height", n.getAttributeValue("height"), n.isXmlSyntax()));
            n.setWidth(this.getJspAttribute("width", n.getAttributeValue("width"), n.isXmlSyntax()));
            this.visitBody(n);
        }

        public void visit(Node.CustomTag n) throws JasperException {
            TagLibraryInfo tagLibInfo = (TagLibraryInfo)this.pageInfo.getTagLibraries().get(n.getPrefix());
            TagInfo tagInfo = tagLibInfo.getTag(n.getShortName());
            if (tagInfo == null) {
                this.err.jspError(n, "jsp.error.missing.tagInfo", n.getName());
            }
            TagAttributeInfo[] tldAttrs = tagInfo.getAttributes();
            Attributes attrs = n.getAttributes();
            int i = 0;
            while (i < tldAttrs.length) {
                if (tldAttrs[i].isRequired() && attrs.getValue(tldAttrs[i].getName()) == null) {
                    this.err.jspError((Node)n, "jsp.error.missing_attribute", tldAttrs[i].getName(), n.getShortName());
                }
                ++i;
            }
            Hashtable<String, Object> tagDataAttrs = new Hashtable<String, Object>(attrs.getLength());
            Node.JspAttribute[] jspAttrs = new Node.JspAttribute[attrs.getLength()];
            int i2 = 0;
            while (i2 < attrs.getLength()) {
                boolean found = false;
                int j = 0;
                while (j < tldAttrs.length) {
                    if (attrs.getQName(i2).equals(tldAttrs[j].getName())) {
                        jspAttrs[i2] = tldAttrs[j].canBeRequestTime() ? this.getJspAttribute(attrs.getQName(i2), attrs.getValue(i2), n.isXmlSyntax()) : new Node.JspAttribute(attrs.getQName(i2), attrs.getValue(i2), false);
                        if (jspAttrs[i2].isExpression()) {
                            tagDataAttrs.put(attrs.getQName(i2), TagData.REQUEST_TIME_VALUE);
                        } else {
                            tagDataAttrs.put(attrs.getQName(i2), attrs.getValue(i2));
                        }
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    this.err.jspError(n, "jsp.error.bad_attribute", attrs.getQName(i2));
                }
                ++i2;
            }
            TagData tagData = new TagData(tagDataAttrs);
            n.setTagData(tagData);
            n.setJspAttributes(jspAttrs);
            this.visitBody(n);
        }

        private Node.JspAttribute getJspAttribute(String name, String value, boolean isXml) {
            if (value == null) {
                return null;
            }
            if (isXml && value.startsWith("%=")) {
                return new Node.JspAttribute(name, value.substring(2, value.length() - 1), true);
            }
            if (!isXml && value.startsWith("<%=")) {
                return new Node.JspAttribute(name, value.substring(3, value.length() - 2), true);
            }
            return new Node.JspAttribute(name, value, false);
        }
    }

    static class PageDirectiveVisitor
    extends Node.Visitor {
        private PageInfo pageInfo;
        private ErrorDispatcher err;
        private static final JspUtil.ValidAttribute[] pageDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("language"), new JspUtil.ValidAttribute("extends"), new JspUtil.ValidAttribute("import"), new JspUtil.ValidAttribute("session"), new JspUtil.ValidAttribute("buffer"), new JspUtil.ValidAttribute("autoFlush"), new JspUtil.ValidAttribute("isThreadSafe"), new JspUtil.ValidAttribute("info"), new JspUtil.ValidAttribute("errorPage"), new JspUtil.ValidAttribute("isErrorPage"), new JspUtil.ValidAttribute("contentType"), new JspUtil.ValidAttribute("pageEncoding")};
        private boolean languageSeen = false;
        private boolean extendsSeen = false;
        private boolean sessionSeen = false;
        private boolean bufferSeen = false;
        private boolean autoFlushSeen = false;
        private boolean isThreadSafeSeen = false;
        private boolean errorPageSeen = false;
        private boolean isErrorPageSeen = false;
        private boolean contentTypeSeen = false;
        private boolean infoSeen = false;
        private boolean pageEncodingSeen = false;

        PageDirectiveVisitor(Compiler compiler) {
            this.pageInfo = compiler.getPageInfo();
            this.err = compiler.getErrorDispatcher();
        }

        public void visit(Node.PageDirective n) throws JasperException {
            JspUtil.checkAttributes("Page directive", n.getAttributes(), pageDirectiveAttrs, n.getStart(), this.err);
            Attributes attrs = n.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                String attr = attrs.getQName(i);
                String value = attrs.getValue(i);
                if ("language".equals(attr)) {
                    if (this.languageSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.language");
                    }
                    this.languageSeen = true;
                    if (!"java".equalsIgnoreCase(value)) {
                        this.err.jspError(n, "jsp.error.language.nonjava");
                    }
                    this.pageInfo.setLanguage(value);
                } else if ("extends".equals(attr)) {
                    if (this.extendsSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.extends");
                    }
                    this.extendsSeen = true;
                    this.pageInfo.setExtends(value);
                    if (value.indexOf(46) < 0) {
                        n.addImport(value);
                    }
                } else if ("contentType".equals(attr)) {
                    if (this.contentTypeSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.contenttypes");
                    }
                    this.contentTypeSeen = true;
                    this.pageInfo.setContentType(value);
                } else if ("session".equals(attr)) {
                    if (this.sessionSeen) {
                        this.err.jspError(n, "jsp.error.session.multiple");
                    }
                    this.sessionSeen = true;
                    if ("true".equalsIgnoreCase(value)) {
                        this.pageInfo.setSession(true);
                    } else if ("false".equalsIgnoreCase(value)) {
                        this.pageInfo.setSession(false);
                    } else {
                        this.err.jspError(n, "jsp.error.session.invalid");
                    }
                } else if ("buffer".equals(attr)) {
                    if (this.bufferSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.buffer");
                    }
                    this.bufferSeen = true;
                    if ("none".equalsIgnoreCase(value)) {
                        this.pageInfo.setBuffer(0);
                    } else {
                        if (value == null || !value.endsWith("kb")) {
                            this.err.jspError(n, "jsp.error.buffer.invalid");
                        }
                        try {
                            Integer k = new Integer(value.substring(0, value.length() - 2));
                            this.pageInfo.setBuffer(k * 1024);
                        }
                        catch (NumberFormatException e) {
                            this.err.jspError(n, "jsp.error.buffer.invalid");
                        }
                    }
                } else if ("autoFlush".equals(attr)) {
                    if (this.autoFlushSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.autoflush");
                    }
                    this.autoFlushSeen = true;
                    if ("true".equalsIgnoreCase(value)) {
                        this.pageInfo.setAutoFlush(true);
                    } else if ("false".equalsIgnoreCase(value)) {
                        this.pageInfo.setAutoFlush(false);
                    } else {
                        this.err.jspError(n, "jsp.error.autoFlush.invalid");
                    }
                } else if ("isthreadSafe".equals(attr)) {
                    if (this.isThreadSafeSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.threadsafe");
                    }
                    this.isThreadSafeSeen = true;
                    if ("true".equalsIgnoreCase(value)) {
                        this.pageInfo.setThreadSafe(true);
                    } else if ("false".equalsIgnoreCase(value)) {
                        this.pageInfo.setThreadSafe(false);
                    } else {
                        this.err.jspError(n, "jsp.error.isThreadSafe.invalid");
                    }
                } else if ("isErrorPage".equals(attr)) {
                    if (this.isErrorPageSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.iserrorpage");
                    }
                    this.isErrorPageSeen = true;
                    if ("true".equalsIgnoreCase(value)) {
                        this.pageInfo.setIsErrorPage(true);
                    } else if ("false".equalsIgnoreCase(value)) {
                        this.pageInfo.setIsErrorPage(false);
                    } else {
                        this.err.jspError(n, "jsp.error.isErrorPage.invalid");
                    }
                } else if ("errorPage".equals(attr)) {
                    if (this.errorPageSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.errorpage");
                    }
                    this.errorPageSeen = true;
                    this.pageInfo.setErrorPage(value);
                } else if ("info".equals(attr)) {
                    if (this.infoSeen) {
                        this.err.jspError(n, "jsp.error.info.multiple");
                    }
                    this.infoSeen = true;
                } else if ("pageEncoding".equals(attr)) {
                    if (this.pageEncodingSeen) {
                        this.err.jspError(n, "jsp.error.page.multiple.pageencoding");
                    }
                    this.pageEncodingSeen = true;
                    this.pageInfo.setPageEncoding(value);
                }
                ++i;
            }
            if (this.pageInfo.getBuffer() == 0 && !this.pageInfo.isAutoFlush()) {
                this.err.jspError(n, "jsp.error.page.badCombo");
            }
            this.pageInfo.addImports(n.getImports());
        }
    }
}

