/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.runtime.ServletResponseWrapperInclude;

public class JspRuntimeLibrary {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;

    public static Object convert(String propertyName, String s, Class t, Class propertyEditorClass) throws JasperException {
        try {
            if (s == null) {
                if (t.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JspRuntimeLibrary.class$("java.lang.Boolean")) : class$java$lang$Boolean) || t.equals(Boolean.TYPE)) {
                    s = "false";
                } else {
                    return null;
                }
            }
            if (propertyEditorClass != null) {
                return JspRuntimeLibrary.getValueFromBeanInfoPropertyEditor(t, propertyName, s, propertyEditorClass);
            }
            if (t.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JspRuntimeLibrary.class$("java.lang.Boolean")) : class$java$lang$Boolean) || t.equals(Boolean.TYPE)) {
                s = s.equalsIgnoreCase("on") || s.equalsIgnoreCase("true") ? "true" : "false";
                return new Boolean(s);
            }
            if (t.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = JspRuntimeLibrary.class$("java.lang.Byte")) : class$java$lang$Byte) || t.equals(Byte.TYPE)) {
                return new Byte(s);
            }
            if (t.equals(class$java$lang$Character == null ? (class$java$lang$Character = JspRuntimeLibrary.class$("java.lang.Character")) : class$java$lang$Character) || t.equals(Character.TYPE)) {
                return s.length() > 0 ? new Character(s.charAt(0)) : null;
            }
            if (t.equals(class$java$lang$Short == null ? (class$java$lang$Short = JspRuntimeLibrary.class$("java.lang.Short")) : class$java$lang$Short) || t.equals(Short.TYPE)) {
                return new Short(s);
            }
            if (t.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = JspRuntimeLibrary.class$("java.lang.Integer")) : class$java$lang$Integer) || t.equals(Integer.TYPE)) {
                return new Integer(s);
            }
            if (t.equals(class$java$lang$Float == null ? (class$java$lang$Float = JspRuntimeLibrary.class$("java.lang.Float")) : class$java$lang$Float) || t.equals(Float.TYPE)) {
                return new Float(s);
            }
            if (t.equals(class$java$lang$Long == null ? (class$java$lang$Long = JspRuntimeLibrary.class$("java.lang.Long")) : class$java$lang$Long) || t.equals(Long.TYPE)) {
                return new Long(s);
            }
            if (t.equals(class$java$lang$Double == null ? (class$java$lang$Double = JspRuntimeLibrary.class$("java.lang.Double")) : class$java$lang$Double) || t.equals(Double.TYPE)) {
                return new Double(s);
            }
            if (t.equals(class$java$lang$String == null ? (class$java$lang$String = JspRuntimeLibrary.class$("java.lang.String")) : class$java$lang$String)) {
                return s;
            }
            if (t.equals(class$java$io$File == null ? (class$java$io$File = JspRuntimeLibrary.class$("java.io.File")) : class$java$io$File)) {
                return new File(s);
            }
            if (t.getName().equals("java.lang.Object")) {
                return new Object[]{s};
            }
            return JspRuntimeLibrary.getValueFromPropertyEditorManager(t, propertyName, s);
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
    }

    public static void introspect(Object bean, ServletRequest request) throws JasperException {
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = request.getParameter(name);
            JspRuntimeLibrary.introspecthelper(bean, name, value, request, name, true);
        }
    }

    public static void introspecthelper(Object bean, String prop, String value, ServletRequest request, String param, boolean ignoreMethodNF) throws JasperException {
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedIntrospectHelper dp = new PrivilegedIntrospectHelper(bean, prop, value, request, param, ignoreMethodNF);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                throw (JasperException)((Object)e);
            }
        } else {
            JspRuntimeLibrary.internalIntrospecthelper(bean, prop, value, request, param, ignoreMethodNF);
        }
    }

    private static void internalIntrospecthelper(Object bean, String prop, String value, ServletRequest request, String param, boolean ignoreMethodNF) throws JasperException {
        Method method = null;
        Class<?> type = null;
        Class<?> propertyEditorClass = null;
        try {
            BeanInfo info = Introspector.getBeanInfo(bean.getClass());
            if (info != null) {
                PropertyDescriptor[] pd = info.getPropertyDescriptors();
                int i = 0;
                while (i < pd.length) {
                    if (pd[i].getName().equals(prop)) {
                        method = pd[i].getWriteMethod();
                        type = pd[i].getPropertyType();
                        propertyEditorClass = pd[i].getPropertyEditorClass();
                        break;
                    }
                    ++i;
                }
            }
            if (method != null) {
                if (type.isArray()) {
                    if (request == null) {
                        throw new JasperException(Constants.getString("jsp.error.beans.setproperty.noindexset", new Object[0]));
                    }
                    Class<?> t = type.getComponentType();
                    String[] values = request.getParameterValues(param);
                    if (values == null) {
                        return;
                    }
                    if (t.equals(class$java$lang$String == null ? (class$java$lang$String = JspRuntimeLibrary.class$("java.lang.String")) : class$java$lang$String)) {
                        method.invoke(bean, new Object[]{values});
                    } else {
                        Object tmpval = null;
                        JspRuntimeLibrary.createTypedArray(prop, bean, method, values, t, propertyEditorClass);
                    }
                } else {
                    if (value == null || param != null && value.equals("")) {
                        return;
                    }
                    Object oval = JspRuntimeLibrary.convert(prop, value, type, propertyEditorClass);
                    if (oval != null) {
                        method.invoke(bean, oval);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
        if (!ignoreMethodNF && method == null) {
            if (type == null) {
                throw new JasperException(Constants.getString("jsp.error.beans.noproperty", new Object[]{prop, bean.getClass().getName()}));
            }
            throw new JasperException(Constants.getString("jsp.error.beans.nomethod.setproperty", new Object[]{prop, bean.getClass().getName()}));
        }
    }

    public static String toString(Object o) {
        return o == null ? "" : o.toString();
    }

    public static String toString(byte b) {
        return new Byte(b).toString();
    }

    public static String toString(boolean b) {
        return new Boolean(b).toString();
    }

    public static String toString(short s) {
        return new Short(s).toString();
    }

    public static String toString(int i) {
        return new Integer(i).toString();
    }

    public static String toString(float f) {
        return new Float(f).toString();
    }

    public static String toString(long l) {
        return new Long(l).toString();
    }

    public static String toString(double d) {
        return new Double(d).toString();
    }

    public static String toString(char c) {
        return new Character(c).toString();
    }

    public static void createTypedArray(String propertyName, Object bean, Method method, String[] values, Class t, Class propertyEditorClass) throws JasperException {
        try {
            if (propertyEditorClass != null) {
                Integer[] tmpval = new Integer[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = JspRuntimeLibrary.getValueFromBeanInfoPropertyEditor(t, propertyName, values[i], propertyEditorClass);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = JspRuntimeLibrary.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                Integer[] tmpval = new Integer[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = new Integer(values[i]);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = JspRuntimeLibrary.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                Byte[] tmpval = new Byte[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = new Byte(values[i]);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JspRuntimeLibrary.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                Boolean[] tmpval = new Boolean[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = new Boolean(values[i]);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(class$java$lang$Short == null ? (class$java$lang$Short = JspRuntimeLibrary.class$("java.lang.Short")) : class$java$lang$Short)) {
                Short[] tmpval = new Short[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = new Short(values[i]);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(class$java$lang$Long == null ? (class$java$lang$Long = JspRuntimeLibrary.class$("java.lang.Long")) : class$java$lang$Long)) {
                Long[] tmpval = new Long[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = new Long(values[i]);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(class$java$lang$Double == null ? (class$java$lang$Double = JspRuntimeLibrary.class$("java.lang.Double")) : class$java$lang$Double)) {
                Double[] tmpval = new Double[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = new Double(values[i]);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(class$java$lang$Float == null ? (class$java$lang$Float = JspRuntimeLibrary.class$("java.lang.Float")) : class$java$lang$Float)) {
                Float[] tmpval = new Float[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = new Float(values[i]);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(class$java$lang$Character == null ? (class$java$lang$Character = JspRuntimeLibrary.class$("java.lang.Character")) : class$java$lang$Character)) {
                Character[] tmpval = new Character[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = new Character(values[i].charAt(0));
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Integer.TYPE)) {
                int[] tmpval = new int[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = Integer.parseInt(values[i]);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Byte.TYPE)) {
                byte[] tmpval = new byte[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = Byte.parseByte(values[i]);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Boolean.TYPE)) {
                boolean[] tmpval = new boolean[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = Boolean.valueOf(values[i]);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Short.TYPE)) {
                short[] tmpval = new short[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = Short.parseShort(values[i]);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Long.TYPE)) {
                long[] tmpval = new long[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = Long.parseLong(values[i]);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Double.TYPE)) {
                double[] tmpval = new double[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = Double.valueOf(values[i]);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Float.TYPE)) {
                float[] tmpval = new float[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = Float.valueOf(values[i]).floatValue();
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Character.TYPE)) {
                char[] tmpval = new char[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = values[i].charAt(0);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            } else {
                Integer[] tmpval = new Integer[values.length];
                int i = 0;
                while (i < values.length) {
                    tmpval[i] = JspRuntimeLibrary.getValueFromPropertyEditorManager(t, propertyName, values[i]);
                    ++i;
                }
                method.invoke(bean, new Object[]{tmpval});
            }
        }
        catch (Exception ex) {
            throw new JasperException("error in invoking method");
        }
    }

    public static String escapeQueryString(String unescString) {
        if (unescString == null) {
            return null;
        }
        String escString = "";
        String shellSpChars = "&;`'\"|*?~<>^()[]{}$\\\n";
        int index = 0;
        while (index < unescString.length()) {
            char nextChar = unescString.charAt(index);
            if (shellSpChars.indexOf(nextChar) != -1) {
                escString = escString + "\\";
            }
            escString = escString + nextChar;
            ++index;
        }
        return escString;
    }

    public static String decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        if (encoded.indexOf(37) == -1 && encoded.indexOf(43) == -1) {
            return encoded;
        }
        byte[] holdbuffer = new byte[encoded.length()];
        int bufcount = 0;
        int count = 0;
        while (count < encoded.length()) {
            char cur = encoded.charAt(count);
            if (cur == '%') {
                holdbuffer[bufcount++] = (byte)Integer.parseInt(encoded.substring(count + 1, count + 3), 16);
                count = count + 2 >= encoded.length() ? encoded.length() : (count += 2);
            } else {
                holdbuffer[bufcount++] = cur == '+' ? 32 : (byte)cur;
            }
            ++count;
        }
        return new String(holdbuffer, 0, bufcount);
    }

    public static Object handleGetProperty(Object o, String prop) throws JasperException {
        if (o == null) {
            throw new JasperException(Constants.getString("jsp.error.beans.nullbean", new Object[0]));
        }
        Object value = null;
        try {
            Method method = JspRuntimeLibrary.getReadMethod(o.getClass(), prop);
            value = method.invoke(o, null);
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
        return value;
    }

    public static void handleSetProperty(Object bean, String prop, Object value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, value);
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, int value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Integer(value));
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, short value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Short(value));
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, long value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Long(value));
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, double value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Double(value));
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, float value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Float(value));
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, char value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Character(value));
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, byte value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Byte(value));
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, boolean value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, new Boolean(value));
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
    }

    public static Method getWriteMethod(Class beanClass, String prop) throws JasperException {
        Class<?> type;
        Method method;
        block7: {
            method = null;
            type = null;
            try {
                BeanInfo info = Introspector.getBeanInfo(beanClass);
                if (info != null) {
                    PropertyDescriptor[] pd = info.getPropertyDescriptors();
                    int i = 0;
                    while (i < pd.length) {
                        if (pd[i].getName().equals(prop)) {
                            method = pd[i].getWriteMethod();
                            type = pd[i].getPropertyType();
                            break block7;
                        }
                        ++i;
                    }
                    break block7;
                }
                throw new JasperException(Constants.getString("jsp.error.beans.nobeaninfo", new Object[]{beanClass.getName()}));
            }
            catch (Exception ex) {
                throw new JasperException(ex);
            }
        }
        if (method == null) {
            if (type == null) {
                throw new JasperException(Constants.getString("jsp.error.beans.noproperty", new Object[]{prop, beanClass.getName()}));
            }
            throw new JasperException(Constants.getString("jsp.error.beans.nomethod.setproperty", new Object[]{prop, beanClass.getName()}));
        }
        return method;
    }

    public static Method getReadMethod(Class beanClass, String prop) throws JasperException {
        Class<?> type;
        Method method;
        block7: {
            method = null;
            type = null;
            try {
                BeanInfo info = Introspector.getBeanInfo(beanClass);
                if (info != null) {
                    PropertyDescriptor[] pd = info.getPropertyDescriptors();
                    int i = 0;
                    while (i < pd.length) {
                        if (pd[i].getName().equals(prop)) {
                            method = pd[i].getReadMethod();
                            type = pd[i].getPropertyType();
                            break block7;
                        }
                        ++i;
                    }
                    break block7;
                }
                throw new JasperException(Constants.getString("jsp.error.beans.nobeaninfo", new Object[]{beanClass.getName()}));
            }
            catch (Exception ex) {
                throw new JasperException(ex);
            }
        }
        if (method == null) {
            if (type == null) {
                throw new JasperException(Constants.getString("jsp.error.beans.noproperty", new Object[]{prop, beanClass.getName()}));
            }
            throw new JasperException(Constants.getString("jsp.error.beans.nomethod", new Object[]{prop, beanClass.getName()}));
        }
        return method;
    }

    public static Object getValueFromBeanInfoPropertyEditor(Class attrClass, String attrName, String attrValue, Class propertyEditorClass) throws JasperException {
        try {
            PropertyEditor pe = (PropertyEditor)propertyEditorClass.newInstance();
            pe.setAsText(attrValue);
            return pe.getValue();
        }
        catch (Exception ex) {
            throw new JasperException("Unable to convert string '" + attrValue + "' to class " + attrClass.getName() + " for attribute " + attrName + ": " + ex);
        }
    }

    public static Object getValueFromPropertyEditorManager(Class attrClass, String attrName, String attrValue) throws JasperException {
        try {
            PropertyEditor propEditor = PropertyEditorManager.findEditor(attrClass);
            if (propEditor != null) {
                propEditor.setAsText(attrValue);
                return propEditor.getValue();
            }
            throw new IllegalArgumentException("Property Editor not registered with the PropertyEditorManager");
        }
        catch (IllegalArgumentException ex) {
            throw new JasperException("Unable to convert string '" + attrValue + "' to class " + attrClass.getName() + " for attribute " + attrName + ": " + ex);
        }
    }

    public static String getContextRelativePath(ServletRequest request, String relativePath) {
        if (relativePath.startsWith("/")) {
            return relativePath;
        }
        if (!(request instanceof HttpServletRequest)) {
            return relativePath;
        }
        HttpServletRequest hrequest = (HttpServletRequest)request;
        String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (uri == null) {
            uri = hrequest.getServletPath();
        }
        return uri.substring(0, uri.lastIndexOf(47)) + '/' + relativePath;
    }

    public static void include(HttpServletRequest request, HttpServletResponse response, String relativePath, JspWriter out, boolean flush) throws IOException, ServletException {
        if (flush && !(out instanceof BodyContent)) {
            out.flush();
        }
        String resourcePath = JspRuntimeLibrary.getContextRelativePath((ServletRequest)request, relativePath);
        RequestDispatcher rd = request.getRequestDispatcher(resourcePath);
        rd.include((ServletRequest)request, (ServletResponse)new ServletResponseWrapperInclude((ServletResponse)response, out));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class PrivilegedIntrospectHelper
    implements PrivilegedExceptionAction {
        private Object bean;
        private String prop;
        private String value;
        private ServletRequest request;
        private String param;
        private boolean ignoreMethodNF;

        PrivilegedIntrospectHelper(Object bean, String prop, String value, ServletRequest request, String param, boolean ignoreMethodNF) {
            this.bean = bean;
            this.prop = prop;
            this.value = value;
            this.request = request;
            this.param = param;
            this.ignoreMethodNF = ignoreMethodNF;
        }

        public Object run() throws JasperException {
            JspRuntimeLibrary.internalIntrospecthelper(this.bean, this.prop, this.value, this.request, this.param, this.ignoreMethodNF);
            return null;
        }
    }
}

