/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.servlets.ManagerServlet;
import org.apache.catalina.util.ServerInfo;

public final class HTMLManagerServlet
extends ManagerServlet {
    private static final String HTML_HEADER_SECTION = "<html> \n<head> \n<style> \n  table { width: 100%; } \n  td.page-title {  \n    text-align: center; \n    vertical-align: top; \n    font-family:verdana,sans-serif; \n    font-weight: bold; \n    background: white; \n    color: black; \n  } \n  td.title { \n    text-align: left; \n    vertical-align: top; \n    font-family:verdana,sans-serif; \n    font-style:italic; \n    font-weight: bold; \n    background: #D2A41C; \n  } \n  td.header-left { \n    text-align: left; \n    vertical-align: top; \n    font-family:verdana,sans-serif; \n    font-weight: bold; \n    background: #FFDC75; \n  } \n  td.header-center { \n    text-align: center; \n    vertical-align: top; \n    font-family:verdana,sans-serif; \n    font-weight: bold; \n    background: #FFDC75; \n  } \n  td.row-left { \n    text-align: left; \n    vertical-align: middle; \n    font-family:verdana,sans-serif; \n    color: black; \n    background: white; \n  } \n  td.row-center { \n    text-align: center; \n    vertical-align: middle; \n    font-family:verdana,sans-serif; \n    color: black; \n    background: white; \n  } \n  td.row-right { \n    text-align: right; \n    vertical-align: middle; \n    font-family:verdana,sans-serif; \n    color: black; \n    background: white; \n  } \n</style> \n";
    private static final String BODY_HEADER_SECTION = "<title>{0}</title> \n</head> \n\n<body bgcolor=\"#FFFFFF\"> \n\n<table border=\"2\" cellspacing=\"0\" cellpadding=\"3\" bordercolor=\"#000000\"> \n<tr> \n <td class=\"page-title\" bordercolor=\"#000000\" align=\"left\" nowrap> \n  <font size=\"+2\">{0}</font> \n </td> \n</tr> \n</table> \n<br> \n\n";
    private static final String MESSAGE_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\"> \n <tr> \n  <td class=\"row-left\"><small><b>{0}</b>&nbsp;{1}</small></td>\n </tr> \n</table> \n<br> \n\n";
    private static final String APPS_HEADER_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\"> \n<tr> \n <td colspan=\"10\" class=\"title\">{0}</td> \n</tr> \n<tr> \n <td class=\"header-left\"><small>{1}</small></td> \n <td class=\"header-left\"><small>{2}</small></td> \n <td class=\"header-center\"><small>{3}</small></td> \n <td class=\"header-center\"><small>{4}</small></td> \n <td class=\"header-center\">&nbsp;</td> \n</tr> \n";
    private static final String APPS_ROW_DETAILS_SECTION = "<tr> \n <td class=\"row-left\"><small><a href=\"{0}\">{0}</a></small></td> \n <td class=\"row-left\"><small>{1}</small></td> \n <td class=\"row-center\"><small>{2}</small></td> \n <td class=\"row-center\"><small><a href=\"sessions?path={0}\">{3}</a></small></td> \n";
    private static final String MANAGER_APP_ROW_BUTTON_SECTION = " <td class=\"row-left\"> \n  <small> \n  &nbsp;{1}&nbsp; \n  &nbsp;{2}&nbsp; \n  &nbsp;{3}&nbsp; \n  &nbsp;{4}&nbsp; \n  </small> \n </td> \n</tr> \n";
    private static final String STARTED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\"> \n  <small> \n  &nbsp;{1}&nbsp; \n  &nbsp;<a href=\"stop?path={0}\">{2}</a>&nbsp; \n  &nbsp;<a href=\"reload?path={0}\">{3}</a>&nbsp; \n  &nbsp;<a href=\"remove?path={0}\">{4}</a>&nbsp; \n  </small> \n </td> \n</tr> \n";
    private static final String STOPPED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\"> \n  <small> \n  &nbsp;<a href=\"start?path={0}\">{1}</a>&nbsp; \n  &nbsp;{2}&nbsp; \n  &nbsp;{3}&nbsp; \n  &nbsp;<a href=\"remove?path={0}\">{4}</a>&nbsp; \n  </small> \n </td> \n</tr> \n";
    private static final String INSTALL_SECTION = "<tr> \n <td colspan=\"10\" class=\"header-left\"><small>{0}</small></td>\n</tr> \n<tr> \n<form method=\"get\" action=\"install\"> \n<input type=\"hidden\" name=\"path\"> \n <td colspan=\"10\" class=\"row-left\"> \n  <small>{1}</small> \n  <input type=\"text\" name=\"installPath\" size=\"10\"> \n  &nbsp;<small>{2}</small> \n  <input type=\"text\" name=\"installConfig\" size=\"18\"> \n  &nbsp;<small>{3}</small> \n  <input type=\"text\" name=\"installWar\" size=\"18\">&nbsp; \n  <input type=\"submit\" value=\"{4}\"> \n </td> \n</form> \n</tr> \n</table> \n<br> \n\n";
    private static final String SERVER_HEADER_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\"> \n<tr> \n <td colspan=\"10\" class=\"title\">{0}</td>  \n</tr> \n<tr> \n <td class=\"header-center\"><small>{1}</small></td> \n <td class=\"header-center\"><small>{2}</small></td> \n <td class=\"header-center\"><small>{3}</small></td> \n <td class=\"header-center\"><small>{4}</small></td> \n <td class=\"header-center\"><small>{5}</small></td> \n <td class=\"header-center\"><small>{6}</small></td> \n</tr> \n";
    private static final String SERVER_ROW_SECTION = "<tr> \n <td class=\"row-center\"><small>{0}</small></td> \n <td class=\"row-center\"><small>{1}</small></td> \n <td class=\"row-center\"><small>{2}</small></td> \n <td class=\"row-center\"><small>{3}</small></td> \n <td class=\"row-center\"><small>{4}</small></td> \n <td class=\"row-center\"><small>{5}</small></td> \n</tr> \n</table> \n<br> \n\n";
    private static final String HTML_TAIL_SECTION = "</body> \n</html>";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String command = request.getPathInfo();
        String path = request.getParameter("path");
        String installPath = request.getParameter("installPath");
        String installConfig = request.getParameter("installConfig");
        String installWar = request.getParameter("installWar");
        response.setContentType("text/html");
        Locale locale = Locale.getDefault();
        response.setLocale(locale);
        PrintWriter writer = response.getWriter();
        if (command == null) {
            response.sendRedirect(request.getRequestURI() + "/list");
        } else if (command.equals("/install")) {
            this.install(writer, installConfig, installPath, installWar);
        } else if (command.equals("/list")) {
            this.list(writer, "");
        } else if (command.equals("/reload")) {
            this.reload(writer, path);
        } else if (command.equals("/remove")) {
            this.remove(writer, path);
        } else if (command.equals("/sessions")) {
            this.sessions(writer, path);
        } else if (command.equals("/start")) {
            this.start(writer, path);
        } else if (command.equals("/stop")) {
            this.stop(writer, path);
        } else {
            String message = ManagerServlet.sm.getString("managerServlet.unknownCommand", (Object)command);
            this.list(writer, message);
        }
        writer.flush();
        writer.close();
    }

    protected void install(PrintWriter writer, String config, String path, String war) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.install(printWriter, config, path, war);
        this.list(writer, stringWriter.toString());
    }

    public void list(PrintWriter writer, String message) {
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.deployer.getName() + "'");
        }
        writer.print(HTML_HEADER_SECTION);
        Object[] args = new Object[]{ManagerServlet.sm.getString("htmlManagerServlet.title")};
        writer.print(MessageFormat.format(BODY_HEADER_SECTION, args));
        args = new Object[3];
        args[0] = ManagerServlet.sm.getString("htmlManagerServlet.messageLabel");
        args[1] = message != null ? message : "";
        writer.print(MessageFormat.format(MESSAGE_SECTION, args));
        args = new Object[]{ManagerServlet.sm.getString("htmlManagerServlet.appsTitle"), ManagerServlet.sm.getString("htmlManagerServlet.appsPath"), ManagerServlet.sm.getString("htmlManagerServlet.appsName"), ManagerServlet.sm.getString("htmlManagerServlet.appsAvailable"), ManagerServlet.sm.getString("htmlManagerServlet.appsSessions")};
        writer.print(MessageFormat.format(APPS_HEADER_SECTION, args));
        String[] contextPaths = this.deployer.findDeployedApps();
        TreeMap<String, String> sortedContextPathsMap = new TreeMap<String, String>();
        int i = 0;
        while (i < contextPaths.length) {
            String displayPath = contextPaths[i];
            sortedContextPathsMap.put(displayPath, contextPaths[i]);
            ++i;
        }
        String appsStart = ManagerServlet.sm.getString("htmlManagerServlet.appsStart");
        String appsStop = ManagerServlet.sm.getString("htmlManagerServlet.appsStop");
        String appsReload = ManagerServlet.sm.getString("htmlManagerServlet.appsReload");
        String appsRemove = ManagerServlet.sm.getString("htmlManagerServlet.appsRemove");
        Iterator iterator = sortedContextPathsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String displayPath = (String)entry.getKey();
            String contextPath = (String)entry.getKey();
            Context context = this.deployer.findDeployedApp(contextPath);
            if (displayPath.equals("")) {
                displayPath = "/";
            }
            if (context == null) continue;
            args = new Object[6];
            args[0] = displayPath;
            args[1] = context.getDisplayName();
            if (args[1] == null) {
                args[1] = "&nbsp;";
            }
            args[2] = new Boolean(context.getAvailable());
            args[3] = new Integer(context.getManager().findSessions().length);
            writer.print(MessageFormat.format(APPS_ROW_DETAILS_SECTION, args));
            args = new Object[]{displayPath, appsStart, appsStop, appsReload, appsRemove};
            if (context.getPath().equals(this.context.getPath())) {
                writer.print(MessageFormat.format(MANAGER_APP_ROW_BUTTON_SECTION, args));
                continue;
            }
            if (context.getAvailable()) {
                writer.print(MessageFormat.format(STARTED_APPS_ROW_BUTTON_SECTION, args));
                continue;
            }
            writer.print(MessageFormat.format(STOPPED_APPS_ROW_BUTTON_SECTION, args));
        }
        args = new Object[]{ManagerServlet.sm.getString("htmlManagerServlet.installTitle"), ManagerServlet.sm.getString("htmlManagerServlet.installPath"), ManagerServlet.sm.getString("htmlManagerServlet.installConfig"), ManagerServlet.sm.getString("htmlManagerServlet.installWar"), ManagerServlet.sm.getString("htmlManagerServlet.installButton")};
        writer.print(MessageFormat.format(INSTALL_SECTION, args));
        args = new Object[]{ManagerServlet.sm.getString("htmlManagerServlet.serverTitle"), ManagerServlet.sm.getString("htmlManagerServlet.serverVersion"), ManagerServlet.sm.getString("htmlManagerServlet.serverJVMVersion"), ManagerServlet.sm.getString("htmlManagerServlet.serverJVMVendor"), ManagerServlet.sm.getString("htmlManagerServlet.serverOSName"), ManagerServlet.sm.getString("htmlManagerServlet.serverOSVersion"), ManagerServlet.sm.getString("htmlManagerServlet.serverOSArch")};
        writer.print(MessageFormat.format(SERVER_HEADER_SECTION, args));
        args = new Object[]{ServerInfo.getServerInfo(), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")};
        writer.print(MessageFormat.format(SERVER_ROW_SECTION, args));
        writer.print(HTML_TAIL_SECTION);
    }

    protected void reload(PrintWriter writer, String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.reload(printWriter, path);
        this.list(writer, stringWriter.toString());
    }

    protected void remove(PrintWriter writer, String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.remove(printWriter, path);
        this.list(writer, stringWriter.toString());
    }

    public void sessions(PrintWriter writer, String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.sessions(printWriter, path);
        this.list(writer, stringWriter.toString());
    }

    public void start(PrintWriter writer, String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.start(printWriter, path);
        this.list(writer, stringWriter.toString());
    }

    protected void stop(PrintWriter writer, String path) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.stop(printWriter, path);
        this.list(writer, stringWriter.toString());
    }

    static {
        HTML_HEADER_SECTION = HTML_HEADER_SECTION;
        BODY_HEADER_SECTION = BODY_HEADER_SECTION;
        MESSAGE_SECTION = MESSAGE_SECTION;
        APPS_HEADER_SECTION = APPS_HEADER_SECTION;
        APPS_ROW_DETAILS_SECTION = APPS_ROW_DETAILS_SECTION;
        MANAGER_APP_ROW_BUTTON_SECTION = MANAGER_APP_ROW_BUTTON_SECTION;
        STARTED_APPS_ROW_BUTTON_SECTION = STARTED_APPS_ROW_BUTTON_SECTION;
        STOPPED_APPS_ROW_BUTTON_SECTION = STOPPED_APPS_ROW_BUTTON_SECTION;
        INSTALL_SECTION = INSTALL_SECTION;
        SERVER_HEADER_SECTION = SERVER_HEADER_SECTION;
        SERVER_ROW_SECTION = SERVER_ROW_SECTION;
        HTML_TAIL_SECTION = HTML_TAIL_SECTION;
    }
}

