/*
 * Decompiled with CFR 0.152.
 */
package javax.management.timer;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.timer.TimerMBean;
import javax.management.timer.TimerNotification;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.timer.TimerTask;
import mx4j.util.TimeQueue;

public class Timer
extends NotificationBroadcasterSupport
implements TimerMBean,
MBeanRegistration {
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    private TimeQueue m_queue = new TimeQueue();
    private boolean m_isActive;
    private int m_notificationID;
    private HashMap m_tasks = new HashMap();
    private boolean m_sendPastNotification;
    private String m_loggerString = "jmx.mbean." + this.getClass().getName();

    private Logger getLogger() {
        return Log.getLogger(this.m_loggerString);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        ObjectName n;
        Logger logger = this.getLogger();
        ObjectName objectName = n = name == null ? new ObjectName(server.getDefaultDomain(), "service", "Timer") : name;
        if (logger.isEnabledFor(0)) {
            logger.trace("Timer service preRegistered");
        }
        return n;
    }

    public void postRegister(Boolean registrationDone) {
        Logger logger = this.getLogger();
        boolean done = registrationDone;
        if (!done) {
            logger.warn("Timer service was NOT registered");
        } else if (logger.isEnabledFor(0)) {
            logger.trace("Timer service postRegistered");
        }
    }

    public void preDeregister() throws Exception {
        Logger logger = this.getLogger();
        this.stop();
        if (logger.isEnabledFor(0)) {
            logger.trace("Timer service preDeregistered");
        }
    }

    public void postDeregister() {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace("Timer service postDeregistered");
        }
    }

    public void start() {
        if (!this.isActive()) {
            Logger logger = this.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace("Starting Timer service...");
            }
            this.m_queue.clear();
            this.m_queue.start();
            ArrayList tasks = this.updateTasks();
            this.scheduleTasks(tasks);
            this.m_isActive = true;
            if (logger.isEnabledFor(0)) {
                logger.trace("Timer service started successfully");
            }
        }
    }

    public void stop() {
        if (this.isActive()) {
            Logger logger = this.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace("Stopping Timer service...");
            }
            this.m_queue.stop();
            this.m_queue.clear();
            this.m_isActive = false;
            if (logger.isEnabledFor(0)) {
                logger.trace("Timer service stopped successfully");
            }
        }
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    public Integer addNotification(String type, String message, Object userData, Date date) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, 0L, 0L);
    }

    public Integer addNotification(String type, String message, Object userData, Date date, long period) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, 0L);
    }

    public Integer addNotification(String type, String message, Object userData, Date date, long period, long occurrences) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("Notification date cannot be null");
        }
        if (period < 0L) {
            throw new IllegalArgumentException("Period cannot be negative");
        }
        if (occurrences < 0L) {
            throw new IllegalArgumentException("Occurrences cannot be negative");
        }
        long now = System.currentTimeMillis();
        if (this.isActive()) {
            long lastTime;
            if (period == 0L && date.getTime() < now) {
                throw new IllegalArgumentException("Notification date cannot be before current date");
            }
            if (period > 0L && occurrences > 0L && (lastTime = date.getTime() + (occurrences - 1L) * period) < now) {
                throw new IllegalArgumentException("Notification date cannot be before current date");
            }
        }
        Integer id = this.addNotificationImpl(type, message, userData, date, period, occurrences);
        if (this.isActive()) {
            TimerTask task = this.getTask(id);
            this.updateTask(task);
            if (!task.isFinished()) {
                this.m_queue.schedule(task);
            }
        }
        return id;
    }

    private Integer addNotificationImpl(String type, String message, Object userData, Date date, long period, long occurrences) {
        Integer id = this.createNotificationID();
        TimerNotification notification = new TimerNotification(type, (Object)this, message, id);
        notification.setUserData(userData);
        TimerTask task = this.createTimerTask(notification, date, period, occurrences);
        Timer timer = this;
        synchronized (timer) {
            this.m_tasks.put(id, task);
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug("Notification added, id is: " + id);
        }
        return id;
    }

    private TimerTask createTimerTask(TimerNotification notification, Date date, long period, long occurrences) {
        TimerTask task = new TimerTask(notification, date, period, occurrences){

            public void run() {
                Timer.this.sendNotification(this.getNotification());
            }
        };
        return task;
    }

    private ArrayList updateTasks() {
        ArrayList<TimerTask> list = new ArrayList<TimerTask>();
        boolean sendPast = this.getSendPastNotifications();
        Timer timer = this;
        synchronized (timer) {
            Iterator i = this.m_tasks.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = this.getNextNonFinishedTaskEntry(i);
                if (entry == null) break;
                TimerTask task = (TimerTask)entry.getValue();
                if (!sendPast) {
                    this.updateTask(task);
                    if (task.isFinished()) continue;
                }
                list.add(task);
            }
            ArrayList<TimerTask> arrayList = list;
            return arrayList;
        }
    }

    private void updateTask(TimerTask task) {
        long now = System.currentTimeMillis();
        long time = task.getNextExecutionTime();
        while (time < now && !task.isFinished()) {
            if (task.isPeriodic()) {
                task.setNextExecutionTime(time + task.getPeriod());
                time = task.getNextExecutionTime();
                continue;
            }
            task.setFinished(true);
        }
    }

    private void scheduleTasks(ArrayList tasks) {
        Timer timer = this;
        synchronized (timer) {
            int i = 0;
            while (i < tasks.size()) {
                TimerTask task = (TimerTask)tasks.get(i);
                this.m_queue.schedule(task);
                ++i;
            }
        }
    }

    public void removeNotification(Integer id) throws InstanceNotFoundException {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = this.getTask(id);
            if (t == null) {
                throw new InstanceNotFoundException("Cannot find notification to remove with id: " + id);
            }
            this.m_queue.unschedule(t);
            this.m_tasks.remove(id);
        }
        this.getLogger().info("Notification with id " + id + " removed successfully");
    }

    public void removeNotifications(String type) throws InstanceNotFoundException {
        boolean found = false;
        Timer timer = this;
        synchronized (timer) {
            Iterator i = this.m_tasks.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = this.getNextNonFinishedTaskEntry(i);
                if (entry == null) break;
                TimerTask t = (TimerTask)entry.getValue();
                TimerNotification n = t.getNotification();
                if (!n.getType().equals(type)) continue;
                this.m_queue.unschedule(t);
                this.m_tasks.remove(entry.getKey());
                found = true;
            }
        }
        if (!found) {
            throw new InstanceNotFoundException("Cannot find notification to remove with type: " + type);
        }
    }

    public void removeAllNotifications() {
        Timer timer = this;
        synchronized (timer) {
            this.m_queue.clear();
            this.m_tasks.clear();
            this.m_notificationID = 0;
        }
    }

    public Vector getAllNotificationIDs() {
        Vector vector = new Vector();
        Timer timer = this;
        synchronized (timer) {
            Iterator i = this.m_tasks.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = this.getNextNonFinishedTaskEntry(i);
                if (entry == null) break;
                vector.add(entry.getKey());
            }
        }
        return vector;
    }

    public Vector getNotificationIDs(String type) {
        Vector vector = new Vector();
        Timer timer = this;
        synchronized (timer) {
            Iterator i = this.m_tasks.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = this.getNextNonFinishedTaskEntry(i);
                if (entry == null) break;
                TimerTask t = (TimerTask)entry.getValue();
                TimerNotification n = t.getNotification();
                if (!n.getType().equals(type)) continue;
                vector.add(entry.getKey());
            }
        }
        return vector;
    }

    public boolean getSendPastNotifications() {
        return this.m_sendPastNotification;
    }

    public void setSendPastNotifications(boolean value) {
        this.m_sendPastNotification = value;
    }

    public int getNbNotifications() {
        int count = 0;
        Timer timer = this;
        synchronized (timer) {
            Iterator i = this.m_tasks.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = this.getNextNonFinishedTaskEntry(i);
                if (entry == null) break;
                ++count;
            }
            int n = count;
            return n;
        }
    }

    public boolean isEmpty() {
        Timer timer = this;
        synchronized (timer) {
            boolean bl = this.getNbNotifications() == 0;
            return bl;
        }
    }

    public String getNotificationType(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = this.getTask(id);
            String string = t == null ? null : t.getNotification().getType();
            return string;
        }
    }

    public String getNotificationMessage(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = this.getTask(id);
            String string = t == null ? null : t.getNotification().getMessage();
            return string;
        }
    }

    public Object getNotificationUserData(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = this.getTask(id);
            Object object = t == null ? null : t.getNotification().getUserData();
            return object;
        }
    }

    public Date getDate(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = this.getTask(id);
            Date date = t == null ? null : new Date(t.getDate());
            return date;
        }
    }

    public Long getPeriod(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = this.getTask(id);
            Long l = t == null ? null : new Long(t.getPeriod());
            return l;
        }
    }

    public Long getNbOccurences(Integer id) {
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = this.getTask(id);
            Long l = t == null ? null : new Long(t.getOccurrences());
            return l;
        }
    }

    private Integer createNotificationID() {
        Timer timer = this;
        synchronized (timer) {
            Integer n = new Integer(++this.m_notificationID);
            return n;
        }
    }

    private TimerTask getTask(Integer id) {
        Logger logger = this.getLogger();
        Timer timer = this;
        synchronized (timer) {
            TimerTask t = (TimerTask)this.m_tasks.get(id);
            if (logger.isEnabledFor(10)) {
                logger.debug("Retrieving task with id " + id + ": " + t);
            }
            if (t != null && t.isFinished()) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Task with id " + id + " is expired, removing it");
                }
                this.m_tasks.remove(id);
                t = null;
            }
            TimerTask timerTask = t;
            return timerTask;
        }
    }

    private Map.Entry getNextNonFinishedTaskEntry(Iterator i) {
        Logger logger = this.getLogger();
        Timer timer = this;
        synchronized (timer) {
            if (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                TimerTask t = (TimerTask)entry.getValue();
                if (t.isFinished()) {
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Found an expired notification, removing it: " + t);
                    }
                    i.remove();
                    Map.Entry entry2 = this.getNextNonFinishedTaskEntry(i);
                    return entry2;
                }
                Map.Entry entry3 = entry;
                return entry3;
            }
            Map.Entry entry = null;
            return entry;
        }
    }
}

