/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server;

import java.util.AbstractCollection;
import java.util.ArrayList;
import mx4j.server.BaseClassLoaderRepository;

final class DefaultClassLoaderRepository
extends BaseClassLoaderRepository {
    private ArrayList m_classLoaders = new ArrayList();

    DefaultClassLoaderRepository() {
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClassWithout(null, className);
    }

    public Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
        ArrayList arrayList = this.m_classLoaders;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.m_classLoaders.size()) {
                try {
                    ClassLoader cl = (ClassLoader)this.m_classLoaders.get(i);
                    if (!cl.equals(loader)) {
                        Class<?> clazz = cl.loadClass(className);
                        return clazz;
                    }
                }
                catch (ClassNotFoundException ignored) {
                    // empty catch block
                }
                ++i;
            }
            throw new ClassNotFoundException(className);
        }
    }

    protected void addClassLoader(ClassLoader cl) {
        ArrayList arrayList = this.m_classLoaders;
        synchronized (arrayList) {
            this.m_classLoaders.add(cl);
        }
    }

    protected void removeClassLoader(ClassLoader cl) {
        ArrayList arrayList = this.m_classLoaders;
        synchronized (arrayList) {
            ((AbstractCollection)this.m_classLoaders).remove(cl);
        }
    }

    private int getSize() {
        ArrayList arrayList = this.m_classLoaders;
        synchronized (arrayList) {
            int n = this.m_classLoaders.size();
            return n;
        }
    }
}

