/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.IOException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jk.apr.AprImpl;
import org.apache.jk.common.JniHandler;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;
import org.apache.jk.core.WorkerEnv;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.buf.C2BConverter;

public class Shm
extends JniHandler {
    String file = "/tmp/shm.file";
    int size;
    String host = "localhost";
    int port = 8009;
    String unixSocket;
    boolean help = false;
    boolean unregister = false;
    boolean reset = false;
    String dumpFile = null;
    Vector groups = new Vector();
    static final int SHM_WRITE_SLOT = 2;
    static final int SHM_RESET = 5;
    static final int SHM_DUMP = 6;
    private static Log log;
    static /* synthetic */ Class class$org$apache$jk$common$Shm;

    public void setFile(String f) {
        this.file = f;
    }

    public void setDump(String dumpFile) {
        this.dumpFile = dumpFile;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setReset(boolean b) {
        this.reset = true;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setGroup(String grp) {
        this.groups.addElement(grp);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUnixSocket(String unixSocket) {
        this.unixSocket = unixSocket;
    }

    public void setUnregister(boolean unregister) {
        this.unregister = true;
    }

    public void init() throws IOException {
        super.initNative("shm");
        if (this.apr == null) {
            return;
        }
        if (this.file == null) {
            log.error((Object)"No shm file, disabling shared memory");
            this.apr = null;
            return;
        }
        this.setNativeAttribute("file", this.file);
        if (this.size > 0) {
            this.setNativeAttribute("size", Integer.toString(this.size));
        }
        this.initJkComponent();
    }

    public void resetScoreboard() throws IOException {
        if (this.apr == null) {
            return;
        }
        MsgContext mCtx = this.createMsgContext();
        Msg msg = mCtx.getMsg(0);
        msg.reset();
        msg.appendByte(5);
        this.invoke(msg, mCtx);
    }

    public void dumpScoreboard(String fname) throws IOException {
        if (this.apr == null) {
            return;
        }
        MsgContext mCtx = this.createMsgContext();
        Msg msg = mCtx.getMsg(0);
        C2BConverter c2b = (C2BConverter)mCtx.getNote(1);
        msg.reset();
        msg.appendByte(6);
        this.appendString(msg, fname, c2b);
        this.invoke(msg, mCtx);
    }

    public void registerTomcat(String host, int port, String unixDomain) throws IOException {
        String instanceId = host + ":" + port;
        String slotName = "TOMCAT:" + instanceId;
        MsgContext mCtx = this.createMsgContext();
        Msg msg = mCtx.getMsg(0);
        msg.reset();
        C2BConverter c2b = (C2BConverter)mCtx.getNote(1);
        msg.appendByte(2);
        this.appendString(msg, slotName, c2b);
        int channelCnt = 1;
        if (unixDomain != null) {
            ++channelCnt;
        }
        msg.appendInt(this.groups.size());
        int i = 0;
        while (i < this.groups.size()) {
            this.appendString(msg, (String)this.groups.elementAt(i), c2b);
            this.appendString(msg, instanceId, c2b);
            ++i;
        }
        msg.appendInt(channelCnt);
        this.appendString(msg, "channel.socket:" + host + ":" + port, c2b);
        msg.appendInt(1);
        this.appendString(msg, "tomcatId", c2b);
        this.appendString(msg, instanceId, c2b);
        if (unixDomain != null) {
            this.appendString(msg, "channel.apr:" + unixDomain, c2b);
            msg.appendInt(1);
            this.appendString(msg, "tomcatId", c2b);
            this.appendString(msg, instanceId, c2b);
        }
        System.out.println("Register " + instanceId);
        this.invoke(msg, mCtx);
    }

    public void unRegisterTomcat(String host, int port) throws IOException {
        String slotName = "TOMCAT:" + host + ":" + port;
        MsgContext mCtx = this.createMsgContext();
        Msg msg = mCtx.getMsg(0);
        msg.reset();
        C2BConverter c2b = (C2BConverter)mCtx.getNote(1);
        msg.appendByte(2);
        this.appendString(msg, slotName, c2b);
        msg.appendInt(0);
        msg.appendInt(0);
        System.out.println("UnRegister " + slotName);
        this.invoke(msg, mCtx);
    }

    public void destroy() throws IOException {
        this.destroyJkComponent();
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        if (this.apr == null) {
            return 0;
        }
        log.debug((Object)("ChannelShm.invoke: " + ep));
        super.nativeDispatch(msg, ep, 22, 0);
        return 0;
    }

    public void initCli() throws IOException {
        WorkerEnv wEnv = new WorkerEnv();
        AprImpl apr = new AprImpl();
        wEnv.addHandler("apr", apr);
        wEnv.addHandler("shm", this);
        apr.init();
        if (!apr.isLoaded()) {
            log.error((Object)"No native support. Make sure libapr.so and libjkjni.so are available in LD_LIBRARY_PATH");
            return;
        }
    }

    public void execute() {
        try {
            if (this.help) {
                return;
            }
            this.initCli();
            this.init();
            if (this.reset) {
                this.resetScoreboard();
            } else if (this.dumpFile != null) {
                this.dumpScoreboard(this.dumpFile);
            } else if (this.unregister) {
                this.unRegisterTomcat(this.host, this.port);
            } else {
                this.registerTomcat(this.host, this.port, this.unixSocket);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error executing Shm", (Throwable)ex);
        }
    }

    public void setHelp(boolean b) {
        System.out.println("Usage: ");
        System.out.println("  Shm [OPTIONS]");
        System.out.println();
        System.out.println("  -file SHM_FILE");
        System.out.println("  -group GROUP ( can be specified multiple times )");
        System.out.println("  -host HOST");
        System.out.println("  -port PORT");
        System.out.println("  -unixSocket UNIX_FILE");
        this.help = true;
    }

    public static void main(String[] args) {
        try {
            Shm shm = new Shm();
            if (args.length == 0 || "-?".equals(args[0])) {
                shm.setHelp(true);
                return;
            }
            IntrospectionUtils.processArgs(shm, args);
            shm.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SHM_WRITE_SLOT = 2;
        SHM_RESET = 5;
        SHM_DUMP = 6;
        log = LogFactory.getLog((Class)(class$org$apache$jk$common$Shm == null ? (class$org$apache$jk$common$Shm = Shm.class$("org.apache.jk.common.Shm")) : class$org$apache$jk$common$Shm));
    }
}

