/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler;

import javax.management.Descriptor;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import org.apache.commons.modeler.FeatureInfo;
import org.apache.commons.modeler.ParameterInfo;

public class ConstructorInfo
extends FeatureInfo {
    ModelMBeanConstructorInfo info = null;
    protected String displayName = null;
    protected ParameterInfo[] parameters = new ParameterInfo[0];

    public void setDescription(String description) {
        super.setDescription(description);
        this.info = null;
    }

    public void setName(String name) {
        super.setName(name);
        this.info = null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ParameterInfo[] getSignature() {
        return this.parameters;
    }

    public void addParameter(ParameterInfo parameter) {
        ParameterInfo[] parameterInfoArray = this.parameters;
        synchronized (parameterInfoArray) {
            ParameterInfo[] results = new ParameterInfo[this.parameters.length + 1];
            System.arraycopy(this.parameters, 0, results, 0, this.parameters.length);
            results[this.parameters.length] = parameter;
            this.parameters = results;
            this.info = null;
        }
    }

    public ModelMBeanConstructorInfo createConstructorInfo() {
        if (this.info != null) {
            return this.info;
        }
        ParameterInfo[] params = this.getSignature();
        MBeanParameterInfo[] parameters = new MBeanParameterInfo[params.length];
        int i = 0;
        while (i < params.length) {
            parameters[i] = params[i].createParameterInfo();
            ++i;
        }
        this.info = new ModelMBeanConstructorInfo(this.getName(), this.getDescription(), parameters);
        Descriptor descriptor = this.info.getDescriptor();
        descriptor.removeField("class");
        if (this.getDisplayName() != null) {
            descriptor.setField("displayName", this.getDisplayName());
        }
        this.info.setDescriptor(descriptor);
        return this.info;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ConstructorInfo[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(", description=");
        sb.append(this.description);
        sb.append(", parameters=");
        sb.append(this.parameters.length);
        sb.append("]");
        return sb.toString();
    }
}

