/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler;

import java.util.ArrayList;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.apache.commons.modeler.AttributeInfo;
import org.apache.commons.modeler.ConstructorInfo;
import org.apache.commons.modeler.NotificationInfo;
import org.apache.commons.modeler.OperationInfo;

public class ManagedBean {
    ModelMBeanInfo info = null;
    protected AttributeInfo[] attributes = new AttributeInfo[0];
    protected String className = "org.apache.commons.modeler.BaseModelMBean";
    protected ConstructorInfo[] constructors = new ConstructorInfo[0];
    protected String description = null;
    protected String domain = null;
    protected String group = null;
    protected String name = null;
    protected NotificationInfo[] notifications = new NotificationInfo[0];
    protected OperationInfo[] operations = new OperationInfo[0];
    protected String type = null;

    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
        this.info = null;
    }

    public ConstructorInfo[] getConstructors() {
        return this.constructors;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.info = null;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.info = null;
    }

    public NotificationInfo[] getNotifications() {
        return this.notifications;
    }

    public OperationInfo[] getOperations() {
        return this.operations;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.info = null;
    }

    public void addAttribute(AttributeInfo attribute) {
        AttributeInfo[] attributeInfoArray = this.attributes;
        synchronized (attributeInfoArray) {
            AttributeInfo[] results = new AttributeInfo[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, results, 0, this.attributes.length);
            results[this.attributes.length] = attribute;
            this.attributes = results;
            this.info = null;
        }
    }

    public void addConstructor(ConstructorInfo constructor) {
        ConstructorInfo[] constructorInfoArray = this.constructors;
        synchronized (constructorInfoArray) {
            ConstructorInfo[] results = new ConstructorInfo[this.constructors.length + 1];
            System.arraycopy(this.constructors, 0, results, 0, this.constructors.length);
            results[this.constructors.length] = constructor;
            this.constructors = results;
            this.info = null;
        }
    }

    public void addNotification(NotificationInfo notification) {
        NotificationInfo[] notificationInfoArray = this.notifications;
        synchronized (notificationInfoArray) {
            NotificationInfo[] results = new NotificationInfo[this.notifications.length + 1];
            System.arraycopy(this.notifications, 0, results, 0, this.notifications.length);
            results[this.notifications.length] = notification;
            this.notifications = results;
            this.info = null;
        }
    }

    public void addOperation(OperationInfo operation) {
        OperationInfo[] operationInfoArray = this.operations;
        synchronized (operationInfoArray) {
            OperationInfo[] results = new OperationInfo[this.operations.length + 1];
            System.arraycopy(this.operations, 0, results, 0, this.operations.length);
            results[this.operations.length] = operation;
            this.operations = results;
            this.info = null;
        }
    }

    public ModelMBean createMBean() throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException, RuntimeOperationsException {
        return this.createMBean(null);
    }

    public ModelMBean createMBean(Object instance) throws InstanceNotFoundException, InvalidTargetObjectTypeException, MBeanException, RuntimeOperationsException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.getClassName());
        }
        catch (Exception e) {
            throw new MBeanException(e, "Cannot load ModelMBean class " + this.getClassName());
        }
        ModelMBean mbean = null;
        try {
            mbean = (ModelMBean)clazz.newInstance();
            mbean.setModelMBeanInfo(this.createMBeanInfo());
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (RuntimeOperationsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MBeanException(e, "Cannot instantiate ModelMBean of class " + this.getClassName());
        }
        try {
            if (instance != null) {
                mbean.setManagedResource(instance, "objectReference");
            }
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (InvalidTargetObjectTypeException e) {
            throw e;
        }
        return mbean;
    }

    public ModelMBeanInfo createMBeanInfo() {
        if (this.info != null) {
            return this.info;
        }
        AttributeInfo[] attrs = this.getAttributes();
        ModelMBeanAttributeInfo[] attributes = new ModelMBeanAttributeInfo[attrs.length];
        int i = 0;
        while (i < attrs.length) {
            attributes[i] = attrs[i].createAttributeInfo();
            ++i;
        }
        ConstructorInfo[] consts = this.getConstructors();
        ModelMBeanConstructorInfo[] constructors = new ModelMBeanConstructorInfo[consts.length];
        int i2 = 0;
        while (i2 < consts.length) {
            constructors[i2] = consts[i2].createConstructorInfo();
            ++i2;
        }
        NotificationInfo[] notifs = this.getNotifications();
        ModelMBeanNotificationInfo[] notifications = new ModelMBeanNotificationInfo[notifs.length];
        int i3 = 0;
        while (i3 < notifs.length) {
            notifications[i3] = notifs[i3].createNotificationInfo();
            ++i3;
        }
        OperationInfo[] opers = this.getOperations();
        ModelMBeanOperationInfo[] operations = new ModelMBeanOperationInfo[opers.length];
        int i4 = 0;
        while (i4 < opers.length) {
            operations[i4] = opers[i4].createOperationInfo();
            ++i4;
        }
        ArrayList<ModelMBeanOperationInfo> list = new ArrayList<ModelMBeanOperationInfo>();
        int i5 = 0;
        while (i5 < operations.length) {
            list.add(operations[i5]);
            ++i5;
        }
        int i6 = 0;
        while (i6 < attributes.length) {
            String setMethod;
            Descriptor descriptor = attributes[i6].getDescriptor();
            String getMethod = (String)descriptor.getFieldValue("getMethod");
            if (getMethod != null) {
                OperationInfo oper = new OperationInfo(getMethod, true, attributes[i6].getType());
                list.add(oper.createOperationInfo());
            }
            if ((setMethod = (String)descriptor.getFieldValue("setMethod")) != null) {
                OperationInfo oper = new OperationInfo(setMethod, false, attributes[i6].getType());
                list.add(oper.createOperationInfo());
            }
            ++i6;
        }
        if (list.size() > operations.length) {
            operations = list.toArray(operations);
        }
        this.info = new ModelMBeanInfoSupport(this.getClassName(), this.getDescription(), attributes, constructors, operations, notifications);
        return this.info;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ManagedBean[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(", className=");
        sb.append(this.className);
        sb.append(", description=");
        sb.append(this.description);
        if (this.group != null) {
            sb.append(", group=");
            sb.append(this.group);
        }
        sb.append(", type=");
        sb.append(this.type);
        sb.append("]");
        return sb.toString();
    }
}

