/*****
This file is part of the Babel Program
Copyright (C) 1992-94 W. Patrick Walters and Matthew T. Stahl
The Babel Program is a product of the Dolata Research Group
Dept. of Chemistry
University of Arizona
Tucson, AZ 85721

For more information please contact :

babel@mercury.aichem.arizona.edu
-----------------------------------------------------------------------------
FILE : rdhin.c
AUTHOR(S) : Pat Walters
DATE : 1-94
PURPOSE : routines to read a Hyperchem .HIN file
******/
#include "bbltyp.h"
#define DELIMS "\t\n "

int 
read_hin(FILE *file1, ums_type *mol)
{
  char the_line[300];
  int tokens;
  int i,j,k;
  int max;
  char temp[20];
  long pos = 0;
  int counter = 0;
  char foo[10];

  while (strstr(the_line,"mol") == NULL)
    fgets(the_line,sizeof(the_line),file1);
  Atoms = 0;
  if (strstr(the_line,"mol ") != NULL)
  {
    counter++;
    pos = ftell(file1);
    Atoms = 0;
    while (strstr(the_line,"endmol") == NULL)
    {
      fgets(the_line,sizeof(the_line),file1);
      if (strstr(the_line,"atom"))
      {
	Atoms++;
      }
    }
  }

  ShowProgress(Atoms,"Reading Atoms");
  initialize_ums(&mol);
  fseek(file1,pos,0);
  i = 1;
  strcpy(the_line,"");
  while (strstr(the_line,"endmol") == NULL)
  {
    fgets(the_line,sizeof(the_line),file1);
    if (strstr(the_line,"atom"))
    {
      UpdateProgress();
      tokens = count_tokens(the_line,DELIMS);
      strcpy(Type(i),gettoken(the_line,DELIMS,4));
      clean_atom_type(Type(i));
      strcpy(temp,gettoken(the_line,DELIMS,8));
      X(i) = atof(temp);
      strcpy(temp,gettoken(the_line,DELIMS,9));
      Y(i) = atof(temp);
      strcpy(temp,gettoken(the_line,DELIMS,10));
      Z(i) = atof(temp);
      strcpy(temp,gettoken(the_line,DELIMS,11));
      Valence(i) = atof(temp);
      k = 0;
      max = 12 + 2 * Valence(i);
      for (j = 12; j < max; j+=2)
      {
	strcpy(temp,gettoken(the_line,DELIMS,j));
	Connection(i,k) = atoi(temp);
	k++;
      }
      i++;
    }
  }
  
  assign_types(mol);
  build_connection_table(mol);
  
  return(TRUE);
}









   
    
    
    
	  


