/*****
This file is part of the Babel Program
Copyright (C) 1992-94 W. Patrick Walters and Matthew T. Stahl
The Babel Program is a product of the Dolata Research Group
Dept. of Chemistry
University of Arizona
Tucson, AZ 85721

For more information please contact :

babel@mercury.aichem.arizona.edu
--------------------------------------------------------------------------------

FILE : wrpdb.c
AUTHOR(S) : Pat Walters
DATE : 1-93
PURPOSE : Routines to write a Brookhaven PDB type file.

******/


#include "bbltyp.h"

int
  write_pdb(FILE *file1, ums_type *mol)
{
  int i,j;
  char type_name[5];
  int result;
  char the_res[5];
  int res_num;

  fprintf(file1,"HEADER    PROTEIN\n");
  fprintf(file1,"COMPND    UNNAMED\n");
  fprintf(file1,"AUTHOR    GENERATED BY BABEL %s\n",BABEL_VERSION);

  for (i = 1; i <= Atoms; i ++)
  {
    result =  get_output_type(i,"XYZ",Type(i),type_name,all_caps);

    if (HasResidues)
    {
      if ((ChainNum(i) > 1) && (ChainNum(i) > ChainNum(i-1)))
	fprintf(file1,"TER\n");
      strcpy(the_res,ResName(i));
      strcpy(type_name,AtmId(i));
      res_num = ResNum(i);
    }
    else
    {
      strcpy(the_res,"UNK");
      res_num = 1;
    }

    fprintf(file1,"ATOM   %4d%3s   %3s%3s%3d   %9.3f%8.3f%8.3f  1.00  0.00 \n",
	    i,
	    type_name,
	    the_res,
	    "",
	    res_num,
	    X(i),
	    Y(i),
	    Z(i));
  }
  for (i = 1; i <= Atoms; i ++)
  {
    if (Valence(i) > 0)
      {
	fprintf(file1,"CONECT %4d ",i);
	fprintf(file1,"%4d",Connection(i,0));
	for (j = 1; j < Valence(i); j ++)
	  {
	    fprintf(file1,"%5d",Connection(i,j));
	  }
	fprintf(file1,"\n");
      }
  }
  fprintf(file1,"MASTER        0    0    0    0    0    0    0    0 ");
  fprintf(file1,"%4d    0 %4d    0\n",Atoms,Atoms);          
  fprintf(file1,"END\n");
  return(TRUE);
}


int 
write_idatm(FILE *file1,ums_type *mol)
{
  int count;

  fprintf(file1,"REMARK\n");

  for(count = 1;count <= Atoms; count++)
  {
    fprintf(file1,"ATOM %6d %-4s PXM    64   %9.3f%8.3f%8.3f        \n",
	    count,
	    Type(count),
	    X(count),
	    Y(count),
	    Z(count));
  }
  fprintf(file1,"TER\n");
  return(TRUE);
}

void 
assign_pdb_number(pdb_type_rec *pdb_types, int count)
{
int i;
if (count == 1)
	pdb_types[count].number = 1;
else
for (i = count - 1; i >= 1; i --)
{
if (EQ(pdb_types[count].name,pdb_types[i].name))
	{
	pdb_types[count].number = pdb_types[i].number + 1;
	break;
	}
else
	pdb_types[count].number = 1;
}
}








