extern void add_hydrogens(ums_type *mol);
extern void add_methyl_hydrogen(ums_type *mol, int c_num, int h_num, double b_length);
extern void add_sp_hydrogen(ums_type *mol, int c_num, int h_num, double b_length);
extern void add_sp2_hydrogen(ums_type *mol, int c_num, int h_num, double b_length);
extern void add_vinyl_hydrogens(ums_type *mol, int c_num, int h_num, double b_length);
extern void add_methylene_hydrogens(ums_type *mol, int c_num, int h_num, double b_length);
extern void add_tertiary_hydrogen(ums_type *mol, int c_num, int h_num, double b_length);
extern int type_added_hydrogen(ums_type *mol, int c1, int h1);
extern int count_missing_hydrogens(ums_type *mol);
extern int assign_radii(ums_type *mol);
extern int assign_hybrid_radii(ums_type *mol);
extern int assign_bonds(ums_type *mol);
extern int assign_pdb_bonds(ums_type *mol);
extern int estimate_bond_order(ums_type *mol);
extern void check_bonds(ums_type *mol);
extern int find_close_atoms(ums_type *mol, int num);
extern int zsort_atoms(temp_atom_rec *a, temp_atom_rec *b);
extern int sort_connections(connect_type *a, connect_type *b);
extern double distance(coord_type first, coord_type second);
extern int is_element(char *ele);
extern int get_atomic_number(char *sym);
extern int assign_types(ums_type *mol);
extern void tag_organics(ums_type *mol);
extern int phase1(ums_type *mol);
extern int phase2(ums_type *mol);
extern int phase3(ums_type *mol);
extern int phase4(ums_type *mol);
extern int phase5(ums_type *mol);
extern int phase6(ums_type *mol);
extern int type_hydrogens(ums_type *mol);
extern int valence_four(ums_type *mol);
extern int valence_three(ums_type *mol);
extern int valence_two(ums_type *mol);
extern int valence_one(ums_type *mol);
extern double bond_angle(coord_type a, coord_type b, coord_type c);
extern int count_heavy_atoms(ums_type *mol, int atom_number);
extern int count_free_ox(ums_type *mol, int atom_number);
extern void fix_carboxylates(ums_type *mol);
extern void check_for_amides(ums_type *mol);
extern int assign_bond_order(ums_type *mol);
extern int is_carboxyl(ums_type *mol, int the_bond);
extern int check_for_overflow(ums_type *mol);
extern int check_for_conjugation(ums_type *mol);
extern int atom_in_common(ums_type *mol, int bond1, int bond2);
extern int assign_bond_code(char *input_type);
extern int build_connection_table(ums_type *mol);
extern int member(int first, int second, connect_type *connections, int length);
extern int borrow_types(ums_type *mol1, ums_type *mol2);
extern int main(int argc, char *argv[]);
extern void new_control(ums_type *mol);
extern void init_babel_control(ums_type *mol);
extern void process_command_line_args(int argc, char *argv[], ums_type *mol);
extern void translate_input_code(char *code, ums_type *mol);
extern void translate_output_code(char *code, ums_type *mol);
extern int do_inputs(ums_type *mol);
extern void generate_outfile_name(ums_type *mol, int count);
extern void set_limits(ums_type *mol);
extern int want_this_file(ums_type *mol, int counter, int end);
extern int do_outputs(ums_type *mol);
extern void usage(void);
extern void show_inputs(void);
extern void show_outputs(void);
extern int output_all_formats(char *file_name, ums_type *mol);
extern void write_blurb(void);
extern int do_spline(ums_type *mol);
extern ums_type *delete_atoms(ums_type *mol, char *del_str);
extern int tag_atoms(ums_type *mol, char *del_str);
extern ums_type *build_new_ums(ums_type *mol, int heavy_count);
extern void dissect_connection_table(ums_type *mol);
extern void translate_del_str(char *inp_type, char *del_str);
extern ums_type *delete_water(ums_type *mol);
extern int tag_waters(ums_type *mol);
extern int is_water(ums_type *mol, int i);
extern int int_to_cart(ums_type *mol);
extern void babel_menus(ums_type *mol);
extern void read_menu(ums_type *mol);
extern void write_menu(ums_type *mol);
extern int continuation_menu(ums_type *mol);
extern int get_choice(int min, int max);
extern void set_std_orientation(ums_type *mol);
extern void orient_ums(ums_type *mol, int x1, int x2, int y1, int y2);
extern void center_at_atom(ums_type *mol, int atom);
extern void center_at_atoms(ums_type *mol, int atom[], int count);
extern void center_at_origin(ums_type *mol);
extern void AlignMol(ums_type *mol);
extern void print_bad_connections(ums_type *mol, int atom);
extern void ShowProgress(int i, char *the_string);
extern void UpdateProgress(void);
extern int read_alchemy(FILE *file1, ums_type *mol);
extern int translate_alchemy_bond_order(char *bo_string);
extern int read_ampac_output(FILE *file1, ums_type *mol);
extern int read_bs(FILE *file1, ums_type *mol);
extern int read_boogie(FILE *file1, ums_type *mol);
extern int read_mmads(FILE *file1, ums_type *mol);
extern int read_chem3d1(FILE *file1, ums_type *mol);
extern int read_chem3d2(FILE *file1, ums_type *mol);
extern int read_chem3d(FILE *file1, ums_type *mol, char *keywords, char *type_key);
extern void xlate_c3d_labels(ums_type *mol, int *label);
extern int read_caccrt(FILE *file1, ums_type *mol);
extern int read_cadpac(FILE *file1, ums_type *mol);
extern int read_charmm(FILE *file1, ums_type *mol);
extern int read_csd(FILE *file1, ums_type *mol);
extern int read_element_file(void);
extern int write_elements(element_type elements[]);
extern void atomic_number_to_name(int i, char *name);
extern int read_fdat(FILE *file1, ums_type *mol);
extern void my_strncpy(char *str1, char *str2, int len);
extern double my_atof(char *the_str);
extern double my_atoi(char *the_str);
extern int check_refcode(char *keywords, char *csd_line, ums_type *mol);
extern int read_feat(FILE *file1, ums_type *mol);
extern int read_csd_fractional(FILE *file1, ums_type *mol);
extern int read_fform_fract(FILE *file1, ums_type *mol);
extern void fill_orth_matrix(fract_type *f, matrix_3x3 *m);
extern void fract_to_cart(coord_type *p, matrix_3x3 *m);
extern int read_gamess_output(FILE *file1, ums_type *mol);
extern void bohr_to_angstroms(ums_type *mol);
extern int read_gau_out(FILE *file1, ums_type *mol);
extern int read_gau_zmatrix(FILE *file1, ums_type *mol);
extern int xlate_label(ums_type *mol, char *sym, int max);
extern double xlate_symbol(zsymbol *the_syms, char *sym, int max);
extern int read_hin(FILE *file1, ums_type *mol);
extern int read_biosym_car(FILE *file1, ums_type *mol);
extern int read_mopint(FILE *file1, ums_type *mol);
extern int read_isis(FILE *file1, ums_type *mol);
extern int read_macromodel(FILE *file1, ums_type *mol);
extern void figure_valence(ums_type *mol);
extern int assign_mmd_bond_order(ums_type *mol);
extern int read_mcmol(FILE *file1, ums_type *mol);
extern char *clean_comments(char *mcmol_str);
extern int read_maccs2d(FILE *file1, ums_type *mol);
extern void assign_type_by_bo(ums_type *mol);
extern void add_2d_hydrogens(ums_type *mol);
extern int read_maccs3d(FILE *file1, ums_type *mol);
extern int read_mdl(FILE *file1, ums_type *mol);
extern double get_scale_factor(ums_type *mol);
extern void scale_for_ChemWindow(ums_type *mol);
extern int read_micro(FILE *file1, ums_type *mol);
extern char *strip_front_num(char *the_str);
extern int read_mm2(FILE *file1, ums_type *mol);
extern int read_mm2_input(FILE *file1, ums_type *mol);
extern int read_mm3(FILE *file1, ums_type *mol);
extern int read_molin(FILE *file1, ums_type *mol);
extern void get_cell_params(fract_type *f);
extern int read_mopac_output(FILE *file1, ums_type *mol);
extern int read_mop_cart(FILE *file1, ums_type *mol);
extern int read_pcmodel(FILE *file1, ums_type *mol);
extern void get_pcmod_bonds(char *the_line, ums_type *mol, int i);
extern int read_pdb(FILE *file1, ums_type *mol);
extern void fix_A_type(char *type, char *id, char *res_type);
extern void process_connect_records(FILE *file1, ums_type *mol);
extern void add_bond(ums_type *mol, int i, int j);
extern int read_amber_prep(FILE *file1, ums_type *mol);
extern int read_quanta(FILE *file1, ums_type *mol);
extern void read_quanta_types(char3 *quanta_types);
extern int read_shelx(FILE *file1, ums_type *mol);
extern int count_shelx_atoms(char *the_line);
extern void check_shelx_coords(coord_type *p);
extern int is_good_shelx_line(char *the_line);
extern int read_spartan(FILE *file1, ums_type *mol);
extern int read_spartan_mol_mech(FILE *file1, ums_type *mol);
extern int read_spartan_semiempirical(FILE *file1, ums_type *mol);
extern int read_sybyl_mol(FILE *file1, ums_type *mol);
extern int read_sybyl(FILE *file1, ums_type *mol);
extern void read_types_table(void);
extern void write_type_table(void);
extern void get_input_type(int at_num, char *format, char *input, char *std_type, enum type_err error);
extern int get_output_type(int at_num, char *format, char *input, char *out_type, enum type_err error);
extern int get_std_type(char *format, char *input, char *std_type);
extern int xlate_std_type(char *format, char *std_type, char *output);
extern int read_unichem(FILE *file1, ums_type *mol);
extern int read_wizard(FILE *file1, ums_type *mol);
extern void OrderConnections(ums_type *mol);
extern int read_xed(FILE *file1, ums_type *mol);
extern void xed_add_connection(ums_type *mol, int start, int end, int bnd_num);
extern int read_xyz(FILE *file1, ums_type *mol);
extern ums_type *renumber(ums_type *mol);
extern void find_dist_from_origin(ums_type *mol);
extern void sort_by_dist_to_origin(ums_type *mol);
extern int sort_by_dist(temp_atom_rec *a, temp_atom_rec *b);
extern int print_report_file(FILE *file1, ums_type *mol);
extern void get_element_type(ums_type *mol, int i, char *type);
extern void distance_matrix(ums_type *mol, FILE *file1);
extern void print_torsions(ums_type *mol, FILE *file1);
extern void print_angles(ums_type *mol, FILE *file1);
extern void sort_values(int *a, int *b);
extern int compare_torsion(torsion_rec *t1, torsion_rec *t2);
extern int compare_angle(angle_rec *t1, angle_rec *t2);
extern void get_vectors(ums_type *start, ums_type *end, vect_type *vect[], int increment);
extern void add_step(ums_type *mol, vect_type *vect[]);
extern int found_token(char *strng, char *delimstr, int zindex);
extern int count_tokens(char *tokens, char *delimstr);
extern char *gettoken(char *tokens, char *delimstr, int tokenindex);
extern ums_type *renum_for_zmat(ums_type *mol, int base);
extern void build_z_tree(ums_type *mol, int root, z_tree *tree);
extern void push_hydrogens_to_end(ums_type *mol);
extern void continuity_check(ums_type *mol);
extern void find_z_kids(ums_type *mol, z_tree *tree);
extern void print_z_tree(ums_type *mol, z_tree *tree);
extern void dfs_z_tree(int x, ums_type *mol, z_tree *tree);
extern ums_type *renumber_ums(ums_type *mol, int heavy_count);
extern void uppercase(char *str);
extern void lowercase(char *str);
extern void babel_init(void);
extern void strip_return(char *the_str);
extern int print_ums(ums_type *mol);
extern void show_warning(char *the_warning);
extern void fatal_error(char *the_warning);
extern int print_internal(ums_type *mol);
extern FILE *open_read(char *file_name);
extern FILE *open_write(char *file_name);
extern void close_file(char *file_name, FILE *file1);
extern int initialize_ums(ums_type **mol);
extern void zero_out_ums(ums_type *mol, int start);
extern int reinitialize_ums(ums_type **mol);
extern int initialize_internal(ums_type **mol);
extern int initialize_fractional(ums_type **mol);
extern int initialize_residues(ums_type **mol);
extern int release_ums(ums_type *mol);
extern void clean_atom_type(char id[]);
extern double torsion(coord_type a, coord_type b, coord_type c, coord_type d);
extern void free_line(char *the_line);
extern int check_for_eof(FILE *file1);
extern void read_to_eof(FILE *file1);
extern void make_output_name(char *file_name, char *out_name, int counter);
extern void usage_multi_struct(void  );
extern void toss(FILE *file1, int num);
extern int is_blank_line(char *the_line);
extern char *new_extension(char *filename, char *extension);
extern void point_to_vect(coord_type pt, vect_type *v);
extern void pts_2_vect(ums_type *mol, vect_type *vect, int pt1, int pt2);
extern double vect_ang(vect_type *vect1, vect_type *vect2);
extern double dot(vect_type *vect1, vect_type *vect2);
extern void cross_prod(vect_type *vect1, vect_type *vect2, vect_type *normal);
extern double magnitude(vect_type *vect1);
extern void normalize_vect(vect_type *v1);
extern void vect_sum(vect_type *vect1, vect_type *vect2, vect_type *vect_sm);
extern void vect_diff(vect_type *vect1, vect_type *vect2, vect_type *vect_sm);
extern void scal_x_vect(vect_type *vect1, float scalar);
extern coord_type point_plus_vector(coord_type *p1, vect_type *v1);
extern coord_type point_times_vector(coord_type *p1, vect_type *v1);
extern double determinant_3x3(matrix_3x3 *m);
extern void invert_3x3(matrix_3x3 *m);
extern void dump_3x3(matrix_3x3 *m);
extern void mat_3x3_dot_vect(matrix_3x3 *m, vect_type *v);
extern int write_alchemy(FILE *file1, ums_type *mol);
extern char *strip_extension(char *file_name);
extern int write_bs(FILE *file1, ums_type *mol);
extern int write_bmin_com(FILE *file1, ums_type *mol);
extern int write_chem3d2(FILE *file1, ums_type *mol);
extern int write_chem3d1(FILE *file1, ums_type *mol);
extern int write_mmads(FILE *file1, ums_type *mol);
extern int write_chem3d(FILE *file1, ums_type *mol, char *mol_typ);
extern int write_caccrt(FILE *file1, ums_type *mol);
extern int write_cache(FILE *file1, ums_type *mol);
extern int SymbToNum(char *atSymb);
extern int write_cacao_internal(FILE *file1, ums_type *mol);
extern void add_dummy_atoms(ums_type *mol);
extern void center_at_first_atom(ums_type *mol);
extern void set_hilderbrandt_connections(ums_type *mol);
extern void set_hilderbrandt_geometry(ums_type *mol);
extern int write_chem_draw(FILE *file1, ums_type *mol);
extern int write_conjure_tmplt(FILE *file1, ums_type *mol);
extern int write_cssr(FILE *file1, ums_type *mol);
extern coord_type calc_cell_dimensions(ums_type *mol);
extern void make_fractional(ums_type *mol, coord_type dim);
extern int write_feat(FILE *file1, ums_type *mol);
extern int write_fenske_zmat(FILE *file1, ums_type *mol);
extern int write_gamess_input(FILE *file1, ums_type *mol);
extern int write_gamess_cart(FILE *file1, ums_type *mol);
extern int write_gamess_zmatrix(FILE *file1, ums_type *mol);
extern int write_gamess_mopac(FILE *file1, ums_type *mol);
extern int write_gaussian(FILE *file1, ums_type *mol);
extern double fix_g90_angle(double angle);
extern int write_gaussian_template(FILE *file1, ums_type *mol);
extern void tmplt_cartgeom(ums_type *mol);
extern int write_gaus_crt(FILE *file1, ums_type *mol);
extern int write_hin(FILE *file1, ums_type *mol);
extern int write_icon8(FILE *file1, ums_type *mol);
extern int write_mopac_internal(FILE *file1, ums_type *mol);
extern void cartint(ums_type *mol);
extern void cartgeom(ums_type *mol);
extern int write_maccs(FILE *file1, ums_type *mol);
extern int write_macromodel(FILE *file1, ums_type *mol);
extern int get_bond_order(ums_type *mol, int start, int end);
extern int write_mcmol(FILE *file1, ums_type *mol);
extern void get_atom_info(char *type_name, double *vdw_radius, double *bs_radius, double *red, double *grn, double *blu);
extern void translate_color(int *color, double *red, double *grn, double *blu);
extern int write_molfile(FILE *file1, ums_type *mol);
extern int write_micro(FILE *file1, ums_type *mol);
extern int write_mac_mimic(FILE *file1, ums_type *mol);
extern int write_mm2(FILE *file1, ums_type *mol);
extern int write_mouse(FILE *file1, ums_type *mol);
extern int write_mm2_input(FILE *file1, ums_type *mol);
extern int update_mm2_types(ums_type *mol, int i, int temp_type);
extern int check_for_carbonyl(ums_type *mol, int atom_num);
extern int check_for_cyclopropane(ums_type *mol, int atom1);
extern int bonded(ums_type *mol, int atom1, int atom2);
extern int type_mm2_hydrogens(ums_type *mol, int i);
extern int write_mm3(FILE *file1, ums_type *mol);
extern int write_mopac(FILE *file1, ums_type *mol);
extern int write_pcmod(FILE *file1, ums_type *mol);
extern int write_pdb(FILE *file1, ums_type *mol);
extern int write_idatm(FILE *file1, ums_type *mol);
extern void assign_pdb_number(pdb_type_rec *pdb_types, int count);
extern int write_spartan(FILE *file1, ums_type *mol);
extern int write_sybyl_mol(FILE *file1, ums_type *mol);
extern int write_sybyl(FILE *file1, ums_type *mol);
extern int write_unichem(FILE *file1, ums_type *mol);
extern int write_wizard(FILE *file1, ums_type *mol);
extern int compare_int(int *a, int *b);
extern int write_xed(FILE *file1, ums_type *mol);
extern int write_xyz(FILE *file1, ums_type *mol);
