/*****
This file is part of the Babel Program
Copyright (C) 1992-93 Arizona Board of Regents for the AI in Chemistry Lab
The Babel Program is a product of the Dolata Research Group
Dept. of Chemistry
University of Arizona
Tucson, AZ 85721

For more information please contact :

babel@mercury.aichem.arizona.edu
--------------------------------------------------------------------------------

FILE : wrwiz.c
AUTHOR(S) : Matthew Stahl
DATE : 5-94
PURPOSE : Routines to write format for use with conjure

******/
#include "bbltyp.h"


int 
write_conjure_tmplt(FILE *file1, ums_type *mol)
{ 
  int i,count;
  ums_type *new = NULL;
  
  fprintf(file1,"%s\n",Title);
  fprintf(file1,"%9.4f\n",Energy);
  fprintf(file1,"%5d%5d\n",Atoms,Bonds);
  
  count = 1;
  for (i = 1;i <= Atoms;i++)
    if (NOTEQn("H",Type(i),1))
    {
      Redo(i) = count;
      count++;
    }
  
  for (i = 1;i <= Atoms;i++)
    if (EQn("H",Type(i),1))
    {
      Redo(i) = count;
      count++;
    }

  new = (ums_type *)malloc(sizeof(ums_type));
  
  if (!new)
    fatal_error("Unable to allocate memory for temporary ums");
  
  new->num_atoms = Atoms;
  new->num_bonds = Bonds;
  initialize_ums(&new);

  for (i = 1;i <= Atoms;i++)
  {
    new->atoms[Redo(i)].point.x = X(i);
    new->atoms[Redo(i)].point.y = Y(i);
    new->atoms[Redo(i)].point.z = Z(i);
    strcpy(new->atoms[Redo(i)].type,Type(i));
  }
  
  for (i = 0;i < Bonds;i++)
  {
    new->connections[i].start = Redo(Start(i));
    new->connections[i].end = Redo(End(i));
    new->connections[i].bond_order = Redo(Bond_order(i));
  }
  
  dissect_connection_table(new);

  release_ums(mol);
  mol = new;
  
  for (i = 1;i <= Atoms;i++)
    qsort(mol->atoms[i].connected_atoms,Valence(i),
	  sizeof(int),QSORT_PROTO compare_int);
  
  
  for (i = 1;i <= Atoms; i++)
  {
    fprintf(file1,"%-3s %8.5f  %8.5f  %8.5f\n",
	    Type(i),
	    X(i),
	    Y(i),
	    Z(i));
  }

  for (i = 0;i < Bonds;i++)
    fprintf(file1,"%5d%5d%5d\n",Start(i),End(i),Bond_order(i));

  if (new)
    release_ums(new);
  
  return(TRUE);
}











