/*****
This file is part of the Babel Program
Copyright (C) 1992-94 W. Patrick Walters and Matthew T. Stahl
The Babel Program is a product of the Dolata Research Group
Dept. of Chemistry
University of Arizona
Tucson, AZ 85721

For more information please contact :

babel@mercury.aichem.arizona.edu
--------------------------------------------------------------------------------

ILE : wrfeat.c
AUTHOR(S) : Pat Walters
DATE : 11-92
PURPOSE : Routines to write an XYZ file as used by the Xmol program from MSC
MODIFIED : modified by A. Parrill 7/15/94 to eliminate an unnecessary space
           generated by the type of title field used in the feature ums's
******/



#include "bbltyp.h"

int 
write_feat(FILE *file1, ums_type *mol)
{ 
  int i;
  char type_name[5];
  int result;
  
  fprintf(file1,"%d\n",Atoms);
/*  fprintf(file1,"Energy = %10.2f kcal/mol\n",Energy);*/
  fprintf(file1,"%s",Title);
  for(i = 1;i <= Atoms; i++)
  {
    result = get_output_type(i,"XYZ",Type(i),type_name,all_caps);
    fprintf(file1,"%-3s %8.5f  %8.5f  %8.5f \n",
	    type_name,
	    X(i),
	    Y(i),
	    Z(i));
  }
  return(TRUE);
}


  
      









