/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;

public class GenerateKey
extends Task {
    protected String alias;
    protected String keystore;
    protected String storepass;
    protected String storetype;
    protected String keypass;
    protected String sigalg;
    protected String keyalg;
    protected String dname;
    protected DistinguishedName expandedDname;
    protected int keysize;
    protected int validity;
    protected boolean verbose;

    public DistinguishedName createDname() throws BuildException {
        if (this.expandedDname != null) {
            throw new BuildException("DName sub-element can only be specified once.");
        }
        if (this.dname != null) {
            throw new BuildException("It is not possible to specify dname both as attribute and element.");
        }
        this.expandedDname = new DistinguishedName();
        return this.expandedDname;
    }

    public void execute() throws BuildException {
        if (Project.getJavaVersion().equals("1.1")) {
            throw new BuildException("The genkey task is only available on JDK versions 1.2 or greater");
        }
        if (this.alias == null) {
            throw new BuildException("alias attribute must be set");
        }
        if (this.storepass == null) {
            throw new BuildException("storepass attribute must be set");
        }
        if (this.dname == null && this.expandedDname == null) {
            throw new BuildException("dname must be set");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("keytool -genkey ");
        if (this.verbose) {
            sb.append("-v ");
        }
        sb.append("-alias \"");
        sb.append(this.alias);
        sb.append("\" ");
        if (this.dname != null) {
            sb.append("-dname \"");
            sb.append(this.dname);
            sb.append("\" ");
        }
        if (this.expandedDname != null) {
            sb.append("-dname \"");
            sb.append(this.expandedDname);
            sb.append("\" ");
        }
        if (this.keystore != null) {
            sb.append("-keystore \"");
            sb.append(this.keystore);
            sb.append("\" ");
        }
        if (this.storepass != null) {
            sb.append("-storepass \"");
            sb.append(this.storepass);
            sb.append("\" ");
        }
        if (this.storetype != null) {
            sb.append("-storetype \"");
            sb.append(this.storetype);
            sb.append("\" ");
        }
        sb.append("-keypass \"");
        if (this.keypass != null) {
            sb.append(this.keypass);
        } else {
            sb.append(this.storepass);
        }
        sb.append("\" ");
        if (this.sigalg != null) {
            sb.append("-sigalg \"");
            sb.append(this.sigalg);
            sb.append("\" ");
        }
        if (this.keyalg != null) {
            sb.append("-keyalg \"");
            sb.append(this.keyalg);
            sb.append("\" ");
        }
        if (this.keysize > 0) {
            sb.append("-keysize \"");
            sb.append(this.keysize);
            sb.append("\" ");
        }
        if (this.validity > 0) {
            sb.append("-validity \"");
            sb.append(this.validity);
            sb.append("\" ");
        }
        this.log("Generating Key for " + this.alias);
        ExecTask cmd = (ExecTask)this.project.createTask("exec");
        cmd.setCommand(new Commandline(sb.toString()));
        cmd.setFailonerror(true);
        cmd.setTaskName(this.getTaskName());
        cmd.execute();
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setDname(String dname) {
        if (this.expandedDname != null) {
            throw new BuildException("It is not possible to specify dname both as attribute and element.");
        }
        this.dname = dname;
    }

    public void setKeyalg(String keyalg) {
        this.keyalg = keyalg;
    }

    public void setKeypass(String keypass) {
        this.keypass = keypass;
    }

    public void setKeysize(String keysize) throws BuildException {
        try {
            this.keysize = Integer.parseInt(keysize);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("KeySize attribute should be a integer");
        }
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setSigalg(String sigalg) {
        this.sigalg = sigalg;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public void setStoretype(String storetype) {
        this.storetype = storetype;
    }

    public void setValidity(String validity) throws BuildException {
        try {
            this.validity = Integer.parseInt(validity);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("Validity attribute should be a integer");
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static class DnameParam {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class DistinguishedName {
        private String name;
        private String path;
        private Vector params = new Vector();

        public Object createParam() {
            DnameParam param = new DnameParam();
            this.params.addElement(param);
            return param;
        }

        public String encode(String string) {
            int end = string.indexOf(44);
            if (end == -1) {
                return string;
            }
            StringBuffer sb = new StringBuffer();
            int start = 0;
            while (end != -1) {
                sb.append(string.substring(start, end));
                sb.append("\\,");
                start = end + 1;
                end = string.indexOf(44, start);
            }
            sb.append(string.substring(start));
            return sb.toString();
        }

        public Enumeration getParams() {
            return this.params.elements();
        }

        public String toString() {
            int size = this.params.size();
            StringBuffer sb = new StringBuffer();
            boolean firstPass = true;
            int i = 0;
            while (i < size) {
                if (!firstPass) {
                    sb.append(" ,");
                }
                firstPass = false;
                DnameParam param = (DnameParam)this.params.elementAt(i);
                sb.append(this.encode(param.getName()));
                sb.append('=');
                sb.append(this.encode(param.getValue()));
                ++i;
            }
            return sb.toString();
        }
    }
}

