/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.FileSet;

public class War
extends Jar {
    private File deploymentDescriptor;
    private Vector libFileSets = new Vector();
    private Vector classesFileSets = new Vector();
    private Vector webInfFileSets = new Vector();

    public War() {
        this.archiveType = "war";
        this.emptyBehavior = "create";
    }

    public void addClasses(FileSet fs) {
        this.classesFileSets.addElement(fs);
    }

    public void addLib(FileSet fs) {
        this.libFileSets.addElement(fs);
    }

    public void addWebinf(FileSet fs) {
        this.webInfFileSets.addElement(fs);
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (this.deploymentDescriptor == null) {
            throw new BuildException("webxml attribute is required", this.location);
        }
        this.zipDir(new File(this.deploymentDescriptor.getParent()), zOut, "WEB-INF/");
        super.zipFile(this.deploymentDescriptor, zOut, "WEB-INF/web.xml");
        this.addFiles(this.libFileSets, zOut, "WEB-INF/lib/");
        this.addFiles(this.classesFileSets, zOut, "WEB-INF/classes/");
        this.addFiles(this.webInfFileSets, zOut, "WEB-INF/");
        super.initZipOutputStream(zOut);
    }

    protected boolean isUpToDate(FileScanner[] scanners, File zipFile) throws BuildException {
        if (this.deploymentDescriptor == null) {
            throw new BuildException("webxml attribute is required", this.location);
        }
        FileScanner[] myScanners = new FileScanner[scanners.length + 1 + this.libFileSets.size() + this.classesFileSets.size() + this.webInfFileSets.size()];
        System.arraycopy(scanners, 0, myScanners, 0, scanners.length);
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(new File(this.deploymentDescriptor.getParent()));
        ds.setIncludes(new String[]{this.deploymentDescriptor.getName()});
        ds.scan();
        myScanners[scanners.length] = ds;
        this.addScanners(myScanners, scanners.length + 1, this.libFileSets);
        this.addScanners(myScanners, scanners.length + 1 + this.libFileSets.size(), this.classesFileSets);
        this.addScanners(myScanners, scanners.length + 1 + this.libFileSets.size() + this.classesFileSets.size(), this.webInfFileSets);
        return super.isUpToDate(myScanners, zipFile);
    }

    public void setWarfile(File warFile) {
        super.setZipfile(warFile);
    }

    public void setWebxml(File descr) {
        this.deploymentDescriptor = descr;
    }

    protected void zipFile(File file, ZipOutputStream zOut, String vPath) throws IOException {
        if (!vPath.equalsIgnoreCase("WEB-INF/web.xml")) {
            super.zipFile(file, zOut, vPath);
        } else {
            this.log("Warning: selected " + this.archiveType + " files include a WEB-INF/web.xml which will be ignored " + "(please use webxml attribute to " + this.archiveType + " task)", 1);
        }
    }
}

