/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import org.apache.catalina.loader.StandardClassLoader;

public final class Bootstrap {
    private static int debug = 0;

    private static ClassLoader createCatalinaLoader(ClassLoader parent) {
        File directory;
        if (debug >= 1) {
            Bootstrap.log("Creating CATALINA class loader");
        }
        ArrayList<String> list = new ArrayList<String>();
        File classes = new File(System.getProperty("catalina.home"), "server/classes");
        if (classes.exists() && classes.canRead() && classes.isDirectory()) {
            try {
                URL url = new URL("file", null, String.valueOf(classes.getCanonicalPath()) + "/");
                if (debug >= 1) {
                    Bootstrap.log("  Adding " + url.toString());
                }
                list.add(url.toString());
            }
            catch (IOException e) {
                System.out.println("Cannot create URL for " + classes.getAbsolutePath());
                e.printStackTrace(System.out);
                System.exit(1);
            }
        }
        if (!((directory = new File(System.getProperty("catalina.home"), "server/lib")).exists() && directory.canRead() && directory.isDirectory())) {
            System.out.println("Directory " + directory.getAbsolutePath() + " does not exist");
            System.exit(1);
        }
        String[] filenames = directory.list();
        int i = 0;
        while (i < filenames.length) {
            if (filenames[i].toLowerCase().endsWith(".jar")) {
                File file = new File(directory, filenames[i]);
                try {
                    URL url = new URL("file", null, file.getCanonicalPath());
                    if (debug >= 1) {
                        Bootstrap.log("  Adding " + url.toString());
                    }
                    list.add(url.toString());
                }
                catch (IOException e) {
                    System.out.println("Cannot create URL for " + filenames[i]);
                    e.printStackTrace(System.out);
                    System.exit(1);
                }
            }
            ++i;
        }
        String[] array = list.toArray(new String[list.size()]);
        StandardClassLoader loader = new StandardClassLoader(array, parent);
        return loader;
    }

    private static ClassLoader createCommonLoader() {
        File directory;
        if (debug >= 1) {
            Bootstrap.log("Creating COMMON class loader");
        }
        boolean loadJNDI = true;
        try {
            Class.forName("javax.naming.Context");
            loadJNDI = false;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        ArrayList<String> list = new ArrayList<String>();
        File classes = new File(System.getProperty("catalina.home"), "common/classes");
        if (classes.exists() && classes.canRead() && classes.isDirectory()) {
            try {
                URL url = new URL("file", null, String.valueOf(classes.getCanonicalPath()) + "/");
                if (debug >= 1) {
                    Bootstrap.log("  Adding " + url.toString());
                }
                list.add(url.toString());
            }
            catch (IOException e) {
                System.out.println("Cannot create URL for " + classes.getAbsolutePath());
                e.printStackTrace(System.out);
                System.exit(1);
            }
        }
        if (!((directory = new File(System.getProperty("catalina.home"), "common/lib")).exists() && directory.canRead() && directory.isDirectory())) {
            System.out.println("Directory " + directory.getAbsolutePath() + " does not exist");
            System.exit(1);
        }
        String[] filenames = directory.list();
        int i = 0;
        while (i < filenames.length) {
            String filename = filenames[i].toLowerCase();
            if (filename.endsWith(".jar") && filename.indexOf("bootstrap.jar") == -1 && (loadJNDI || filename.indexOf("jndi.jar") == -1)) {
                File file = new File(directory, filenames[i]);
                try {
                    URL url = new URL("file", null, file.getCanonicalPath());
                    if (debug >= 1) {
                        Bootstrap.log("  Adding " + url.toString());
                    }
                    list.add(url.toString());
                }
                catch (IOException e) {
                    System.out.println("Cannot create URL for " + filenames[i]);
                    e.printStackTrace(System.out);
                    System.exit(1);
                }
            }
            ++i;
        }
        String[] array = list.toArray(new String[list.size()]);
        StandardClassLoader loader = new StandardClassLoader(array);
        return loader;
    }

    private static ClassLoader createSharedLoader(ClassLoader parent) {
        File directory;
        if (debug >= 1) {
            Bootstrap.log("Creating SHARED class loader");
        }
        ArrayList<String> list = new ArrayList<String>();
        File classes = new File(System.getProperty("catalina.home"), "classes");
        if (classes.exists() && classes.canRead() && classes.isDirectory()) {
            try {
                URL url = new URL("file", null, String.valueOf(classes.getCanonicalPath()) + "/");
                if (debug >= 1) {
                    Bootstrap.log("  Adding " + url.toString());
                }
                list.add(url.toString());
            }
            catch (IOException e) {
                System.out.println("Cannot create URL for " + classes.getAbsolutePath());
                e.printStackTrace(System.out);
                System.exit(1);
            }
        }
        if (!((directory = new File(System.getProperty("catalina.home"), "lib")).exists() && directory.canRead() && directory.isDirectory())) {
            System.out.println("Directory " + directory.getAbsolutePath() + " does not exist");
            System.exit(1);
        }
        String[] filenames = directory.list();
        int i = 0;
        while (i < filenames.length) {
            if (filenames[i].toLowerCase().endsWith(".jar")) {
                File file = new File(directory, filenames[i]);
                try {
                    URL url = new URL("file", null, file.getCanonicalPath());
                    if (debug >= 1) {
                        Bootstrap.log("  Adding " + url.toString());
                    }
                    list.add(url.toString());
                }
                catch (IOException e) {
                    System.out.println("Cannot create URL for " + filenames[i]);
                    e.printStackTrace(System.out);
                    System.exit(1);
                }
            }
            ++i;
        }
        String[] array = list.toArray(new String[list.size()]);
        StandardClassLoader loader = new StandardClassLoader(array, parent);
        return loader;
    }

    private static void log(String message) {
        System.out.print("Bootstrap: ");
        System.out.println(message);
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            if ("-debug".equals(args[i])) {
                debug = 1;
            }
            ++i;
        }
        ClassLoader commonLoader = Bootstrap.createCommonLoader();
        ClassLoader catalinaLoader = Bootstrap.createCatalinaLoader(commonLoader);
        ClassLoader sharedLoader = Bootstrap.createSharedLoader(commonLoader);
        Thread.currentThread().setContextClassLoader(catalinaLoader);
        try {
            if (System.getSecurityManager() != null) {
                String basePackage = "org.apache.catalina.";
                catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedGetRequestDispatcher");
                catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedGetResource");
                catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedGetResourcePaths");
                catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedLogMessage");
                catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedLogException");
                catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationContext$PrivilegedLogThrowable");
                catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationDispatcher$PrivilegedForward");
                catalinaLoader.loadClass(String.valueOf(basePackage) + "core.ApplicationDispatcher$PrivilegedInclude");
                catalinaLoader.loadClass(String.valueOf(basePackage) + "session.StandardSession");
                catalinaLoader.loadClass(String.valueOf(basePackage) + "util.CookieTools");
                catalinaLoader.loadClass(String.valueOf(basePackage) + "util.Enumerator");
                catalinaLoader.loadClass("javax.servlet.http.Cookie");
            }
            if (debug >= 1) {
                Bootstrap.log("Loading startup class");
            }
            Class<?> startupClass = catalinaLoader.loadClass("org.apache.catalina.startup.Catalina");
            Object startupInstance = startupClass.newInstance();
            if (debug >= 1) {
                Bootstrap.log("Setting startup class properties");
            }
            String methodName = "setParentClassLoader";
            Class[] paramTypes = new Class[]{Class.forName("java.lang.ClassLoader")};
            Object[] paramValues = new Object[]{sharedLoader};
            Method method = startupInstance.getClass().getMethod(methodName, paramTypes);
            method.invoke(startupInstance, paramValues);
            if (debug >= 1) {
                Bootstrap.log("Calling startup class process() method");
            }
            methodName = "process";
            paramTypes = new Class[]{args.getClass()};
            paramValues = new Object[]{args};
            method = startupInstance.getClass().getMethod(methodName, paramTypes);
            method.invoke(startupInstance, paramValues);
        }
        catch (Exception e) {
            System.out.println("Exception during startup processing");
            e.printStackTrace(System.out);
            System.exit(2);
        }
        System.exit(0);
    }
}

