/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.deploy.LoginConfig;

public final class FormAuthenticator
extends AuthenticatorBase {
    private static final String info = "org.apache.catalina.authenticator.FormAuthenticator/1.0";

    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        String password;
        String username;
        boolean loginAction;
        Principal principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal();
        if (principal != null) {
            if (this.debug >= 1) {
                this.log("Already authenticated '" + principal.getName() + "'");
            }
            return true;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        String contextPath = hreq.getContextPath();
        String requestURI = hreq.getRequestURI();
        response.setContext(request.getContext());
        Session session = null;
        if (requestURI.equals(String.valueOf(contextPath) + config.getLoginPage())) {
            if (this.debug >= 1) {
                this.log("Requesting login page normally");
            }
            return true;
        }
        boolean bl = loginAction = requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check");
        if (!loginAction) {
            session = this.getSession(request, true);
            if (this.debug >= 1) {
                this.log("Save request in session '" + session.getId() + "'");
            }
            this.saveRequest(request, session);
            request.setRequestURI(String.valueOf(contextPath) + config.getLoginPage());
            return true;
        }
        Realm realm = this.context.getRealm();
        principal = realm.authenticate(username = hreq.getParameter("j_username"), password = hreq.getParameter("j_password"));
        if (principal == null) {
            if (this.debug >= 1) {
                this.log("Authentication failed, show error page");
            }
            request.setRequestURI(String.valueOf(contextPath) + config.getErrorPage());
            return true;
        }
        session = this.getSession(request, true);
        if (this.debug >= 1) {
            this.log("restore request from session '" + session.getId() + "'");
        }
        this.register(request, response, principal, "FORM");
        if (this.restoreRequest(request, session)) {
            if (this.debug >= 1) {
                this.log("Proceed to restored request");
            }
            return true;
        }
        if (this.debug >= 1) {
            this.log("Restore of original request failed");
        }
        hres.sendError(400);
        return false;
    }

    public String getInfo() {
        return info;
    }

    private boolean restoreRequest(HttpRequest request, Session session) {
        SavedRequest saved = (SavedRequest)session.getSession().getAttribute("org.apache.catalina.security.REQUEST");
        session.getSession().removeAttribute("org.apache.catalina.security.REQUEST");
        if (saved == null) {
            return false;
        }
        request.clearCookies();
        Iterator cookies = saved.getCookies();
        while (cookies.hasNext()) {
            request.addCookie((Cookie)cookies.next());
        }
        request.clearHeaders();
        Iterator names = saved.getHeaderNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            Iterator values = saved.getHeaderValues(name);
            while (values.hasNext()) {
                request.addHeader(name, (String)values.next());
            }
        }
        request.clearLocales();
        Iterator locales = saved.getLocales();
        while (locales.hasNext()) {
            request.addLocale((Locale)locales.next());
        }
        request.clearParameters();
        Iterator paramNames = saved.getParameterNames();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            String[] paramValues = saved.getParameterValues(paramName);
            request.addParameter(paramName, paramValues);
        }
        request.setMethod(saved.getMethod());
        request.setQueryString(saved.getQueryString());
        request.setRequestURI(saved.getRequestURI());
        return true;
    }

    private void saveRequest(HttpRequest request, Session session) {
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        SavedRequest saved = new SavedRequest();
        Cookie[] cookies = hreq.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                saved.addCookie(cookies[i]);
                ++i;
            }
        }
        Enumeration names = hreq.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = hreq.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                saved.addHeader(name, value);
            }
        }
        Enumeration locales = hreq.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            saved.addLocale(locale);
        }
        Map parameters = hreq.getParameterMap();
        Iterator paramNames = parameters.keySet().iterator();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            String[] paramValues = (String[])parameters.get(paramName);
            saved.addParameter(paramName, paramValues);
        }
        saved.setMethod(hreq.getMethod());
        saved.setQueryString(hreq.getQueryString());
        saved.setRequestURI(hreq.getRequestURI());
        session.getSession().setAttribute("org.apache.catalina.security.REQUEST", (Object)saved);
    }
}

