/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.RequestStream;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

public abstract class RequestBase
implements ServletRequest,
Request {
    protected HashMap attributes = new HashMap();
    protected String authorization = null;
    protected String characterEncoding = null;
    protected Connector connector = null;
    protected int contentLength = -1;
    protected String contentType = null;
    protected Context context = null;
    protected static Locale defaultLocale = Locale.getDefault();
    protected RequestFacade facade = new RequestFacade(this);
    protected static final String info = "org.apache.catalina.connector.RequestBase/1.0";
    protected InputStream input = null;
    protected ArrayList locales = new ArrayList();
    protected String protocol = null;
    protected BufferedReader reader = null;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected Response response = null;
    protected String scheme = null;
    protected boolean secure = false;
    protected String serverName = null;
    protected int serverPort = -1;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected Socket socket = null;
    protected ServletInputStream stream = null;
    protected Wrapper wrapper = null;

    public void addLocale(Locale locale) {
        ArrayList arrayList = this.locales;
        synchronized (arrayList) {
            this.locales.add(locale);
        }
    }

    public ServletInputStream createInputStream() throws IOException {
        return new RequestStream(this);
    }

    public void finishRequest() throws IOException {
        block5: {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {}
            }
            if (this.stream == null) break block5;
            try {
                this.stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Object getAttribute(String name) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            Object v = this.attributes.get(name);
            Object var4_4 = null;
            return v;
        }
    }

    public Enumeration getAttributeNames() {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            Enumerator enumerator = new Enumerator(this.attributes.keySet());
            Object var3_3 = null;
            return enumerator;
        }
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Context getContext() {
        return this.context;
    }

    public String getInfo() {
        return info;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.reader != null) {
            throw new IllegalStateException(sm.getString("requestBase.getInputStream.ise"));
        }
        if (this.stream == null) {
            this.stream = this.createInputStream();
        }
        return this.stream;
    }

    public Locale getLocale() {
        ArrayList arrayList = this.locales;
        synchronized (arrayList) {
            if (this.locales.size() > 0) {
                Locale locale = (Locale)this.locales.get(0);
                Object var3_4 = null;
                return locale;
            }
            Locale locale = defaultLocale;
            Object var3_5 = null;
            return locale;
        }
    }

    public Enumeration getLocales() {
        ArrayList arrayList = this.locales;
        synchronized (arrayList) {
            if (this.locales.size() > 0) {
                Enumerator enumerator = new Enumerator(this.locales);
                Object var3_4 = null;
                return enumerator;
            }
        }
        ArrayList<Locale> results = new ArrayList<Locale>();
        results.add(defaultLocale);
        return new Enumerator(results);
    }

    public abstract String getParameter(String var1);

    public abstract Map getParameterMap();

    public abstract Enumeration getParameterNames();

    public abstract String[] getParameterValues(String var1);

    public String getProtocol() {
        return this.protocol;
    }

    public BufferedReader getReader() throws IOException {
        if (this.stream != null) {
            throw new IllegalStateException(sm.getString("requestBase.getReader.ise"));
        }
        if (this.reader == null) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = "ISO-8859-1";
            }
            InputStreamReader isr = new InputStreamReader((InputStream)this.createInputStream(), encoding);
            this.reader = new BufferedReader(isr);
        }
        return this.reader;
    }

    public String getRealPath(String path) {
        if (this.context == null) {
            return null;
        }
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext == null) {
            return null;
        }
        try {
            return servletContext.getRealPath(path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public ServletRequest getRequest() {
        return this.facade;
    }

    public abstract RequestDispatcher getRequestDispatcher(String var1);

    public Response getResponse() {
        return this.response;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public InputStream getStream() {
        return this.input;
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void recycle() {
        this.attributes.clear();
        this.authorization = null;
        this.characterEncoding = null;
        this.contentLength = -1;
        this.contentType = null;
        this.context = null;
        this.input = null;
        this.locales.clear();
        this.protocol = null;
        this.reader = null;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.response = null;
        this.scheme = null;
        this.secure = false;
        this.serverName = null;
        this.serverPort = -1;
        this.socket = null;
        this.stream = null;
        this.wrapper = null;
    }

    public void removeAttribute(String name) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.put(name, value);
        }
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        byte[] buffer = new byte[]{97};
        String dummy = new String(buffer, enc);
        this.characterEncoding = enc;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setContentLength(int length) {
        this.contentLength = length;
    }

    public void setContentType(String type) {
        this.contentType = type;
        if (type.indexOf(";") >= 0) {
            this.characterEncoding = RequestUtil.parseCharacterEncoding(type);
        }
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setServerName(String name) {
        this.serverName = name;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void setStream(InputStream input) {
        this.input = input;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }
}

