/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.catalina.Response;
import org.apache.catalina.connector.ResponseBase;
import org.apache.catalina.util.StringManager;

public class ResponseStream
extends ServletOutputStream {
    protected boolean closed = false;
    protected boolean commit = false;
    protected int count = 0;
    protected int length = -1;
    protected Response response = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected OutputStream stream = null;

    public ResponseStream(Response response) {
        this.response = response;
        this.stream = response.getStream();
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("responseStream.close.closed"));
        }
        this.response.getResponse().flushBuffer();
        this.closed = true;
    }

    boolean closed() {
        return this.closed;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("responseStream.flush.closed"));
        }
        if (this.commit) {
            this.response.getResponse().flushBuffer();
        }
    }

    boolean getCommit() {
        return this.commit;
    }

    void reset() {
        this.count = 0;
    }

    void setCommit(boolean commit) {
        this.commit = commit;
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("responseStream.write.closed"));
        }
        if (this.length > 0 && this.count >= this.length) {
            throw new IOException(sm.getString("responseStream.write.count"));
        }
        ((ResponseBase)this.response).write(b);
        ++this.count;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("responseStream.write.closed"));
        }
        int actual = len;
        if (this.length > 0 && this.count + len >= this.length) {
            actual = this.length - this.count;
        }
        ((ResponseBase)this.response).write(b, off, actual);
        this.count += actual;
        if (actual < len) {
            throw new IOException(sm.getString("responseStream.write.count"));
        }
    }
}

