/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.util.Stack;
import java.util.Vector;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.http.HttpProcessor;
import org.apache.catalina.connector.http.HttpRequestImpl;
import org.apache.catalina.connector.http.HttpResponseImpl;
import org.apache.catalina.net.DefaultServerSocketFactory;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class HttpConnector
implements Connector,
Lifecycle,
Runnable {
    private int acceptCount = 10;
    private String address = null;
    private int bufferSize = 2048;
    protected Container container = null;
    private Vector created = new Vector();
    private int curProcessors = 0;
    private int debug = 0;
    private boolean enableLookups = false;
    private ServerSocketFactory factory = null;
    private static final String info = "org.apache.catalina.connector.http.HttpConnector/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected int minProcessors = 5;
    private int maxProcessors = 20;
    private int connectionTimeout = 60000;
    private int port = 8080;
    private Stack processors = new Stack();
    private String proxyName = null;
    private int proxyPort = 0;
    private int redirectPort = 443;
    private String scheme = "http";
    private boolean secure = false;
    private ServerSocket serverSocket = null;
    private StringManager sm = StringManager.getManager("org.apache.catalina.connector.http");
    private boolean started = false;
    private boolean stopped = false;
    private Thread thread = null;
    private String threadName = null;
    private Object threadSync = new Object();
    private boolean allowChunking = true;

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HttpProcessor createProcessor() {
        Stack stack = this.processors;
        synchronized (stack) {
            if (this.processors.size() > 0) {
                return (HttpProcessor)this.processors.pop();
            }
            if (this.maxProcessors <= 0) return null;
            if (this.curProcessors >= this.maxProcessors) return null;
            return this.newProcessor();
        }
    }

    public Request createRequest() {
        HttpRequestImpl request = new HttpRequestImpl();
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        HttpResponseImpl response = new HttpResponseImpl();
        response.setConnector(this);
        return response;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public String getAddress() {
        return this.address;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Container getContainer() {
        return this.container;
    }

    public int getCurProcessors() {
        return this.curProcessors;
    }

    public int getDebug() {
        return this.debug;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public ServerSocketFactory getFactory() {
        if (this.factory == null) {
            HttpConnector httpConnector = this;
            synchronized (httpConnector) {
                this.factory = new DefaultServerSocketFactory();
            }
        }
        return this.factory;
    }

    public String getInfo() {
        return info;
    }

    public int getMaxProcessors() {
        return this.maxProcessors;
    }

    public int getMinProcessors() {
        return this.minProcessors;
    }

    public int getPort() {
        return this.port;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public boolean isAvailable() {
        return this.started;
    }

    public boolean isChunkingAllowed() {
        return this.allowChunking;
    }

    private void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.threadName) + " " + message);
        } else {
            System.out.println(String.valueOf(this.threadName) + " " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.threadName) + " " + message, throwable);
        } else {
            System.out.println(String.valueOf(this.threadName) + " " + message);
            throwable.printStackTrace(System.out);
        }
    }

    private HttpProcessor newProcessor() {
        HttpProcessor processor;
        if ((processor = new HttpProcessor(this, this.curProcessors++)) instanceof Lifecycle) {
            try {
                processor.start();
            }
            catch (LifecycleException e) {
                this.log("newProcessor", e);
                return null;
            }
        }
        this.created.addElement(processor);
        return processor;
    }

    private ServerSocket open() throws IOException {
        ServerSocketFactory factory = this.getFactory();
        if (this.address == null) {
            this.log(this.sm.getString("httpConnector.allAddresses"));
            return factory.createSocket(this.port, this.acceptCount);
        }
        try {
            InetAddress is = InetAddress.getByName(this.address);
            this.log(this.sm.getString("httpConnector.anAddress", this.address));
            return factory.createSocket(this.port, this.acceptCount, is);
        }
        catch (Exception exception) {
            this.log(this.sm.getString("httpConnector.noAddress", this.address));
            return factory.createSocket(this.port, this.acceptCount);
        }
    }

    void recycle(HttpProcessor processor) {
        this.processors.push(processor);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void run() {
        Object socket;
        while (!this.stopped) {
            HttpProcessor processor;
            block13: {
                socket = null;
                try {
                    socket = this.serverSocket.accept();
                    if (this.connectionTimeout <= 0) break block13;
                    ((Socket)socket).setSoTimeout(this.connectionTimeout);
                }
                catch (AccessControlException ace) {
                    this.log("socket accept security exception", ace);
                    continue;
                }
                catch (IOException e) {
                    if (this.started && !this.stopped) {
                        this.log("accept: ", e);
                    }
                    try {
                        this.serverSocket.close();
                        if (this.stopped) continue;
                        this.serverSocket = this.open();
                        continue;
                    }
                    catch (IOException ex) {
                        this.log("socket reopen: ", ex);
                        break;
                    }
                }
            }
            if ((processor = this.createProcessor()) == null) {
                try {
                    this.log(this.sm.getString("httpConnector.noProcessor"));
                    ((Socket)socket).close();
                }
                catch (IOException iOException) {}
                continue;
            }
            processor.assign((Socket)socket);
        }
        socket = this.threadSync;
        synchronized (socket) {
            this.threadSync.notifyAll();
        }
    }

    public void setAcceptCount(int count) {
        this.acceptCount = count;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setAllowChunking(boolean allowChunking) {
        this.allowChunking = allowChunking;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    public void setFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public void setMaxProcessors(int maxProcessors) {
        this.maxProcessors = maxProcessors;
    }

    public void setMinProcessors(int minProcessors) {
        this.minProcessors = minProcessors;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("httpConnector.alreadyStarted"));
        }
        this.threadName = "HttpConnector[" + this.port + "]";
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        try {
            this.serverSocket = this.open();
        }
        catch (IOException e) {
            throw new LifecycleException(String.valueOf(this.threadName) + ".open", e);
        }
        this.threadStart();
        while (this.curProcessors < this.minProcessors) {
            if (this.maxProcessors > 0 && this.curProcessors >= this.maxProcessors) break;
            HttpProcessor processor = this.newProcessor();
            this.recycle(processor);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("httpConnector.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        int i = this.created.size() - 1;
        while (i >= 0) {
            HttpProcessor processor = (HttpProcessor)this.created.elementAt(i);
            if (processor instanceof Lifecycle) {
                try {
                    processor.stop();
                }
                catch (LifecycleException e) {
                    this.log("HttpConnector.stop", e);
                }
            }
            --i;
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {}
        }
        this.threadStop();
        this.serverSocket = null;
    }

    private void threadStart() {
        this.log(this.sm.getString("httpConnector.starting"));
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        this.log(this.sm.getString("httpConnector.stopping"));
        this.stopped = true;
        Object object = this.threadSync;
        synchronized (object) {
            try {
                this.threadSync.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.thread = null;
    }
}

