/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import org.apache.catalina.connector.HttpResponseBase;
import org.apache.catalina.connector.http.HttpResponseStream;

final class HttpResponseImpl
extends HttpResponseBase {
    protected static final String info = "org.apache.catalina.connector.http.HttpResponseImpl/1.0";
    protected boolean allowChunking;
    protected HttpResponseStream responseStream;

    HttpResponseImpl() {
    }

    public ServletOutputStream createOutputStream() throws IOException {
        this.responseStream = new HttpResponseStream(this);
        return this.responseStream;
    }

    public void finishResponse() throws IOException {
        if (this.getStatus() < 400) {
            if (!this.isStreamInitialized() && this.getContentLength() == -1 && this.getStatus() >= 200 && this.getStatus() != 304 && this.getStatus() != 204) {
                this.setContentLength(0);
            }
        } else {
            this.setHeader("Connection", "close");
        }
        super.finishResponse();
    }

    public String getInfo() {
        return info;
    }

    public boolean isChunkingAllowed() {
        return this.allowChunking;
    }

    public boolean isCloseConnection() {
        String connectionValue = this.getHeader("Connection");
        return connectionValue != null && connectionValue.equals("close");
    }

    public boolean isStreamInitialized() {
        return this.responseStream != null;
    }

    public void recycle() {
        super.recycle();
        this.responseStream = null;
        this.allowChunking = false;
    }

    public void removeHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList values = (ArrayList)this.headers.get(name);
            if (values != null && !values.isEmpty()) {
                ((AbstractCollection)values).remove(value);
                if (values.isEmpty()) {
                    this.headers.remove(name);
                }
            }
        }
    }

    public void reset() {
        String connectionValue = this.getHeader("Connection");
        String transferEncodingValue = this.getHeader("Transfer-Encoding");
        super.reset();
        if (connectionValue != null) {
            this.addHeader("Connection", connectionValue);
        }
        if (transferEncodingValue != null) {
            this.addHeader("Transfer-Encoding", transferEncodingValue);
        }
    }

    public void sendError(int status, String message) throws IOException {
        this.setAllowChunking(false);
        this.addHeader("Connection", "close");
        super.sendError(status, message);
    }

    void setAllowChunking(boolean allowChunking) {
        this.allowChunking = allowChunking;
    }

    public void setContentLength(int length) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        super.setContentLength(length);
        if (this.responseStream != null) {
            this.responseStream.checkChunking(this);
        }
    }

    public void setStatus(int status) {
        super.setStatus(status);
        if (this.responseStream != null) {
            this.responseStream.checkChunking(this);
        }
    }
}

