/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Logger;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationHttpRequest;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.ApplicationResponse;
import org.apache.catalina.util.StringManager;

final class ApplicationDispatcher
implements RequestDispatcher {
    private Context context = null;
    private int debug = 0;
    private static final String info = "org.apache.catalina.core.ApplicationDispatcher/1.0";
    private String name = null;
    private String pathInfo = null;
    private String queryString = null;
    private String servletPath = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private Wrapper wrapper = null;

    public ApplicationDispatcher(Wrapper wrapper, String servletPath, String pathInfo, String queryString, String name) {
        String jspFile;
        this.wrapper = wrapper;
        this.context = (Context)wrapper.getParent();
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.name = name;
        if (this.debug >= 1) {
            this.log("servletPath=" + this.servletPath + ", pathInfo=" + this.pathInfo + ", queryString=" + queryString + ", name=" + this.name);
        }
        if ((jspFile = wrapper.getJspFile()) != null) {
            if (this.debug >= 1) {
                this.log("-->servletPath=" + jspFile);
            }
            this.servletPath = jspFile;
        }
    }

    private void doForward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (response.isCommitted()) {
            throw new IllegalStateException(sm.getString("applicationDispatcher.forward.ise"));
        }
        response.resetBuffer();
        HttpServletRequest hrequest = null;
        if (request instanceof HttpServletRequest) {
            hrequest = (HttpServletRequest)request;
        }
        HttpServletResponse hresponse = null;
        if (response instanceof HttpServletResponse) {
            hresponse = (HttpServletResponse)response;
        }
        if (hrequest == null || hresponse == null) {
            if (this.debug >= 1) {
                this.log(" Non-HTTP Forward");
            }
            this.invoke(request, response);
        } else if (this.servletPath == null && this.pathInfo == null) {
            if (this.debug >= 1) {
                this.log(" Named Dispatcher Forward");
            }
            this.invoke(request, response);
        } else {
            if (this.debug >= 1) {
                this.log(" Path Based Forward");
            }
            ApplicationHttpRequest wrequest = new ApplicationHttpRequest((HttpServletRequest)request);
            StringBuffer sb = new StringBuffer();
            String contextPath = this.context.getPath();
            if (contextPath != null) {
                sb.append(contextPath);
            }
            if (this.servletPath != null) {
                sb.append(this.servletPath);
            }
            if (this.pathInfo != null) {
                sb.append(this.pathInfo);
            }
            wrequest.setContextPath(contextPath);
            wrequest.setRequestURI(sb.toString());
            wrequest.setServletPath(this.servletPath);
            wrequest.setPathInfo(this.pathInfo);
            if (this.queryString != null) {
                wrequest.setQueryString(this.queryString);
                wrequest.mergeParameters(this.queryString);
            }
            this.invoke((ServletRequest)wrequest, response);
        }
        response.flushBuffer();
        try {
            PrintWriter writer = response.getWriter();
            writer.flush();
            writer.close();
        }
        catch (IllegalStateException illegalStateException) {
            try {
                ServletOutputStream stream = response.getOutputStream();
                stream.flush();
                stream.close();
            }
            catch (IllegalStateException illegalStateException2) {
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {}
    }

    private void doInclude(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Object wresponse = null;
        wresponse = response instanceof HttpServletResponse ? new ApplicationHttpResponse((HttpServletResponse)response, true) : new ApplicationResponse(response, true);
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            if (this.debug >= 1) {
                this.log(" Non-HTTP Include");
            }
            this.invoke(request, (ServletResponse)wresponse);
        } else if (this.name != null) {
            if (this.debug >= 1) {
                this.log(" Named Dispatcher Include");
            }
            ApplicationHttpRequest wrequest = new ApplicationHttpRequest((HttpServletRequest)request);
            wrequest.setAttribute("org.apache.catalina.NAMED", this.name);
            if (this.servletPath != null) {
                wrequest.setServletPath(this.servletPath);
            }
            this.invoke((ServletRequest)wrequest, (ServletResponse)wresponse);
        } else {
            if (this.debug >= 1) {
                this.log(" Path Based Include");
            }
            ApplicationHttpRequest wrequest = new ApplicationHttpRequest((HttpServletRequest)request);
            StringBuffer sb = new StringBuffer();
            String contextPath = this.context.getPath();
            if (contextPath != null) {
                sb.append(contextPath);
            }
            if (this.servletPath != null) {
                sb.append(this.servletPath);
            }
            if (this.pathInfo != null) {
                sb.append(this.pathInfo);
            }
            if (sb.length() > 0) {
                wrequest.setAttribute("javax.servlet.include.request_uri", sb.toString());
            }
            if (contextPath != null) {
                wrequest.setAttribute("javax.servlet.include.context_path", contextPath);
            }
            if (this.servletPath != null) {
                wrequest.setAttribute("javax.servlet.include.servlet_path", this.servletPath);
            }
            if (this.pathInfo != null) {
                wrequest.setAttribute("javax.servlet.include.path_info", this.pathInfo);
            }
            if (this.queryString != null) {
                wrequest.setAttribute("javax.servlet.include.query_string", this.queryString);
                wrequest.mergeParameters(this.queryString);
            }
            this.invoke((ServletRequest)wrequest, (ServletResponse)wresponse);
        }
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedForward dp = new PrivilegedForward(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e.getClass().getName().equals("javax.servlet.ServletException")) {
                    throw (ServletException)((Object)e);
                }
                throw (IOException)e;
            }
        } else {
            this.doForward(request, response);
        }
    }

    public String getInfo() {
        return info;
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                PrivilegedInclude dp = new PrivilegedInclude(request, response);
                AccessController.doPrivileged(dp);
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                pe.printStackTrace();
                if (e.getClass().getName().equals("javax.servlet.ServletException")) {
                    throw (ServletException)((Object)e);
                }
                throw (IOException)e;
            }
        } else {
            this.doInclude(request, response);
        }
    }

    private void invoke(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest hrequest = null;
        if (request instanceof HttpServletRequest) {
            hrequest = (HttpServletRequest)request;
        }
        HttpServletResponse hresponse = null;
        if (response instanceof HttpServletResponse) {
            hresponse = (HttpServletResponse)response;
        }
        Servlet servlet = null;
        IOException ioException = null;
        Throwable servletException = null;
        RuntimeException runtimeException = null;
        boolean unavailable = false;
        if (this.wrapper.isUnavailable()) {
            this.log(sm.getString("applicationDispatcher.isUnavailable", this.wrapper.getName()));
            if (hresponse != null) {
                long available = this.wrapper.getAvailable();
                if (available > 0L && available < Long.MAX_VALUE) {
                    hresponse.setDateHeader("Retry-After", available);
                }
                hresponse.sendError(503, sm.getString("applicationDispatcher.isUnavailable", this.wrapper.getName()));
            }
            unavailable = true;
        }
        try {
            if (!unavailable) {
                servlet = this.wrapper.allocate();
            }
        }
        catch (ServletException e) {
            this.log(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), e);
            servletException = e;
            servlet = null;
        }
        catch (Throwable e) {
            this.log(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), e);
            servletException = new ServletException(sm.getString("applicationDispatcher.allocateException", this.wrapper.getName()), e);
            servlet = null;
        }
        try {
            if (servlet != null) {
                if (servlet instanceof HttpServlet && hrequest != null && hresponse != null) {
                    ((HttpServlet)servlet).service((ServletRequest)hrequest, (ServletResponse)hresponse);
                } else {
                    servlet.service(request, response);
                }
            }
        }
        catch (IOException e) {
            this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            ioException = e;
        }
        catch (UnavailableException e) {
            this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            servletException = e;
            this.wrapper.unavailable(e);
        }
        catch (ServletException e) {
            this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            servletException = e;
        }
        catch (RuntimeException e) {
            this.log(sm.getString("applicationDispatcher.serviceException", this.wrapper.getName()), e);
            runtimeException = e;
        }
        try {
            if (servlet != null) {
                this.wrapper.deallocate(servlet);
            }
        }
        catch (ServletException e) {
            this.log(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
            servletException = e;
        }
        catch (Throwable e) {
            this.log(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
            servletException = new ServletException(sm.getString("applicationDispatcher.deallocateException", this.wrapper.getName()), e);
        }
        if (ioException != null) {
            throw ioException;
        }
        if (servletException != null) {
            throw servletException;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    private void log(String message) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("ApplicationDispatcher[" + this.context.getPath() + "]: " + message);
        } else {
            System.out.println("ApplicationDispatcher[" + this.context.getPath() + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("ApplicationDispatcher[" + this.context.getPath() + "] " + message, throwable);
        } else {
            System.out.println("ApplicationDispatcher[" + this.context.getPath() + "]: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    protected class PrivilegedForward
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedForward(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object run() throws ServletException, IOException {
            ApplicationDispatcher.this.doForward(this.request, this.response);
            return null;
        }
    }

    protected class PrivilegedInclude
    implements PrivilegedExceptionAction {
        private ServletRequest request;
        private ServletResponse response;

        PrivilegedInclude(ServletRequest request, ServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object run() throws ServletException, IOException {
            ApplicationDispatcher.this.doInclude(this.request, this.response);
            return null;
        }
    }
}

