/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.util.InstanceSupport;
import org.apache.catalina.util.StringManager;

final class ApplicationFilterChain
implements FilterChain {
    private ArrayList filters = new ArrayList();
    private Iterator iterator = null;
    private Servlet servlet = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private InstanceSupport support = null;

    void addFilter(ApplicationFilterConfig filterConfig) {
        this.filters.add(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (System.getSecurityManager() != null) {
            final ServletRequest req = request;
            final ServletResponse res = response;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ServletException, IOException {
                        this.internalDoFilter(req, res);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pe) {
                Exception e = pe.getException();
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.internalDoFilter(request, response);
        }
    }

    private void internalDoFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.iterator == null) {
            this.iterator = ((AbstractList)this.filters).iterator();
        }
        if (this.iterator.hasNext()) {
            ApplicationFilterConfig filterConfig = (ApplicationFilterConfig)this.iterator.next();
            Filter filter = null;
            try {
                filter = filterConfig.getFilter();
                this.support.fireInstanceEvent("beforeFilter", filter);
                filter.doFilter(request, response, (FilterChain)this);
                this.support.fireInstanceEvent("afterFilter", filter);
            }
            catch (IOException e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter);
                }
                throw e;
            }
            catch (ServletException e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter);
                }
                throw e;
            }
            catch (Throwable e) {
                if (filter != null) {
                    this.support.fireInstanceEvent("afterFilter", filter);
                }
                throw new ServletException(sm.getString("filterChain.filter"), e);
            }
            return;
        }
        try {
            this.support.fireInstanceEvent("beforeService", this.servlet);
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                if (this.servlet instanceof SingleThreadModel) {
                    Servlet filterConfig = this.servlet;
                    synchronized (filterConfig) {
                        this.servlet.service((ServletRequest)((HttpServletRequest)request), (ServletResponse)((HttpServletResponse)response));
                    }
                } else {
                    this.servlet.service((ServletRequest)((HttpServletRequest)request), (ServletResponse)((HttpServletResponse)response));
                }
            } else if (this.servlet instanceof SingleThreadModel) {
                Servlet filterConfig = this.servlet;
                synchronized (filterConfig) {
                    this.servlet.service(request, response);
                }
            } else {
                this.servlet.service(request, response);
            }
            this.support.fireInstanceEvent("afterService", this.servlet);
        }
        catch (IOException e) {
            this.support.fireInstanceEvent("afterService", this.servlet);
            throw e;
        }
        catch (ServletException e) {
            this.support.fireInstanceEvent("afterService", this.servlet);
            throw e;
        }
        catch (RuntimeException e) {
            this.support.fireInstanceEvent("afterService", this.servlet);
            throw e;
        }
        catch (Throwable e) {
            this.support.fireInstanceEvent("afterService", this.servlet);
            throw new ServletException(sm.getString("filterChain.servlet"), e);
        }
    }

    void release() {
        this.filters.clear();
        this.iterator = this.iterator;
        this.servlet = null;
    }

    void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    void setSupport(InstanceSupport support) {
        this.support = support;
    }
}

