/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Mapper;
import org.apache.catalina.Request;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.StringManager;

public class StandardHostMapper
implements Mapper {
    private StandardHost host = null;
    private String protocol = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    public Container getContainer() {
        return this.host;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Container map(Request request, boolean update) {
        if (update && request.getContext() != null) {
            return request.getContext();
        }
        String uri = ((HttpServletRequest)request.getRequest()).getRequestURI();
        Context context = this.host.map(uri);
        if (update) {
            request.setContext(context);
            if (context != null) {
                ((HttpRequest)request).setContextPath(context.getPath());
            } else {
                ((HttpRequest)request).setContextPath(null);
            }
        }
        return context;
    }

    public void setContainer(Container container) {
        if (!(container instanceof StandardHost)) {
            throw new IllegalArgumentException(sm.getString("httpHostMapper.container"));
        }
        this.host = (StandardHost)container;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

