/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class StandardService
implements Lifecycle,
Service {
    private Connector[] connectors = new Connector[0];
    private Container container = null;
    private static final String info = "org.apache.catalina.core.StandardService/1.0";
    private String name = this.toString();
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean started = false;

    public void addConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (connectorArray) {
            connector.setContainer(this.container);
            Connector[] results = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, results, 0, this.connectors.length);
            results[this.connectors.length] = connector;
            this.connectors = results;
            if (this.started && connector instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)connector)).start();
                }
                catch (LifecycleException lifecycleException) {}
            }
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public Connector[] findConnectors() {
        return this.connectors;
    }

    public Container getContainer() {
        return this.container;
    }

    public String getInfo() {
        return info;
    }

    public String getName() {
        return this.name;
    }

    public void removeConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (connectorArray) {
            int j = -1;
            int i = 0;
            while (i < this.connectors.length) {
                if (connector == this.connectors[i]) {
                    j = i;
                    break;
                }
                ++i;
            }
            if (j < 0) {
                Object var3_5 = null;
                return;
            }
            if (this.started && this.connectors[j] instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.connectors[j])).stop();
                }
                catch (LifecycleException lifecycleException) {}
            }
            this.connectors[j].setContainer(null);
            int k = 0;
            Connector[] results = new Connector[this.connectors.length - 1];
            int i2 = 0;
            while (i2 < this.connectors.length) {
                if (i2 != j) {
                    results[k++] = this.connectors[i2];
                }
                ++i2;
            }
            this.connectors = results;
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void setContainer(Container container) {
        block9: {
            Container oldContainer = this.container;
            this.container = container;
            if (this.started && this.container != null && this.container instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.container)).start();
                }
                catch (LifecycleException lifecycleException) {}
            }
            Connector[] connectorArray = this.connectors;
            synchronized (connectorArray) {
                int i = 0;
                while (i < this.connectors.length) {
                    this.connectors[i].setContainer(this.container);
                    ++i;
                }
            }
            if (!this.started || oldContainer == null || !(oldContainer instanceof Lifecycle)) break block9;
            try {
                ((Lifecycle)((Object)oldContainer)).stop();
            }
            catch (LifecycleException lifecycleException) {}
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardService.start.started"));
        }
        System.out.println(sm.getString("standardService.start.name", this.name));
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Connector[] connectorArray = this.container;
        synchronized (connectorArray) {
            if (this.container != null && this.container instanceof Lifecycle) {
                ((Lifecycle)((Object)this.container)).start();
            }
        }
        connectorArray = this.connectors;
        synchronized (connectorArray) {
            int i = 0;
            while (i < this.connectors.length) {
                if (this.connectors[i] instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.connectors[i])).start();
                }
                ++i;
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardService.stop.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        System.out.println(sm.getString("standardService.stop.name", this.name));
        this.started = false;
        Object object = this.connectors;
        synchronized (object) {
            int i = 0;
            while (i < this.connectors.length) {
                if (this.connectors[i] instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.connectors[i])).stop();
                }
                ++i;
            }
        }
        object = this.container;
        synchronized (object) {
            if (this.container != null && this.container instanceof Lifecycle) {
                ((Lifecycle)((Object)this.container)).stop();
            }
        }
    }
}

