/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Timestamp;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.logger.LoggerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class FileLogger
extends LoggerBase
implements Lifecycle {
    private String date = "";
    private String directory = "logs";
    protected static final String info = "org.apache.catalina.logger.FileLogger/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private String prefix = "catalina.";
    private StringManager sm = StringManager.getManager("org.apache.catalina.logger");
    private boolean started = false;
    private String suffix = ".log";
    private boolean timestamp = false;
    private PrintWriter writer = null;

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    private void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.date = "";
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean getTimestamp() {
        return this.timestamp;
    }

    public void log(String msg) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        String tsString = ts.toString().substring(0, 19);
        String tsDate = tsString.substring(0, 10);
        if (!this.date.equals(tsDate)) {
            FileLogger fileLogger = this;
            synchronized (fileLogger) {
                this.close();
                this.date = tsDate;
                this.open();
            }
        }
        if (this.writer != null) {
            if (this.timestamp) {
                this.writer.print(tsString);
                this.writer.print(" ");
            }
            this.writer.println(msg);
        }
    }

    private void open() {
        File dir = new File(this.directory);
        if (!dir.isAbsolute()) {
            dir = new File(String.valueOf(System.getProperty("catalina.home")) + File.separator + this.directory);
        }
        dir.mkdirs();
        try {
            String pathname = String.valueOf(dir.getAbsolutePath()) + File.separator + this.prefix + this.date + this.suffix;
            this.writer = new PrintWriter((Writer)new FileWriter(pathname, true), true);
        }
        catch (IOException iOException) {
            this.writer = null;
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void setDirectory(String directory) {
        String oldDirectory = this.directory;
        this.directory = directory;
        this.support.firePropertyChange("directory", oldDirectory, this.directory);
    }

    public void setPrefix(String prefix) {
        String oldPrefix = this.prefix;
        this.prefix = prefix;
        this.support.firePropertyChange("prefix", oldPrefix, this.prefix);
    }

    public void setSuffix(String suffix) {
        String oldSuffix = this.suffix;
        this.suffix = suffix;
        this.support.firePropertyChange("suffix", oldSuffix, this.suffix);
    }

    public void setTimestamp(boolean timestamp) {
        boolean oldTimestamp = this.timestamp;
        this.timestamp = timestamp;
        this.support.firePropertyChange("timestamp", new Boolean(oldTimestamp), new Boolean(this.timestamp));
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("fileLogger.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("fileLogger.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.close();
    }
}

