/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;

public class JDBCRealm
extends RealmBase {
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String connectionURL = null;
    protected Connection dbConnection = null;
    protected Driver driver = null;
    protected String driverName = null;
    protected static final String info = "org.apache.catalina.realm.JDBCRealm/1.0";
    protected static final String name = "JDBCRealm";
    protected PreparedStatement preparedCredentials = null;
    protected PreparedStatement preparedRoles = null;
    protected String roleNameCol = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.realm");
    protected String userCredCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userTable = null;

    public Principal authenticate(String username, String credentials) {
        Connection dbConnection = null;
        try {
            dbConnection = this.open();
            Principal principal = this.authenticate(dbConnection, username, credentials);
            this.release(dbConnection);
            return principal;
        }
        catch (SQLException e) {
            this.log(sm.getString("jdbcRealm.exception"), e);
            if (dbConnection != null) {
                this.close(dbConnection);
            }
            return null;
        }
    }

    public synchronized Principal authenticate(Connection dbConnection, String username, String credentials) throws SQLException {
        String dbCredentials = null;
        PreparedStatement stmt = this.credentials(dbConnection, username);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            dbCredentials = rs.getString(1).trim();
        }
        rs.close();
        if (dbCredentials == null) {
            return null;
        }
        if (this.digest(credentials).equals(dbCredentials)) {
            if (this.debug >= 2) {
                this.log(sm.getString("jdbcRealm.authenticateSuccess", username));
            }
        } else {
            if (this.debug >= 2) {
                this.log(sm.getString("jdbcRealm.authenticateFailure", username));
            }
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        stmt = this.roles(dbConnection, username);
        rs = stmt.executeQuery();
        while (rs.next()) {
            list.add(rs.getString(1).trim());
        }
        rs.close();
        dbConnection.commit();
        return new GenericPrincipal(this, username, credentials, list);
    }

    protected void close(Connection dbConnection) {
        if (dbConnection == null) {
            return;
        }
        try {
            this.preparedCredentials.close();
        }
        catch (Throwable throwable) {}
        try {
            this.preparedRoles.close();
        }
        catch (Throwable throwable) {}
        try {
            dbConnection.close();
        }
        catch (SQLException e) {
            this.log(sm.getString("jdbcRealm.close"), e);
        }
        this.dbConnection = null;
        this.preparedCredentials = null;
        this.preparedRoles = null;
    }

    protected PreparedStatement credentials(Connection dbConnection, String username) throws SQLException {
        if (this.preparedCredentials == null) {
            StringBuffer sb = new StringBuffer("SELECT ");
            sb.append(this.userCredCol);
            sb.append(" FROM ");
            sb.append(this.userTable);
            sb.append(" WHERE ");
            sb.append(this.userNameCol);
            sb.append(" = ?");
            this.preparedCredentials = dbConnection.prepareStatement(sb.toString());
        }
        this.preparedCredentials.setString(1, username);
        return this.preparedCredentials;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return null;
    }

    protected Connection open() throws SQLException {
        if (this.dbConnection != null) {
            return this.dbConnection;
        }
        if (this.driver == null) {
            try {
                Class<?> clazz = Class.forName(this.driverName);
                this.driver = (Driver)clazz.newInstance();
            }
            catch (Throwable e) {
                throw new SQLException(e.getMessage());
            }
        }
        Properties props = new Properties();
        if (this.connectionName != null) {
            ((Hashtable)props).put("user", this.connectionName);
        }
        if (this.connectionPassword != null) {
            ((Hashtable)props).put("password", this.connectionPassword);
        }
        this.dbConnection = this.driver.connect(this.connectionURL, props);
        this.dbConnection.setAutoCommit(false);
        return this.dbConnection;
    }

    protected void release(Connection dbConnection) {
    }

    protected PreparedStatement roles(Connection dbConnection, String username) throws SQLException {
        if (this.preparedRoles == null) {
            StringBuffer sb = new StringBuffer("SELECT ");
            sb.append(this.roleNameCol);
            sb.append(" FROM ");
            sb.append(this.userRoleTable);
            sb.append(" WHERE ");
            sb.append(this.userNameCol);
            sb.append(" = ?");
            this.preparedRoles = dbConnection.prepareStatement(sb.toString());
        }
        this.preparedRoles.setString(1, username);
        return this.preparedRoles;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setRoleNameCol(String roleNameCol) {
        this.roleNameCol = roleNameCol;
    }

    public void setUserCredCol(String userCredCol) {
        this.userCredCol = userCredCol;
    }

    public void setUserNameCol(String userNameCol) {
        this.userNameCol = userNameCol;
    }

    public void setUserRoleTable(String userRoleTable) {
        this.userRoleTable = userRoleTable;
    }

    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }

    public void start() throws LifecycleException {
        try {
            this.open();
        }
        catch (SQLException e) {
            throw new LifecycleException(sm.getString("jdbcRealm.open"), e);
        }
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
        this.close(this.dbConnection);
    }
}

