/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;

public class JNDIRealm
extends RealmBase {
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String connectionURL = null;
    protected DirContext context = null;
    protected String contextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    protected static final String info = "org.apache.catalina.realm.JNDIRealm/1.0";
    protected static final String name = "JNDIRealm";
    protected String roleBase = "";
    protected MessageFormat roleFormat = null;
    protected String[] roleName = null;
    protected String roleSearch = null;
    protected boolean roleSubtree = false;
    protected MessageFormat userFormat = null;
    protected String[] userPassword = null;
    protected String userPattern = null;

    public Principal authenticate(String username, String credentials) {
        DirContext context = null;
        try {
            context = this.open();
            Principal principal = this.authenticate(context, username, credentials);
            this.release(context);
            return principal;
        }
        catch (NamingException e) {
            this.log(RealmBase.sm.getString("jndiRealm.exception"), e);
            if (context != null) {
                this.close(context);
            }
            return null;
        }
    }

    public synchronized Principal authenticate(DirContext context, String username, String credentials) throws NamingException {
        String dn = this.getUserDN(context, username, credentials);
        if (dn == null) {
            return null;
        }
        List roles = this.getRoles(context, username, dn);
        return new GenericPrincipal(this, username, credentials, roles);
    }

    protected void close(DirContext context) {
        if (context == null) {
            return;
        }
        try {
            if (this.debug >= 1) {
                this.log("Closing directory context");
            }
            context.close();
        }
        catch (NamingException e) {
            this.log(RealmBase.sm.getString("jndiRealm.close"), e);
        }
        this.context = null;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return null;
    }

    public String getRoleBase() {
        return this.roleBase;
    }

    public String getRoleName() {
        if (this.roleName != null) {
            return this.roleName[0];
        }
        return null;
    }

    public String getRoleSearch() {
        return this.roleSearch;
    }

    public boolean getRoleSubtree() {
        return this.roleSubtree;
    }

    /*
     * Unable to fully structure code
     */
    protected List getRoles(DirContext context, String username, String dn) throws NamingException {
        if (this.debug >= 2) {
            this.log("getRoles(" + dn + ")");
        }
        list = new ArrayList<String>();
        if (this.roleFormat == null || this.roleName == null) {
            return list;
        }
        filter = this.roleFormat.format(new String[]{dn, username});
        controls = new SearchControls();
        if (this.roleSubtree) {
            controls.setSearchScope(2);
        } else {
            controls.setSearchScope(1);
        }
        controls.setReturningAttributes(this.roleName);
        if (this.debug >= 3) {
            this.log("  Searching role base '" + this.roleBase + "' for attribute '" + this.roleName + "'");
            this.log("  With filter expression '" + filter + "'");
        }
        if ((results = context.search(this.roleBase, filter, controls)) != null) ** GOTO lbl26
        return list;
lbl-1000:
        // 1 sources

        {
            result = results.next();
            attrs = result.getAttributes();
            if (attrs == null || (attr = attrs.get(this.roleName[0])) == null) continue;
            role = (String)attr.get();
            if (this.debug >= 3) {
                this.log("  Found role '" + role + "'");
            }
            list.add(role);
lbl26:
            // 3 sources

            ** while (results.hasMore())
        }
lbl27:
        // 1 sources

        if (this.debug >= 2) {
            this.log("  Returning " + list.size() + " roles");
        }
        return list;
    }

    protected String getUserDN(DirContext context, String username, String credentials) throws NamingException {
        Object value;
        Attribute attr;
        if (this.debug >= 2) {
            this.log("getUserDN(" + username + ")");
        }
        if (username == null) {
            return null;
        }
        if (this.userFormat == null || this.userPassword == null) {
            return null;
        }
        String dn = this.userFormat.format(new String[]{username});
        if (this.debug >= 3) {
            this.log("  dn=" + dn);
        }
        Attributes attrs = null;
        try {
            attrs = context.getAttributes(dn, this.userPassword);
        }
        catch (NameNotFoundException nameNotFoundException) {
            return null;
        }
        if (attrs == null) {
            return null;
        }
        if (this.debug >= 3) {
            this.log("  retrieving attribute " + this.userPassword[0]);
        }
        if ((attr = attrs.get(this.userPassword[0])) == null) {
            return null;
        }
        if (this.debug >= 3) {
            this.log("  retrieving value");
        }
        if ((value = attr.get()) == null) {
            return null;
        }
        String valueString = null;
        valueString = value instanceof byte[] ? new String((byte[])value) : value.toString();
        if (this.debug >= 3) {
            this.log("  validating credentials");
        }
        if (this.digest(credentials).equals(valueString)) {
            if (this.debug >= 2) {
                this.log(RealmBase.sm.getString("jndiRealm.authenticateSuccess", username));
            }
        } else {
            if (this.debug >= 2) {
                this.log(RealmBase.sm.getString("jndiRealm.authenticateFailure", username));
            }
            return null;
        }
        return dn;
    }

    public String getUserPassword() {
        if (this.userPassword != null) {
            return this.userPassword[0];
        }
        return null;
    }

    public String getUserPattern() {
        return this.userPattern;
    }

    protected DirContext open() throws NamingException {
        if (this.context != null) {
            return this.context;
        }
        if (this.debug >= 1) {
            this.log("Connecting to URL " + this.connectionURL);
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.contextFactory);
        if (this.connectionName != null) {
            env.put("java.naming.security.principal", this.connectionName);
        }
        if (this.connectionPassword != null) {
            env.put("java.naming.security.credentials", this.connectionPassword);
        }
        if (this.connectionURL != null) {
            env.put("java.naming.provider.url", this.connectionURL);
        }
        this.context = new InitialDirContext(env);
        return this.context;
    }

    protected void release(DirContext context) {
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public void setContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public void setRoleBase(String roleBase) {
        this.roleBase = roleBase;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName != null ? new String[]{roleName} : null;
    }

    public void setRoleSearch(String roleSearch) {
        this.roleSearch = roleSearch;
        this.roleFormat = roleSearch == null ? null : new MessageFormat(roleSearch);
    }

    public void setRoleSubtree(boolean roleSubtree) {
        this.roleSubtree = roleSubtree;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword != null ? new String[]{userPassword} : null;
    }

    public void setUserPattern(String userPattern) {
        this.userPattern = userPattern;
        this.userFormat = userPattern == null ? null : new MessageFormat(userPattern);
    }

    public void start() throws LifecycleException {
        try {
            this.open();
        }
        catch (NamingException e) {
            throw new LifecycleException(RealmBase.sm.getString("jndiRealm.open"), e);
        }
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
        this.close(this.context);
    }
}

