/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.File;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.MemoryRealmUserAction;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.util.xml.XmlMapper;

public final class MemoryRealm
extends RealmBase {
    private Container container = null;
    protected final String info = "org.apache.catalina.realm.MemoryRealm/1.0";
    protected static final String name = "MemoryRealm";
    private String pathname = "conf/tomcat-users.xml";
    private HashMap principals = new HashMap();
    private static StringManager sm = StringManager.getManager("org.apache.catalina.realm");
    private boolean started = false;

    void addUser(String username, String password, String roles) {
        int comma;
        ArrayList<String> list = new ArrayList<String>();
        roles = String.valueOf(roles) + ",";
        while ((comma = roles.indexOf(",")) >= 0) {
            String role = roles.substring(0, comma).trim();
            list.add(role);
            roles = roles.substring(comma + 1);
        }
        GenericPrincipal principal = new GenericPrincipal(this, username, password, list);
        this.principals.put(username, principal);
    }

    public Principal authenticate(String username, String credentials) {
        GenericPrincipal principal = (GenericPrincipal)this.principals.get(username);
        if (principal != null && this.digest(credentials).equals(principal.getPassword())) {
            if (this.debug >= 2) {
                this.log(sm.getString("memoryRealm.authenticateSuccess", username));
            }
            return principal;
        }
        if (this.debug >= 2) {
            this.log(sm.getString("memoryRealm.authenticateFailure", username));
        }
        return null;
    }

    public String getInfo() {
        return "org.apache.catalina.realm.MemoryRealm/1.0";
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        GenericPrincipal principal = (GenericPrincipal)this.principals.get(username);
        if (principal != null) {
            return principal.getPassword();
        }
        return null;
    }

    public String getPathname() {
        return this.pathname;
    }

    protected Principal getPrincipal(String username) {
        return (Principal)this.principals.get(username);
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
    }

    public synchronized void start() throws LifecycleException {
        File file = new File(this.pathname);
        if (!file.isAbsolute()) {
            file = new File(String.valueOf(System.getProperty("catalina.home")) + File.separator + this.pathname);
        }
        if (!file.exists() || !file.canRead()) {
            throw new LifecycleException(sm.getString("memoryRealm.loadExist", file.getAbsolutePath()));
        }
        if (this.debug >= 1) {
            this.log(sm.getString("memoryRealm.loadPath", file.getAbsolutePath()));
        }
        XmlMapper mapper = new XmlMapper();
        mapper.addRule("tomcat-users/user", new MemoryRealmUserAction());
        try {
            mapper.readXml(file, (Object)this);
        }
        catch (Exception e) {
            throw new LifecycleException("memoryRealm.readXml", e);
        }
        super.start();
    }

    public synchronized void stop() throws LifecycleException {
        super.stop();
    }
}

