/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.MD5Encoder;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class DefaultServlet
extends HttpServlet {
    protected int debug = 0;
    protected int input = 2048;
    protected boolean listings = true;
    protected boolean readOnly = true;
    protected int output = 2048;
    protected String[] welcomes = new String[0];
    protected static MessageDigest md5Helper;
    protected static final MD5Encoder md5Encoder;
    protected static final SimpleDateFormat[] formats;
    protected static final TimeZone gmtZone;
    protected static final String mimeSeparation = "CATALINA_MIME_BOUNDARY";
    protected static final String RESOURCES_JNDI_NAME = "java:/comp/Resources";
    protected static StringManager sm;
    protected static BitSet safeCharacters;
    protected static final char[] hexadecimal;

    static {
        md5Encoder = new MD5Encoder();
        formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
        gmtZone = TimeZone.getTimeZone("GMT");
        formats[0].setTimeZone(gmtZone);
        formats[1].setTimeZone(gmtZone);
        formats[2].setTimeZone(gmtZone);
        sm = StringManager.getManager("org.apache.catalina.servlets");
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        safeCharacters = new BitSet(256);
        int i = 97;
        while (i <= 122) {
            safeCharacters.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            safeCharacters.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            safeCharacters.set(i);
            ++i;
        }
        safeCharacters.set(45);
        safeCharacters.set(95);
        safeCharacters.set(46);
        safeCharacters.set(42);
        safeCharacters.set(47);
    }

    protected String appendParameters(HttpServletRequest request, String redirectPath) {
        StringBuffer result = new StringBuffer(this.rewriteUrl(redirectPath));
        Enumeration enumeration = request.getParameterNames();
        if (enumeration.hasMoreElements()) {
            result.append("?");
        }
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String[] values = request.getParameterValues(name);
            int i = 0;
            while (i < values.length) {
                result.append(this.rewriteUrl(name));
                result.append("=");
                result.append(this.rewriteUrl(values[i]));
                if (i < values.length - 1) {
                    result.append("&");
                }
                ++i;
            }
            if (!enumeration.hasMoreElements()) continue;
            result.append("&");
        }
        return result.toString();
    }

    protected boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, ResourceInfo resourceInfo) throws IOException {
        String currentToken;
        StringTokenizer commaTokenizer;
        String eTag = this.getETag(resourceInfo, true);
        long fileLength = resourceInfo.length;
        long lastModified = resourceInfo.date;
        String headerValue = request.getHeader("If-Match");
        if (headerValue != null && headerValue.indexOf("*") == -1) {
            commaTokenizer = new StringTokenizer(headerValue, ",");
            boolean conditionSatisfied = false;
            while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                currentToken = commaTokenizer.nextToken();
                if (!currentToken.trim().equals(eTag)) continue;
                conditionSatisfied = true;
            }
            if (!conditionSatisfied) {
                response.sendError(412);
                return false;
            }
        }
        if ((headerValue = request.getHeader("If-Modified-Since")) != null && request.getHeader("If-None-Match") == null) {
            Date date = null;
            int i = 0;
            while (date == null && i < formats.length) {
                try {
                    date = formats[i].parse(headerValue);
                }
                catch (ParseException parseException) {}
                ++i;
            }
            if (date != null && lastModified <= date.getTime() + 1000L) {
                response.setStatus(304);
                return false;
            }
        }
        if ((headerValue = request.getHeader("If-None-Match")) != null) {
            boolean conditionSatisfied = false;
            if (!headerValue.equals("*")) {
                commaTokenizer = new StringTokenizer(headerValue, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    currentToken = commaTokenizer.nextToken();
                    if (!currentToken.trim().equals(eTag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            if (conditionSatisfied) {
                if ("GET".equals(request.getMethod()) || "HEAD".equals(request.getMethod())) {
                    response.setStatus(304);
                    return false;
                }
                response.sendError(412);
                return false;
            }
        }
        if ((headerValue = request.getHeader("If-Unmodified-Since")) != null) {
            Date date = null;
            int i = 0;
            while (date == null && i < formats.length) {
                try {
                    date = formats[i].parse(headerValue);
                }
                catch (ParseException parseException) {}
                ++i;
            }
            if (date != null && lastModified > date.getTime()) {
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    private ResourceInfo checkWelcomeFiles(String pathname, DirContext resources) {
        String collectionName = pathname;
        if (!pathname.endsWith("/")) {
            collectionName = String.valueOf(collectionName) + "/";
        }
        String[] stringArray = this.welcomes;
        synchronized (stringArray) {
            this.welcomes = (String[])this.getServletContext().getAttribute("org.apache.catalina.WELCOME_FILES");
            if (this.welcomes == null) {
                this.welcomes = new String[0];
            }
        }
        int i = 0;
        while (i < this.welcomes.length) {
            String resourceName = String.valueOf(collectionName) + this.welcomes[i];
            ResourceInfo resourceInfo = new ResourceInfo(resourceName, resources);
            if (resourceInfo.exists()) {
                return resourceInfo;
            }
            ++i;
        }
        return null;
    }

    private void copy(ResourceInfo resourceInfo, PrintWriter writer) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = resourceInfo.getStream();
        InputStreamReader reader = new InputStreamReader(resourceInputStream);
        exception = this.copyRange(reader, writer);
        try {
            ((Reader)reader).close();
        }
        catch (Throwable throwable) {}
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(ResourceInfo resourceInfo, PrintWriter writer, Enumeration ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasMoreElements()) {
            InputStream resourceInputStream = resourceInfo.getStream();
            InputStreamReader reader = new InputStreamReader(resourceInputStream);
            Range currentRange = (Range)ranges.nextElement();
            writer.println("--CATALINA_MIME_BOUNDARY");
            if (contentType != null) {
                writer.println("Content-Type: " + contentType);
            }
            writer.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
            writer.println();
            exception = this.copyRange(reader, writer, currentRange.start, currentRange.end);
            try {
                ((Reader)reader).close();
            }
            catch (Throwable throwable) {}
        }
        writer.print("--CATALINA_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(ResourceInfo resourceInfo, PrintWriter writer, Range range) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = resourceInfo.getStream();
        InputStreamReader reader = new InputStreamReader(resourceInputStream);
        exception = this.copyRange(reader, writer, range.start, range.end);
        try {
            ((Reader)reader).close();
        }
        catch (Throwable throwable) {}
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(ResourceInfo resourceInfo, ServletOutputStream ostream) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = resourceInfo.getStream();
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
        exception = this.copyRange(istream, ostream);
        try {
            ((InputStream)istream).close();
        }
        catch (Throwable throwable) {}
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(ResourceInfo resourceInfo, ServletOutputStream ostream, Enumeration ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasMoreElements()) {
            InputStream resourceInputStream = resourceInfo.getStream();
            BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
            Range currentRange = (Range)ranges.nextElement();
            ostream.println("--CATALINA_MIME_BOUNDARY");
            if (contentType != null) {
                ostream.println("Content-Type: " + contentType);
            }
            ostream.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
            ostream.println();
            exception = this.copyRange(istream, ostream, currentRange.start, currentRange.end);
            try {
                ((InputStream)istream).close();
            }
            catch (Throwable throwable) {}
        }
        ostream.print("--CATALINA_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(ResourceInfo resourceInfo, ServletOutputStream ostream, Range range) throws IOException {
        IOException exception = null;
        InputStream resourceInputStream = resourceInfo.getStream();
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
        exception = this.copyRange(istream, ostream, range.start, range.end);
        try {
            ((InputStream)istream).close();
        }
        catch (Throwable throwable) {}
        if (exception != null) {
            throw exception;
        }
    }

    private IOException copyRange(InputStream istream, ServletOutputStream ostream) {
        IOException exception = null;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        try {
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    private IOException copyRange(InputStream istream, ServletOutputStream ostream, long start, long end) {
        if (this.debug > 10) {
            System.out.println("Serving bytes:" + start + "-" + end);
        }
        try {
            istream.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = istream.read(buffer);
                if (bytesToRead >= (long)len) {
                    ostream.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    ostream.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len < buffer.length) break;
        }
        return exception;
    }

    private IOException copyRange(Reader reader, PrintWriter writer) {
        IOException exception = null;
        char[] buffer = new char[this.input];
        int len = buffer.length;
        try {
            while ((len = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    private IOException copyRange(Reader reader, PrintWriter writer, long start, long end) {
        try {
            reader.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        char[] buffer = new char[this.input];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = reader.read(buffer);
                if (bytesToRead >= (long)len) {
                    writer.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    writer.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len < buffer.length) break;
        }
        return exception;
    }

    public void destroy() {
    }

    protected void displaySize(StringBuffer buf, int filesize) {
        int leftside = filesize / 1024;
        int rightside = filesize % 1024 / 103;
        if (leftside == 0 && rightside == 0 && filesize != 0) {
            rightside = 1;
        }
        buf.append(leftside).append(".").append(rightside);
        buf.append(" KB");
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return;
        }
        DirContext resources = this.getResources();
        if (resources == null) {
            resp.sendError(500);
            return;
        }
        boolean exists = true;
        try {
            resources.lookup(path);
        }
        catch (NamingException namingException) {
            exists = false;
        }
        if (exists) {
            boolean result = true;
            try {
                resources.unbind(path);
            }
            catch (NamingException namingException) {
                result = false;
            }
            if (result) {
                resp.setStatus(204);
            } else {
                resp.sendError(405);
            }
        } else {
            resp.sendError(404);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.debug > 999) {
            this.showRequestInfo(request);
        }
        this.serveResource(request, response, true);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveResource(request, response, false);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        DirContext resources;
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return;
        }
        if (req.getHeader("Content-Range") != null) {
            resp.sendError(501);
        }
        if ((resources = this.getResources()) == null) {
            resp.sendError(500);
            return;
        }
        boolean exists = true;
        try {
            resources.lookup(path);
        }
        catch (NamingException namingException) {
            exists = false;
        }
        boolean result = true;
        try {
            Resource newResource = new Resource((InputStream)req.getInputStream());
            resources.bind(path, (Object)newResource);
        }
        catch (NamingException namingException) {
            result = false;
        }
        if (result) {
            if (exists) {
                resp.setStatus(204);
            } else {
                resp.setStatus(201);
            }
        } else {
            resp.sendError(409);
        }
    }

    protected String getETag(ResourceInfo resourceInfo, boolean strong) {
        if (strong) {
            return "\"" + this.getETagValue(resourceInfo, strong) + "\"";
        }
        return "W/\"" + this.getETagValue(resourceInfo, strong) + "\"";
    }

    protected String getETagValue(ResourceInfo resourceInfo, boolean strong) {
        return String.valueOf(resourceInfo.length) + "-" + resourceInfo.date;
    }

    protected String getRelativePath(HttpServletRequest request) {
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("javax.servlet.include.path_info");
            if (result == null) {
                result = (String)request.getAttribute("javax.servlet.include.servlet_path");
            }
            if (result == null || result.equals("")) {
                result = "/";
            }
            return result;
        }
        String result = request.getPathInfo();
        if (result == null) {
            result = request.getServletPath();
        }
        if (result == null || result.equals("")) {
            result = "/";
        }
        return this.normalize(result);
    }

    protected DirContext getResources() {
        DirContext result = null;
        try {
            result = (DirContext)this.getServletContext().getAttribute("org.apache.catalina.resources");
        }
        catch (ClassCastException classCastException) {}
        if (result != null) {
            return result;
        }
        try {
            result = (DirContext)new InitialContext().lookup(RESOURCES_JNDI_NAME);
        }
        catch (NamingException namingException) {
        }
        catch (ClassCastException classCastException) {}
        return result;
    }

    public void init() throws ServletException {
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable throwable) {}
        try {
            value = this.getServletConfig().getInitParameter("input");
            this.input = Integer.parseInt(value);
        }
        catch (Throwable throwable) {}
        try {
            value = this.getServletConfig().getInitParameter("listings");
            this.listings = new Boolean(value);
        }
        catch (Throwable throwable) {}
        try {
            value = this.getServletConfig().getInitParameter("readonly");
            if (value != null) {
                this.readOnly = new Boolean(value);
            }
        }
        catch (Throwable throwable) {}
        try {
            value = this.getServletConfig().getInitParameter("output");
            this.output = Integer.parseInt(value);
        }
        catch (Throwable throwable) {}
        if (this.input < 256) {
            this.input = 256;
        }
        if (this.output < 256) {
            this.output = 256;
        }
        this.welcomes = (String[])this.getServletContext().getAttribute("org.apache.catalina.WELCOME_FILES");
        if (this.welcomes == null) {
            this.welcomes = new String[0];
        }
        if (this.debug > 0) {
            this.log("DefaultServlet.init:  input buffer size=" + this.input + ", output buffer size=" + this.output);
            int i = 0;
            while (i < this.welcomes.length) {
                this.log("DefaultServlet.init:  welcome file=" + this.welcomes[i]);
                ++i;
            }
        }
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized == null) {
            return null;
        }
        if (normalized.equals("/.")) {
            return "/";
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = String.valueOf(normalized.substring(0, index2)) + normalized.substring(index + 3);
        }
        return normalized;
    }

    protected Vector parseRange(HttpServletRequest request, HttpServletResponse response, ResourceInfo resourceInfo) throws IOException {
        long fileLength;
        String headerValue = request.getHeader("If-Range");
        if (headerValue != null) {
            String eTag = this.getETag(resourceInfo, true);
            long lastModified = resourceInfo.date;
            Date date = null;
            int i = 0;
            while (date == null && i < formats.length) {
                try {
                    date = formats[i].parse(headerValue);
                }
                catch (ParseException parseException) {}
                ++i;
            }
            if (date == null ? !eTag.equals(headerValue.trim()) : lastModified > date.getTime() + 1000L) {
                return null;
            }
        }
        if ((fileLength = resourceInfo.length) == 0L) {
            return null;
        }
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.sendError(416);
            return null;
        }
        rangeHeader = rangeHeader.substring(6);
        Vector<Range> result = new Vector<Range>();
        StringTokenizer commaTokenizer = new StringTokenizer(rangeHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String rangeDefinition = commaTokenizer.nextToken();
            Range currentRange = new Range();
            currentRange.length = fileLength;
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                response.sendError(416);
                return null;
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.start = fileLength + offset;
                    currentRange.end = fileLength - 1L;
                }
                catch (NumberFormatException numberFormatException) {
                    response.sendError(416);
                    return null;
                }
            }
            try {
                currentRange.start = Long.parseLong(rangeDefinition.substring(0, dashPos));
                currentRange.end = dashPos < rangeDefinition.length() - 1 ? Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())) : fileLength - 1L;
            }
            catch (NumberFormatException numberFormatException) {
                response.sendError(416);
                return null;
            }
            if (!currentRange.validate()) {
                response.sendError(416);
                return null;
            }
            result.addElement(currentRange);
        }
        return result;
    }

    protected InputStream render(String contextPath, ResourceInfo resourceInfo) {
        int slash;
        String name = resourceInfo.path;
        int trim = name.length();
        if (!name.endsWith("/")) {
            ++trim;
        }
        if (name.equals("/")) {
            trim = 1;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter osWriter = null;
        try {
            osWriter = new OutputStreamWriter((OutputStream)stream, "UTF8");
        }
        catch (Exception exception) {
            osWriter = new OutputStreamWriter(stream);
        }
        PrintWriter writer = new PrintWriter(osWriter);
        writer.print("<html>\r\n");
        writer.print("<head>\r\n");
        writer.print("<title>");
        writer.print(sm.getString("directory.title", name));
        writer.print("</title>\r\n</head>\r\n");
        writer.print("<body bgcolor=\"white\">\r\n");
        writer.print("<table width=\"90%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        writer.print("<tr><td colspan=\"3\"><font size=\"+2\">\r\n<strong>");
        writer.print(sm.getString("directory.title", name));
        writer.print("</strong>\r\n</font></td></tr>\r\n");
        String parentDirectory = name;
        if (parentDirectory.endsWith("/")) {
            parentDirectory = parentDirectory.substring(0, parentDirectory.length() - 1);
        }
        if ((slash = parentDirectory.lastIndexOf("/")) >= 0) {
            String parent = name.substring(0, slash);
            writer.print("<tr><td colspan=\"3\" bgcolor=\"#ffffff\">\r\n");
            writer.print("<a href=\"");
            writer.print(this.rewriteUrl(contextPath));
            if (parent.equals("")) {
                parent = "/";
            }
            writer.print(this.rewriteUrl(parent));
            if (!parent.endsWith("/")) {
                writer.print("/");
            }
            writer.print("\">");
            writer.print(sm.getString("directory.parent", parent));
            writer.print("</a>\r\n");
            writer.print("</td></tr>\r\n");
        }
        writer.print("<tr bgcolor=\"#cccccc\">\r\n");
        writer.print("<td align=\"left\"><font size=\"+1\"><strong>");
        writer.print(sm.getString("directory.filename"));
        writer.print("</strong></font></td>\r\n");
        writer.print("<td align=\"center\"><font size=\"+1\"><strong>");
        writer.print(sm.getString("directory.size"));
        writer.print("</strong></font></td>\r\n");
        writer.print("<td align=\"right\"><font size=\"+1\"><strong>");
        writer.print(sm.getString("directory.lastModified"));
        writer.print("</strong></font></td>\r\n");
        writer.print("</tr>\r\n");
        try {
            DirContext directory = resourceInfo.directory;
            NamingEnumeration<NameClassPair> namingEnumeration = resourceInfo.resources.list(resourceInfo.path);
            boolean shade = false;
            while (namingEnumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)namingEnumeration.nextElement();
                String resourceName = ncPair.getName();
                ResourceInfo childResourceInfo = new ResourceInfo(resourceName, directory);
                String trimmed = resourceName;
                if (trimmed.equalsIgnoreCase("WEB-INF") || trimmed.equalsIgnoreCase("META-INF")) continue;
                writer.print("<tr");
                if (shade) {
                    writer.print(" bgcolor=\"eeeeee\"");
                }
                writer.print(">\r\n");
                shade ^= true;
                writer.print("<td align=\"left\">&nbsp;&nbsp;\r\n");
                writer.print("<a href=\"");
                writer.print(this.rewriteUrl(contextPath));
                resourceName = this.rewriteUrl(String.valueOf(name) + resourceName);
                writer.print(resourceName);
                if (childResourceInfo.collection) {
                    writer.print("/");
                }
                writer.print("\"><tt>");
                writer.print(trimmed);
                if (childResourceInfo.collection) {
                    writer.print("/");
                }
                writer.print("</tt></a></td>\r\n");
                writer.print("<td align=\"right\"><tt>");
                if (childResourceInfo.collection) {
                    writer.print("&nbsp;");
                } else {
                    writer.print(this.renderSize(childResourceInfo.length));
                }
                writer.print("</tt></td>\r\n");
                writer.print("<td align=\"right\"><tt>");
                writer.print(this.renderLastModified(childResourceInfo.date));
                writer.print("</tt></td>\r\n");
                writer.print("</tr>\r\n");
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        writer.print("<tr><td colspan=\"3\">&nbsp;</td></tr>\r\n");
        writer.print("<tr><td colspan=\"3\" bgcolor=\"#cccccc\">");
        writer.print("<font size=\"-1\">");
        writer.print("Apache Tomcat/4.0-b5");
        writer.print("</font></td></tr>\r\n");
        writer.print("</table>\r\n");
        writer.print("</body>\r\n");
        writer.print("</html>\r\n");
        writer.flush();
        return new ByteArrayInputStream(stream.toByteArray());
    }

    protected String renderLastModified(long lastModified) {
        return formats[0].format(new Date(lastModified));
    }

    protected String renderSize(long size) {
        long leftSide = size / 1024L;
        long rightSide = size % 1024L / 103L;
        if (leftSide == 0L && rightSide == 0L && size > 0L) {
            rightSide = 1L;
        }
        return leftSide + "." + rightSide + " kb";
    }

    protected String rewriteUrl(String path) {
        int maxBytesPerChar = 10;
        int caseDiff = 32;
        StringBuffer rewrittenPath = new StringBuffer(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, "UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
            writer = new OutputStreamWriter(buf);
        }
        int i = 0;
        while (i < path.length()) {
            block8: {
                char c = path.charAt(i);
                if (safeCharacters.get(c)) {
                    rewrittenPath.append(c);
                } else {
                    try {
                        writer.write(c);
                        writer.flush();
                    }
                    catch (IOException iOException) {
                        buf.reset();
                        break block8;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        byte toEncode = ba[j];
                        rewrittenPath.append('%');
                        int low = toEncode & 0xF;
                        int high = (toEncode & 0xF0) >> 4;
                        rewrittenPath.append(hexadecimal[high]);
                        rewrittenPath.append(hexadecimal[low]);
                        ++j;
                    }
                    buf.reset();
                }
            }
            ++i;
        }
        return rewrittenPath.toString();
    }

    protected void serveResource(HttpServletRequest request, HttpServletResponse response, boolean content) throws IOException, ServletException {
        String path = this.getRelativePath(request);
        if (this.debug > 0) {
            if (content) {
                this.log("DefaultServlet.serveResource:  Serving resource '" + path + "' headers and data");
            } else {
                this.log("DefaultServlet.serveResource:  Serving resource '" + path + "' headers only");
            }
        }
        if (path == null || path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            response.sendError(404, path);
            return;
        }
        DirContext resources = this.getResources();
        ResourceInfo resourceInfo = new ResourceInfo(path, resources);
        if (!resourceInfo.exists) {
            response.sendError(404, path);
            return;
        }
        if (!resourceInfo.collection && (path.endsWith("/") || path.endsWith("\\"))) {
            response.sendError(404, path);
            return;
        }
        if (resourceInfo.collection) {
            if (!request.getRequestURI().endsWith("/")) {
                String redirectPath = String.valueOf(request.getRequestURI()) + "/";
                redirectPath = this.appendParameters(request, redirectPath);
                response.sendRedirect(redirectPath);
                return;
            }
            ResourceInfo welcomeFileInfo = this.checkWelcomeFiles(path, resources);
            if (welcomeFileInfo != null) {
                String redirectPath = welcomeFileInfo.path;
                String contextPath = request.getContextPath();
                if (contextPath != null && !contextPath.equals("/")) {
                    redirectPath = String.valueOf(contextPath) + redirectPath;
                }
                redirectPath = this.appendParameters(request, redirectPath);
                response.sendRedirect(redirectPath);
                return;
            }
        }
        if (!this.checkIfHeaders(request, response, resourceInfo)) {
            return;
        }
        String contentType = this.getServletContext().getMimeType(resourceInfo.path);
        if (resourceInfo.collection) {
            if (!this.listings) {
                response.sendError(404, resourceInfo.path);
                return;
            }
            contentType = "text/html;charset=UTF-8";
        }
        Vector ranges = null;
        if (!resourceInfo.collection) {
            ranges = this.parseRange(request, response, resourceInfo);
            response.setHeader("ETag", this.getETag(resourceInfo, true));
        }
        if (this.debug > 0) {
            this.log("DefaultServlet.serveFile:  lastModified='" + new Timestamp(resourceInfo.date).toString() + "'");
        }
        response.setDateHeader("Last-Modified", resourceInfo.date);
        ServletOutputStream ostream = null;
        PrintWriter writer = null;
        if (content) {
            try {
                ostream = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                if (contentType != null && contentType.startsWith("text")) {
                    writer = response.getWriter();
                }
                throw e;
            }
        }
        if (resourceInfo.collection || (ranges == null || ranges.isEmpty()) && request.getHeader("Range") == null) {
            if (contentType != null) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentType='" + contentType + "'");
                }
                response.setContentType(contentType);
            }
            long contentLength = resourceInfo.length;
            if (!resourceInfo.collection && contentLength >= 0L) {
                if (this.debug > 0) {
                    this.log("DefaultServlet.serveFile:  contentLength=" + contentLength);
                }
                response.setContentLength((int)contentLength);
            }
            if (resourceInfo.collection && content) {
                resourceInfo.setStream(this.render(request.getContextPath(), resourceInfo));
            }
            if (content) {
                try {
                    response.setBufferSize(this.output);
                }
                catch (IllegalStateException illegalStateException) {}
                if (ostream != null) {
                    this.copy(resourceInfo, ostream);
                } else {
                    this.copy(resourceInfo, writer);
                }
            }
        } else {
            if (ranges == null || ranges.isEmpty()) {
                return;
            }
            response.setStatus(206);
            if (ranges.size() == 1) {
                Range range = (Range)ranges.elementAt(0);
                response.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
                response.setContentLength((int)range.length);
                if (contentType != null) {
                    if (this.debug > 0) {
                        this.log("DefaultServlet.serveFile:  contentType='" + contentType + "'");
                    }
                    response.setContentType(contentType);
                }
                if (content) {
                    try {
                        response.setBufferSize(this.output);
                    }
                    catch (IllegalStateException illegalStateException) {}
                    if (ostream != null) {
                        this.copy(resourceInfo, ostream, range);
                    } else {
                        this.copy(resourceInfo, writer, range);
                    }
                }
            } else {
                response.setContentType("multipart/byteranges; boundary=CATALINA_MIME_BOUNDARY");
                if (content) {
                    try {
                        response.setBufferSize(this.output);
                    }
                    catch (IllegalStateException illegalStateException) {}
                    if (ostream != null) {
                        this.copy(resourceInfo, ostream, ranges.elements(), contentType);
                    } else {
                        this.copy(resourceInfo, writer, ranges.elements(), contentType);
                    }
                }
            }
        }
    }

    protected void showRequestInfo(HttpServletRequest req) {
        System.out.println();
        System.out.println("SlideDAV Request Info");
        System.out.println();
        System.out.println("Encoding : " + req.getCharacterEncoding());
        System.out.println("Length : " + req.getContentLength());
        System.out.println("Type : " + req.getContentType());
        System.out.println();
        System.out.println("Parameters");
        Enumeration parameters = req.getParameterNames();
        while (parameters.hasMoreElements()) {
            String paramName = (String)parameters.nextElement();
            String[] values = req.getParameterValues(paramName);
            System.out.print(String.valueOf(paramName) + " : ");
            int i = 0;
            while (i < values.length) {
                System.out.print(String.valueOf(values[i]) + ", ");
                ++i;
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("Protocol : " + req.getProtocol());
        System.out.println("Address : " + req.getRemoteAddr());
        System.out.println("Host : " + req.getRemoteHost());
        System.out.println("Scheme : " + req.getScheme());
        System.out.println("Server Name : " + req.getServerName());
        System.out.println("Server Port : " + req.getServerPort());
        System.out.println();
        System.out.println("Attributes");
        Enumeration attributes = req.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String attributeName = (String)attributes.nextElement();
            System.out.print(String.valueOf(attributeName) + " : ");
            System.out.println(req.getAttribute(attributeName).toString());
        }
        System.out.println();
        System.out.println();
        System.out.println("HTTP Header Info");
        System.out.println();
        System.out.println("Authentication Type : " + req.getAuthType());
        System.out.println("HTTP Method : " + req.getMethod());
        System.out.println("Path Info : " + req.getPathInfo());
        System.out.println("Path translated : " + req.getPathTranslated());
        System.out.println("Query string : " + req.getQueryString());
        System.out.println("Remote user : " + req.getRemoteUser());
        System.out.println("Requested session id : " + req.getRequestedSessionId());
        System.out.println("Request URI : " + req.getRequestURI());
        System.out.println("Context path : " + req.getContextPath());
        System.out.println("Servlet path : " + req.getServletPath());
        System.out.println("User principal : " + req.getUserPrincipal());
        System.out.println();
        System.out.println("Headers : ");
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            System.out.print(String.valueOf(headerName) + " : ");
            System.out.println(req.getHeader(headerName));
        }
        System.out.println();
        System.out.println();
    }

    private class Range {
        public long start;
        public long end;
        public long length;

        Range() {
        }

        public void recycle() {
            this.start = 0L;
            this.end = 0L;
            this.length = 0L;
        }

        public boolean validate() {
            return this.start >= 0L && this.end >= 0L && this.length > 0L && this.start <= this.end && this.end < this.length;
        }
    }

    protected class ResourceInfo {
        public Object object;
        public DirContext directory;
        public Resource file;
        public Attributes attributes;
        public String path;
        public long creationDate;
        public String httpDate;
        public long date;
        public long length;
        public boolean collection;
        public boolean exists;
        public DirContext resources;
        protected InputStream is;

        public ResourceInfo(String path, DirContext resources) {
            this.set(path, resources);
        }

        public boolean exists() {
            return this.exists;
        }

        public InputStream getStream() throws IOException {
            if (this.is != null) {
                return this.is;
            }
            if (this.file != null) {
                return this.file.streamContent();
            }
            return null;
        }

        public void recycle() {
            this.object = null;
            this.directory = null;
            this.file = null;
            this.attributes = null;
            this.path = null;
            this.creationDate = 0L;
            this.httpDate = null;
            this.date = 0L;
            this.length = -1L;
            this.collection = true;
            this.exists = false;
            this.resources = null;
            this.is = null;
        }

        public void set(String path, DirContext resources) {
            block12: {
                this.recycle();
                this.path = path;
                this.resources = resources;
                this.exists = true;
                try {
                    this.object = resources.lookup(path);
                    if (this.object instanceof Resource) {
                        this.file = (Resource)this.object;
                        this.collection = false;
                    } else if (this.object instanceof DirContext) {
                        this.directory = (DirContext)this.object;
                        this.collection = true;
                    } else {
                        this.exists = false;
                    }
                }
                catch (NamingException namingException) {
                    this.exists = false;
                }
                if (!this.exists) break block12;
                try {
                    this.attributes = resources.getAttributes(path);
                    if (this.attributes instanceof ResourceAttributes) {
                        ResourceAttributes tempAttrs = (ResourceAttributes)this.attributes;
                        Date tempDate = tempAttrs.getCreationDate();
                        if (tempDate != null) {
                            this.creationDate = tempDate.getTime();
                        }
                        if ((tempDate = tempAttrs.getLastModified()) != null) {
                            this.date = tempDate.getTime();
                            this.httpDate = formats[0].format(tempDate);
                        } else {
                            this.httpDate = formats[0].format(new Date());
                        }
                        this.length = tempAttrs.getContentLength();
                    }
                }
                catch (NamingException namingException) {
                    this.exists = false;
                }
            }
        }

        public void setStream(InputStream is) {
            this.is = is;
        }

        public String toString() {
            return this.path;
        }
    }
}

