/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.util.StringManager;

public final class InvokerServlet
extends HttpServlet
implements ContainerServlet {
    private Context context = null;
    private int debug = 0;
    private static StringManager sm = StringManager.getManager("org.apache.catalina.servlets");
    private Wrapper wrapper = null;

    public void destroy() {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveRequest(request, response);
    }

    public void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serveRequest(request, response);
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(sm.getString("invokerServlet.noWrapper"));
        }
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable throwable) {}
        if (this.debug >= 1) {
            this.log("init: Associated with Context '" + this.context.getPath() + "'");
        }
    }

    public void serveRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean included;
        if (request.getAttribute("org.apache.catalina.NAMED") != null) {
            throw new ServletException(sm.getString("invokerServlet.notNamed"));
        }
        String inRequestURI = null;
        String inContextPath = null;
        String inServletPath = null;
        String inPathInfo = null;
        String inQueryString = null;
        boolean bl = included = request.getAttribute("javax.servlet.include.request_uri") != null;
        if (included) {
            inRequestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
            inContextPath = (String)request.getAttribute("javax.servlet.include.context_path");
            inServletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            inPathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            inQueryString = (String)request.getAttribute("javax.servlet.include.query_string");
        } else {
            inRequestURI = request.getRequestURI();
            inContextPath = request.getContextPath();
            inServletPath = request.getServletPath();
            inPathInfo = request.getPathInfo();
            inQueryString = request.getQueryString();
        }
        if (this.debug >= 1) {
            this.log("serveRequest:  included='" + included + "', requestURI='" + inRequestURI + "', contextPath='" + inContextPath + "'");
            this.log("  servletPath='" + inServletPath + "', pathInfo='" + inPathInfo + "', queryString='" + inQueryString + "'");
        }
        if (inPathInfo == null) {
            if (this.debug >= 1) {
                this.log("serveRequest:  Invalid pathInfo '" + inPathInfo + "'");
            }
            if (included) {
                throw new ServletException(sm.getString("invokerServlet.invalidPath", inRequestURI));
            }
            response.sendError(404, inRequestURI);
            return;
        }
        String pathInfo = inPathInfo;
        String servletClass = pathInfo.substring(1);
        int slash = servletClass.indexOf("/");
        if (slash >= 0) {
            pathInfo = servletClass.substring(slash);
            servletClass = servletClass.substring(0, slash);
        } else {
            pathInfo = "";
        }
        if (this.debug >= 1) {
            this.log("serveRequest: Processing servlet '" + servletClass + "' with path info '" + pathInfo + "'");
        }
        String name = "org.apache.catalina.INVOKER." + servletClass;
        String pattern = String.valueOf(inServletPath) + "/" + servletClass + "/*";
        Wrapper wrapper = null;
        wrapper = (Wrapper)this.context.findChild(servletClass);
        if (wrapper != null) {
            if (this.debug >= 1) {
                this.log("serveRequest:  Using wrapper for servlet '" + wrapper.getName() + "' with mapping '" + pattern + "'");
            }
            this.context.addServletMapping(pattern, wrapper.getName());
        } else {
            if (this.debug >= 1) {
                this.log("serveRequest:  Creating wrapper for '" + servletClass + "' with mapping '" + pattern + "'");
            }
            try {
                wrapper = this.context.createWrapper();
                wrapper.setName(name);
                wrapper.setLoadOnStartup(1);
                wrapper.setServletClass(servletClass);
                this.context.addChild(wrapper);
                this.context.addServletMapping(pattern, name);
            }
            catch (Throwable t) {
                if (included) {
                    throw new ServletException(sm.getString("invokerServlet.cannotCreate", inRequestURI), t);
                }
                this.log("serveRequest.create", t);
                response.sendError(404, inRequestURI);
                return;
            }
            try {
                Servlet instance = wrapper.allocate();
                wrapper.deallocate(instance);
            }
            catch (ServletException e) {
                this.log("serveRequest.load", e);
                this.context.removeServletMapping(pattern);
                this.context.removeChild(wrapper);
                Throwable rootCause = e.getRootCause();
                if (rootCause == null) {
                    rootCause = e;
                }
                if (included) {
                    throw new ServletException(sm.getString("invokerServlet.cannotLoad", inRequestURI), rootCause);
                }
                if (rootCause != null && rootCause instanceof ClassNotFoundException) {
                    response.sendError(404, inRequestURI);
                } else {
                    response.sendError(500, inRequestURI);
                }
                return;
            }
            catch (Throwable t) {
                this.log("serveRequest.load", t);
                this.context.removeServletMapping(pattern);
                this.context.removeChild(wrapper);
                if (included) {
                    throw new ServletException(sm.getString("invokerServlet.cannotLoad", inRequestURI), t);
                }
                response.sendError(500, inRequestURI);
                return;
            }
        }
        StringBuffer sb = new StringBuffer(inServletPath);
        sb.append("/");
        sb.append(servletClass);
        sb.append(pathInfo);
        String dispatcherPath = sb.toString();
        if (this.debug >= 1) {
            this.log("serveRequest:  Forwarding to '" + dispatcherPath + "'");
        }
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(dispatcherPath);
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        this.context = wrapper == null ? null : (Context)wrapper.getParent();
    }
}

