/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.security.Security;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.catalina.startup.CopyParentClassLoaderAction;
import org.apache.catalina.startup.CreateLoaderAction;
import org.apache.catalina.startup.LifecycleListenerAction;
import org.apache.catalina.startup.SetParentClassLoaderAction;
import org.apache.catalina.util.xml.XmlMapper;

public class Catalina {
    protected String configFile = "conf/server.xml";
    protected boolean debug = false;
    protected ClassLoader parentClassLoader = ClassLoader.getSystemClassLoader();
    protected Server server = null;
    protected boolean starting = false;
    protected boolean stopping = false;
    protected boolean useNaming = true;

    protected boolean arguments(String[] args) {
        boolean isConfig = false;
        int i = 0;
        while (i < args.length) {
            if (isConfig) {
                this.configFile = args[i];
                isConfig = false;
            } else if (args[i].equals("-config")) {
                isConfig = true;
            } else if (args[i].equals("-debug")) {
                this.debug = true;
            } else if (args[i].equals("-nonaming")) {
                this.useNaming = false;
            } else {
                if (args[i].equals("-help")) {
                    this.usage();
                    return false;
                }
                if (args[i].equals("start")) {
                    this.starting = true;
                } else if (args[i].equals("stop")) {
                    this.stopping = true;
                } else {
                    this.usage();
                }
            }
            ++i;
        }
        return true;
    }

    protected File configFile() {
        File file = new File(this.configFile);
        if (!file.isAbsolute()) {
            file = new File(String.valueOf(System.getProperty("catalina.home")) + File.separator + this.configFile);
        }
        return file;
    }

    protected void createContextCommon(String prefix, XmlMapper mapper) {
        mapper.addRule(String.valueOf(prefix) + "/Ejb", mapper.objectCreate("org.apache.catalina.deploy.ContextEjb"));
        mapper.addRule(String.valueOf(prefix) + "/Ejb", mapper.setProperties());
        mapper.addRule(String.valueOf(prefix) + "/Ejb", mapper.addChild("addEjb", "org.apache.catalina.deploy.ContextEjb"));
        mapper.addRule(String.valueOf(prefix) + "/Environment", mapper.objectCreate("org.apache.catalina.deploy.ContextEnvironment"));
        mapper.addRule(String.valueOf(prefix) + "/Environment", mapper.setProperties());
        mapper.addRule(String.valueOf(prefix) + "/Environment", mapper.addChild("addEnvironment", "org.apache.catalina.deploy.ContextEnvironment"));
        mapper.addRule(String.valueOf(prefix) + "/InstanceListener", mapper.methodSetter("addInstanceListener", 0));
        mapper.addRule(String.valueOf(prefix) + "/Listener", mapper.objectCreate(null, "className"));
        mapper.addRule(String.valueOf(prefix) + "/Listener", mapper.setProperties());
        mapper.addRule(String.valueOf(prefix) + "/Listener", mapper.addChild("addLifecycleListener", "org.apache.catalina.LifecycleListener"));
        mapper.addRule(String.valueOf(prefix) + "/Loader", new CreateLoaderAction());
        mapper.addRule(String.valueOf(prefix) + "/Loader", mapper.setProperties());
        mapper.addRule(String.valueOf(prefix) + "/Loader", mapper.addChild("setLoader", "org.apache.catalina.Loader"));
        mapper.addRule(String.valueOf(prefix) + "/Logger", mapper.objectCreate(null, "className"));
        mapper.addRule(String.valueOf(prefix) + "/Logger", mapper.setProperties());
        mapper.addRule(String.valueOf(prefix) + "/Logger", mapper.addChild("setLogger", "org.apache.catalina.Logger"));
        mapper.addRule(String.valueOf(prefix) + "/Manager", mapper.objectCreate("org.apache.catalina.session.StandardManager", "className"));
        mapper.addRule(String.valueOf(prefix) + "/Manager", mapper.setProperties());
        mapper.addRule(String.valueOf(prefix) + "/Manager", mapper.addChild("setManager", "org.apache.catalina.Manager"));
        mapper.addRule(String.valueOf(prefix) + "/Parameter", mapper.objectCreate("org.apache.catalina.deploy.ApplicationParameter"));
        mapper.addRule(String.valueOf(prefix) + "/Parameter", mapper.setProperties());
        mapper.addRule(String.valueOf(prefix) + "/Parameter", mapper.addChild("addApplicationParameter", "org.apache.catalina.deploy.ApplicationParameter"));
        mapper.addRule(String.valueOf(prefix) + "/Realm", mapper.objectCreate(null, "className"));
        mapper.addRule(String.valueOf(prefix) + "/Realm", mapper.setProperties());
        mapper.addRule(String.valueOf(prefix) + "/Realm", mapper.addChild("setRealm", "org.apache.catalina.Realm"));
        mapper.addRule(String.valueOf(prefix) + "/Resource", mapper.objectCreate("org.apache.catalina.deploy.ContextResource"));
        mapper.addRule(String.valueOf(prefix) + "/Resource", mapper.setProperties());
        mapper.addRule(String.valueOf(prefix) + "/Resource", mapper.addChild("addResource", "org.apache.catalina.deploy.ContextResource"));
        mapper.addRule(String.valueOf(prefix) + "/ResourceParams", mapper.objectCreate("org.apache.catalina.deploy.ResourceParams"));
        mapper.addRule(String.valueOf(prefix) + "/ResourceParams", mapper.setProperties());
        mapper.addRule(String.valueOf(prefix) + "/ResourceParams", mapper.addChild("addResourceParams", "org.apache.catalina.deploy.ResourceParams"));
        mapper.addRule(String.valueOf(prefix) + "/ResourceParams/parameter", mapper.methodSetter("addParameter", 2));
        mapper.addRule(String.valueOf(prefix) + "/ResourceParams/parameter/name", mapper.methodParam(0));
        mapper.addRule(String.valueOf(prefix) + "/ResourceParams/parameter/value", mapper.methodParam(1));
        mapper.addRule(String.valueOf(prefix) + "/Resources", mapper.objectCreate("org.apache.naming.resources.FileDirContext", "className"));
        mapper.addRule(String.valueOf(prefix) + "/Resources", mapper.setProperties());
        mapper.addRule(String.valueOf(prefix) + "/Resources", mapper.addChild("setResources", "javax.naming.directory.DirContext"));
        mapper.addRule(String.valueOf(prefix) + "/Valve", mapper.objectCreate(null, "className"));
        mapper.addRule(String.valueOf(prefix) + "/Valve", mapper.setProperties());
        mapper.addRule(String.valueOf(prefix) + "/Valve", mapper.addChild("addValve", "org.apache.catalina.Valve"));
        mapper.addRule(String.valueOf(prefix) + "/WrapperLifecycle", mapper.methodSetter("addWrapperLifecycle", 0));
        mapper.addRule(String.valueOf(prefix) + "/WrapperListener", mapper.methodSetter("addWrapperListener", 0));
    }

    protected XmlMapper createStartMapper() {
        XmlMapper mapper = new XmlMapper();
        if (this.debug) {
            mapper.setDebug(999);
        }
        mapper.setValidating(false);
        mapper.addRule("Server", mapper.objectCreate("org.apache.catalina.core.StandardServer", "className"));
        mapper.addRule("Server", mapper.setProperties());
        mapper.addRule("Server", mapper.addChild("setServer", "org.apache.catalina.Server"));
        mapper.addRule("Server/Service", mapper.objectCreate("org.apache.catalina.core.StandardService", "className"));
        mapper.addRule("Server/Service", mapper.setProperties());
        mapper.addRule("Server/Service", mapper.addChild("addService", "org.apache.catalina.Service"));
        mapper.addRule("Server/Service/Connector", mapper.objectCreate("org.apache.catalina.connector.http.HttpConnector", "className"));
        mapper.addRule("Server/Service/Connector", mapper.setProperties());
        mapper.addRule("Server/Service/Connector", mapper.addChild("addConnector", "org.apache.catalina.Connector"));
        mapper.addRule("Server/Service/Connector/Factory", mapper.objectCreate("org.apache.catalina.net.DefaultServerSocketFactory", "className"));
        mapper.addRule("Server/Service/Connector/Factory", mapper.setProperties());
        mapper.addRule("Server/Service/Connector/Factory", mapper.addChild("setFactory", "org.apache.catalina.net.ServerSocketFactory"));
        mapper.addRule("Server/Service/Connector/Listener", mapper.objectCreate(null, "className"));
        mapper.addRule("Server/Service/Connector/Listener", mapper.setProperties());
        mapper.addRule("Server/Service/Connector/Listener", mapper.addChild("addLifecycleListener", "org.apache.catalina.LifecycleListener"));
        mapper.addRule("Server/Service/Engine", mapper.objectCreate("org.apache.catalina.core.StandardEngine", "className"));
        mapper.addRule("Server/Service/Engine", mapper.setProperties());
        mapper.addRule("Server/Service/Engine", new LifecycleListenerAction("org.apache.catalina.startup.EngineConfig", "configClass"));
        mapper.addRule("Server/Service/Engine", new SetParentClassLoaderAction(this.parentClassLoader));
        mapper.addRule("Server/Service/Engine", mapper.addChild("setContainer", "org.apache.catalina.Container"));
        this.createStartMapperContext("Server/Service/Engine/Context", mapper);
        this.createStartMapperDefaultContext("Server/Service/Engine/DefaultContext", mapper);
        mapper.addRule("Server/Service/Engine/Host", mapper.objectCreate("org.apache.catalina.core.StandardHost", "className"));
        mapper.addRule("Server/Service/Engine/Host", mapper.setProperties());
        mapper.addRule("Server/Service/Engine/Host", new CopyParentClassLoaderAction());
        mapper.addRule("Server/Service/Engine/Host", new LifecycleListenerAction("org.apache.catalina.startup.HostConfig", "configClass"));
        mapper.addRule("Server/Service/Engine/Host", mapper.addChild("addChild", "org.apache.catalina.Container"));
        mapper.addRule("Server/Service/Engine/Host/Cluster", mapper.objectCreate(null, "className"));
        mapper.addRule("Server/Service/Engine/Host/Cluster", mapper.setProperties());
        mapper.addRule("Server/Service/Engine/Host/Cluster", mapper.addChild("setCluster", "org.apache.catalina.Cluster"));
        this.createStartMapperContext("Server/Service/Engine/Host/Context", mapper);
        this.createStartMapperDefaultContext("Server/Service/Engine/Host/DefaultContext", mapper);
        mapper.addRule("Server/Service/Engine/Host/Context/Manager/Store", mapper.objectCreate(null, "className"));
        mapper.addRule("Server/Service/Engine/Host/Context/Manager/Store", mapper.setProperties());
        mapper.addRule("Server/Service/Engine/Host/Context/Manager/Store", mapper.addChild("setStore", "org.apache.catalina.Store"));
        mapper.addRule("Server/Service/Engine/Host/Listener", mapper.objectCreate(null, "className"));
        mapper.addRule("Server/Service/Engine/Host/Listener", mapper.setProperties());
        mapper.addRule("Server/Service/Engine/Host/Listener", mapper.addChild("addLifecycleListener", "org.apache.catalina.LifecycleListener"));
        mapper.addRule("Server/Service/Engine/Host/Logger", mapper.objectCreate(null, "className"));
        mapper.addRule("Server/Service/Engine/Host/Logger", mapper.setProperties());
        mapper.addRule("Server/Service/Engine/Host/Logger", mapper.addChild("setLogger", "org.apache.catalina.Logger"));
        mapper.addRule("Server/Service/Engine/Host/Realm", mapper.objectCreate(null, "className"));
        mapper.addRule("Server/Service/Engine/Host/Realm", mapper.setProperties());
        mapper.addRule("Server/Service/Engine/Host/Realm", mapper.addChild("setRealm", "org.apache.catalina.Realm"));
        mapper.addRule("Server/Service/Engine/Host/Resources", mapper.objectCreate("org.apache.naming.resources.FileDirContext", "className"));
        mapper.addRule("Server/Service/Engine/Host/Resources", mapper.setProperties());
        mapper.addRule("Server/Service/Engine/Host/Resources", mapper.addChild("setResources", "javax.naming.directory.DirContext"));
        mapper.addRule("Server/Service/Engine/Host/Valve", mapper.objectCreate(null, "className"));
        mapper.addRule("Server/Service/Engine/Host/Valve", mapper.setProperties());
        mapper.addRule("Server/Service/Engine/Host/Valve", mapper.addChild("addValve", "org.apache.catalina.Valve"));
        mapper.addRule("Server/Service/Engine/Listener", mapper.objectCreate(null, "className"));
        mapper.addRule("Server/Service/Engine/Listener", mapper.setProperties());
        mapper.addRule("Server/Service/Engine/Listener", mapper.addChild("addLifecycleListener", "org.apache.catalina.LifecycleListener"));
        mapper.addRule("Server/Service/Engine/Logger", mapper.objectCreate(null, "className"));
        mapper.addRule("Server/Service/Engine/Logger", mapper.setProperties());
        mapper.addRule("Server/Service/Engine/Logger", mapper.addChild("setLogger", "org.apache.catalina.Logger"));
        mapper.addRule("Server/Service/Engine/Realm", mapper.objectCreate(null, "className"));
        mapper.addRule("Server/Service/Engine/Realm", mapper.setProperties());
        mapper.addRule("Server/Service/Engine/Realm", mapper.addChild("setRealm", "org.apache.catalina.Realm"));
        mapper.addRule("Server/Service/Engine/Resources", mapper.objectCreate("org.apache.naming.resources.FileDirContext", "className"));
        mapper.addRule("Server/Service/Engine/Resources", mapper.setProperties());
        mapper.addRule("Server/Service/Engine/Resources", mapper.addChild("setResources", "javax.naming.directory.DirContext"));
        mapper.addRule("Server/Service/Engine/Valve", mapper.objectCreate(null, "className"));
        mapper.addRule("Server/Service/Engine/Valve", mapper.setProperties());
        mapper.addRule("Server/Service/Engine/Valve", mapper.addChild("addValve", "org.apache.catalina.Valve"));
        return mapper;
    }

    protected void createStartMapperContext(String prefix, XmlMapper mapper) {
        mapper.addRule(String.valueOf(prefix), mapper.objectCreate("org.apache.catalina.core.StandardContext", "className"));
        mapper.addRule(String.valueOf(prefix), mapper.setProperties());
        mapper.addRule(String.valueOf(prefix), new CopyParentClassLoaderAction());
        mapper.addRule(String.valueOf(prefix), new LifecycleListenerAction("org.apache.catalina.startup.ContextConfig", "configClass"));
        mapper.addRule(String.valueOf(prefix), mapper.addChild("addChild", "org.apache.catalina.Container"));
        this.createContextCommon(prefix, mapper);
    }

    protected void createStartMapperDefaultContext(String prefix, XmlMapper mapper) {
        mapper.addRule(String.valueOf(prefix), mapper.objectCreate("org.apache.catalina.core.DefaultContext", "className"));
        mapper.addRule(String.valueOf(prefix), mapper.setProperties());
        mapper.addRule(String.valueOf(prefix), mapper.addChild("addDefaultContext", "org.apache.catalina.core.DefaultContext"));
        this.createContextCommon(prefix, mapper);
    }

    protected XmlMapper createStopMapper() {
        XmlMapper mapper = new XmlMapper();
        mapper.addRule("Server", mapper.objectCreate("org.apache.catalina.core.StandardServer", "className"));
        mapper.addRule("Server", mapper.setProperties());
        mapper.addRule("Server", mapper.addChild("setServer", "org.apache.catalina.Server"));
        return mapper;
    }

    protected void execute() throws Exception {
        if (this.starting) {
            this.start();
        } else if (this.stopping) {
            this.stop();
        }
    }

    public static void main(String[] args) {
        new Catalina().process(args);
    }

    public void process(String[] args) {
        this.setCatalinaHome();
        try {
            if (this.arguments(args)) {
                this.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    protected void setCatalinaHome() {
        if (System.getProperty("catalina.home") != null) {
            return;
        }
        System.setProperty("catalina.home", System.getProperty("user.dir"));
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    protected void start() {
        block13: {
            block12: {
                XmlMapper mapper = this.createStartMapper();
                File file = this.configFile();
                try {
                    mapper.readXml(file, (Object)this);
                }
                catch (InvocationTargetException e) {
                    System.out.println("Catalina.start: InvocationTargetException");
                    e.getTargetException().printStackTrace(System.out);
                }
                catch (Exception e) {
                    System.out.println("Catalina.start: " + e);
                    e.printStackTrace(System.out);
                    System.exit(1);
                }
                if (!this.useNaming) {
                    System.setProperty("catalina.useNaming", "false");
                } else {
                    System.setProperty("catalina.useNaming", "true");
                    String value = "org.apache.naming";
                    String oldValue = System.getProperty("java.naming.factory.url.pkgs");
                    if (oldValue != null) {
                        value = String.valueOf(value) + ":" + oldValue;
                    }
                    System.setProperty("java.naming.factory.url.pkgs", value);
                }
                if (System.getSecurityManager() != null) {
                    String access = Security.getProperty("package.access");
                    access = access != null && access.length() > 0 ? String.valueOf(access) + "," : "sun.,";
                    Security.setProperty("package.access", String.valueOf(access) + "org.apache.catalina.,org.apache.jasper.");
                    String definition = Security.getProperty("package.definition");
                    definition = definition != null && definition.length() > 0 ? String.valueOf(definition) + "," : "sun.,";
                    Security.setProperty("package.definition", String.valueOf(definition) + "java.,org.apache.catalina.,org.apache.jasper.");
                }
                if (this.server instanceof Lifecycle) {
                    try {
                        ((Lifecycle)((Object)this.server)).start();
                    }
                    catch (LifecycleException e) {
                        System.out.println("Catalina.start: " + e);
                        e.printStackTrace(System.out);
                        if (e.getThrowable() == null) break block12;
                        System.out.println("----- Root Cause -----");
                        e.getThrowable().printStackTrace(System.out);
                    }
                }
            }
            this.server.await();
            if (!(this.server instanceof Lifecycle)) break block13;
            try {
                ((Lifecycle)((Object)this.server)).stop();
            }
            catch (LifecycleException e) {
                System.out.println("Catalina.stop: " + e);
                e.printStackTrace(System.out);
                if (e.getThrowable() == null) break block13;
                System.out.println("----- Root Cause -----");
                e.getThrowable().printStackTrace(System.out);
            }
        }
    }

    protected void stop() {
        XmlMapper mapper = this.createStopMapper();
        File file = this.configFile();
        try {
            mapper.readXml(file, (Object)this);
        }
        catch (Exception e) {
            System.out.println("Catalina.stop: " + e);
            e.printStackTrace(System.out);
            System.exit(1);
        }
        try {
            Socket socket = new Socket("127.0.0.1", this.server.getPort());
            OutputStream stream = socket.getOutputStream();
            String shutdown = this.server.getShutdown();
            int i = 0;
            while (i < shutdown.length()) {
                stream.write(shutdown.charAt(i));
                ++i;
            }
            stream.flush();
            stream.close();
            socket.close();
        }
        catch (IOException e) {
            System.out.println("Catalina.stop: " + e);
            e.printStackTrace(System.out);
            System.exit(1);
        }
    }

    protected void usage() {
        System.out.println("usage: java org.apache.catalina.startup.Catalina [ -config {pathname} ] [ -debug ] [ -nonaming ] { start | stop }");
    }
}

