/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.net.InetAddress;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.startup.Embedded;
import org.apache.catalina.startup.EmbeddedManagerMBean;

public final class EmbeddedManager
extends NotificationBroadcasterSupport
implements EmbeddedManagerMBean,
MBeanRegistration {
    private int state = 0;
    private long sequenceNumber = 0L;
    private Embedded embedded = new Embedded();

    public void addConnector(Connector connector) {
        this.embedded.addConnector(connector);
    }

    public void addEngine(Engine engine) {
        this.embedded.addEngine(engine);
    }

    public Connector createConnector(InetAddress address, int port, boolean secure) {
        return this.embedded.createConnector(address, port, secure);
    }

    public Context createContext(String path, String docBase) {
        return this.embedded.createContext(path, docBase);
    }

    public Engine createEngine() {
        return this.embedded.createEngine();
    }

    public Host createHost(String name, String appBase) {
        return this.embedded.createHost(name, appBase);
    }

    public void destroy() {
        if (this.getState() != 0) {
            this.stop();
        }
    }

    public int getDebug() {
        return this.embedded.getDebug();
    }

    public String getInfo() {
        return this.embedded.getInfo();
    }

    public Logger getLogger() {
        return this.embedded.getLogger();
    }

    public String getName() {
        return "Catalina servlet container";
    }

    public Realm getRealm() {
        return this.embedded.getRealm();
    }

    public String getSocketFactory() {
        return this.embedded.getSocketFactory();
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return EmbeddedManagerMBean.states[this.state];
    }

    public boolean isUseNaming() {
        return this.embedded.isUseNaming();
    }

    public void postDeregister() {
        this.destroy();
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.destroy();
        }
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return new ObjectName(":service=Catalina");
    }

    public void removeConnector(Connector connector) {
        this.embedded.removeConnector(connector);
    }

    public void removeContext(Context context) {
        this.embedded.removeContext(context);
    }

    public void removeEngine(Engine engine) {
        this.embedded.removeEngine(engine);
    }

    public void removeHost(Host host) {
        this.embedded.removeHost(host);
    }

    public void setDebug(int debug) {
        this.embedded.setDebug(debug);
    }

    public void setLogger(Logger logger) {
        this.embedded.setLogger(logger);
    }

    public void setRealm(Realm realm) {
        this.embedded.setRealm(realm);
    }

    public void setSocketFactory(String socketFactory) {
        this.embedded.setSocketFactory(socketFactory);
    }

    public void setUseNaming(boolean useNaming) {
        this.embedded.setUseNaming(useNaming);
    }

    public void start() {
        AttributeChangeNotification notification = null;
        if (this.state != 0) {
            return;
        }
        this.state = 2;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Starting Catalina servlet container", "State", "java.lang.Integer", new Integer(0), new Integer(2));
        this.sendNotification(notification);
        try {
            this.embedded.start();
        }
        catch (Throwable throwable) {
            this.state = 0;
            notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Catalina servlet container", "State", "java.lang.Integer", new Integer(2), new Integer(0));
            this.sendNotification(notification);
        }
        this.state = 3;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Started Catalina servlet container", "State", "java.lang.Integer", new Integer(2), new Integer(3));
        this.sendNotification(notification);
    }

    public void stop() {
        AttributeChangeNotification notification = null;
        if (this.state != 3) {
            return;
        }
        this.state = 1;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopping Catalina servlet container", "State", "java.lang.Integer", new Integer(3), new Integer(1));
        this.sendNotification(notification);
        try {
            this.embedded.stop();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.state = 0;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Catalina servlet container", "State", "java.lang.Integer", new Integer(1), new Integer(0));
        this.sendNotification(notification);
    }
}

