/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public abstract class RequestFilterValve
extends ValveBase {
    protected String allow = null;
    protected RE[] allows = new RE[0];
    protected RE[] denies = new RE[0];
    protected String deny = null;
    private static final String info = "org.apache.catalina.valves.RequestFilterValve/1.0";
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    public String getAllow() {
        return this.allow;
    }

    public String getDeny() {
        return this.deny;
    }

    public String getInfo() {
        return info;
    }

    public abstract void invoke(Request var1, Response var2, ValveContext var3) throws IOException, ServletException;

    protected RE[] precalculate(String list) {
        if (list == null) {
            return new RE[0];
        }
        if ((list = list.trim()).length() < 1) {
            return new RE[0];
        }
        list = String.valueOf(list) + ",";
        ArrayList<RE> reList = new ArrayList<RE>();
        while (list.length() > 0) {
            int comma = list.indexOf(",");
            if (comma < 0) break;
            String pattern = list.substring(0, comma).trim();
            try {
                reList.add(new RE(pattern));
            }
            catch (RESyntaxException rESyntaxException) {
                throw new IllegalArgumentException(sm.getString("requestFilterValve.syntax", pattern));
            }
            list = list.substring(comma + 1);
        }
        RE[] reArray = new RE[reList.size()];
        return reList.toArray(reArray);
    }

    protected void process(String property, Request request, Response response, ValveContext context) throws IOException, ServletException {
        int i = 0;
        while (i < this.denies.length) {
            ServletResponse sres;
            if (this.denies[i].match(property) && (sres = response.getResponse()) instanceof HttpServletResponse) {
                HttpServletResponse hres = (HttpServletResponse)sres;
                hres.sendError(403);
                return;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.allows.length) {
            if (this.allows[i2].match(property)) {
                context.invokeNext(request, response);
                return;
            }
            ++i2;
        }
        if (this.denies.length > 0 && this.allows.length == 0) {
            context.invokeNext(request, response);
            return;
        }
        ServletResponse sres = response.getResponse();
        if (sres instanceof HttpServletResponse) {
            HttpServletResponse hres = (HttpServletResponse)sres;
            hres.sendError(403);
            return;
        }
    }

    public void setAllow(String allow) {
        this.allow = allow;
        this.allows = this.precalculate(allow);
    }

    public void setDeny(String deny) {
        this.deny = deny;
        this.denies = this.precalculate(deny);
    }
}

