/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.naming.NameParserImpl;
import org.apache.naming.StringManager;

public abstract class BaseDirContext
implements DirContext {
    protected int debug = 0;
    protected String docBase = null;
    protected Hashtable env;
    protected StringManager sm = StringManager.getManager((String)"org.apache.naming.resources");
    protected final NameParser nameParser = new NameParserImpl();
    protected boolean cached = true;
    protected int cacheTTL = 5000;

    public BaseDirContext() {
        this.env = new Hashtable();
    }

    public BaseDirContext(Hashtable env) {
        this.env = env;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(name, obj, null);
    }

    public abstract void bind(String var1, Object var2, Attributes var3) throws NamingException;

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.bind(name.toString(), obj, attrs);
    }

    public void close() throws NamingException {
        this.env.clear();
    }

    public String composeName(String name, String prefix) throws NamingException {
        return String.valueOf(prefix) + "/" + name;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        prefix = (Name)name.clone();
        return prefix.addAll(name);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(name, null);
    }

    public abstract DirContext createSubcontext(String var1, Attributes var2) throws NamingException;

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return this.createSubcontext(name.toString(), attrs);
    }

    public abstract void destroySubcontext(String var1) throws NamingException;

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(name, null);
    }

    public abstract Attributes getAttributes(String var1, String[] var2) throws NamingException;

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getDebug() {
        return this.debug;
    }

    public String getDocBase() {
        return this.docBase;
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public abstract String getNameInNamespace() throws NamingException;

    public NameParser getNameParser(String name) throws NamingException {
        return new NameParserImpl();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return new NameParserImpl();
    }

    public abstract DirContext getSchema(String var1) throws NamingException;

    public DirContext getSchema(Name name) throws NamingException {
        return this.getSchema(name.toString());
    }

    public abstract DirContext getSchemaClassDefinition(String var1) throws NamingException;

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.getSchemaClassDefinition(name.toString());
    }

    public boolean isCached() {
        return this.cached;
    }

    public abstract NamingEnumeration list(String var1) throws NamingException;

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public abstract NamingEnumeration listBindings(String var1) throws NamingException;

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public abstract Object lookup(String var1) throws NamingException;

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public abstract Object lookupLink(String var1) throws NamingException;

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public abstract void modifyAttributes(String var1, int var2, Attributes var3) throws NamingException;

    public abstract void modifyAttributes(String var1, ModificationItem[] var2) throws NamingException;

    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(name.toString(), mod_op, attrs);
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(name.toString(), mods);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(name, obj, null);
    }

    public abstract void rebind(String var1, Object var2, Attributes var3) throws NamingException;

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.rebind(name.toString(), obj, attrs);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    public abstract void rename(String var1, String var2) throws NamingException;

    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    public abstract NamingEnumeration search(String var1, String var2, SearchControls var3) throws NamingException;

    public abstract NamingEnumeration search(String var1, String var2, Object[] var3, SearchControls var4) throws NamingException;

    public abstract NamingEnumeration search(String var1, Attributes var2) throws NamingException;

    public abstract NamingEnumeration search(String var1, Attributes var2, String[] var3) throws NamingException;

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        return this.search(name.toString(), filter, cons);
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(name.toString(), filterExpr, filterArgs, cons);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name.toString(), matchingAttributes);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search(name.toString(), matchingAttributes, attributesToReturn);
    }

    public void setCacheTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void setDocBase(String docBase) {
        if (docBase == null) {
            throw new IllegalArgumentException(this.sm.getString("resources.null"));
        }
        this.docBase = docBase;
    }

    public abstract void unbind(String var1) throws NamingException;

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }
}

