/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.naming.resources.RecyclableNamingEnumeration;

public final class ResourceAttributes
extends BasicAttributes {
    public static final String CREATION_DATE = "creationdate";
    public static final String ALTERNATE_CREATION_DATE = "last-modified";
    public static final String LAST_MODIFIED = "getlastmodified";
    public static final String ALTERNATE_LAST_MODIFIED = "last-modified";
    public static final String NAME = "displayname";
    public static final String TYPE = "resourcetype";
    public static final String ALTERNATE_TYPE = "content-type";
    public static final String SOURCE = "source";
    public static final String CONTENT_TYPE = "getcontenttype";
    public static final String CONTENT_LANGUAGE = "getcontentlanguage";
    public static final String CONTENT_LENGTH = "getcontentlength";
    public static final String ALTERNATE_CONTENT_LENGTH = "content-length";
    public static final String ETAG = "getetag";
    public static final String COLLECTION_TYPE = "<collection/>";
    protected static final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected Hashtable protectedAttributes = new Hashtable();

    public ResourceAttributes() {
        super(false);
    }

    ResourceAttributes(Hashtable attributes) {
        super(false);
        this.protectedAttributes = attributes;
    }

    public ResourceAttributes(Attributes attributes) {
        super(false);
        try {
            NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
            while (namingEnumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)namingEnumeration.nextElement();
                this.put(attribute);
            }
        }
        catch (Throwable throwable) {}
    }

    public Attribute get(String attrID) {
        Attribute result = this.getProtectedAttribute(attrID);
        if (result != null) {
            return result;
        }
        return super.get(attrID);
    }

    public NamingEnumeration getAll() {
        Object obj;
        Enumeration<Attribute> enumeration = super.getAll();
        Vector attributes = new Vector();
        while (enumeration.hasMoreElements()) {
            obj = enumeration.nextElement();
            attributes.addElement(obj);
        }
        enumeration = this.protectedAttributes.elements();
        while (enumeration.hasMoreElements()) {
            obj = enumeration.nextElement();
            attributes.addElement(obj);
        }
        return new RecyclableNamingEnumeration(attributes);
    }

    Hashtable getAttributes() {
        NamingEnumeration<Attribute> namingEnumeration = super.getAll();
        while (namingEnumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)namingEnumeration.nextElement();
            String id = attribute.getID();
            if (this.protectedAttributes.containsKey(id)) continue;
            this.protectedAttributes.put(id, attribute);
        }
        return this.protectedAttributes;
    }

    public long getContentLength() {
        Attribute contentLength = this.getProtectedAttribute(CONTENT_LENGTH);
        if (contentLength == null) {
            contentLength = this.getProtectedAttribute(ALTERNATE_CONTENT_LENGTH);
        }
        if (contentLength == null) {
            return -1L;
        }
        try {
            if (contentLength.get() instanceof Long) {
                return (Long)contentLength.get();
            }
            if (contentLength.get() instanceof String) {
                return new Long((String)contentLength.get());
            }
        }
        catch (NamingException namingException) {}
        return -1L;
    }

    public Date getCreationDate() {
        Attribute creationDate = this.getProtectedAttribute(CREATION_DATE);
        if (creationDate == null) {
            creationDate = this.getProtectedAttribute("last-modified");
        }
        if (creationDate == null) {
            return null;
        }
        try {
            if (creationDate.get() instanceof Date) {
                return (Date)creationDate.get();
            }
            String creationDateValue = creationDate.get().toString();
            Date result = null;
            int i = 0;
            while (result == null && i < formats.length) {
                try {
                    result = formats[i].parse(creationDateValue);
                }
                catch (ParseException parseException) {}
                ++i;
            }
            return result;
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    public NamingEnumeration getIDs() {
        Object obj;
        Enumeration<String> enumeration = super.getIDs();
        Vector attributeIDs = new Vector();
        while (enumeration.hasMoreElements()) {
            obj = enumeration.nextElement();
            attributeIDs.addElement(obj);
        }
        enumeration = this.protectedAttributes.elements();
        while (enumeration.hasMoreElements()) {
            obj = ((Attribute)((Object)enumeration.nextElement())).getID();
            attributeIDs.addElement(obj);
        }
        return new RecyclableNamingEnumeration(attributeIDs);
    }

    public Date getLastModified() {
        Attribute lastModified = this.getProtectedAttribute(LAST_MODIFIED);
        if (lastModified == null) {
            lastModified = this.getProtectedAttribute("last-modified");
        }
        if (lastModified == null) {
            return null;
        }
        try {
            if (lastModified.get() instanceof Date) {
                return (Date)lastModified.get();
            }
            String lastModifiedValue = lastModified.get().toString();
            Date result = null;
            int i = 0;
            while (result == null && i < formats.length) {
                try {
                    result = formats[i].parse(lastModifiedValue);
                }
                catch (ParseException parseException) {}
                ++i;
            }
            return result;
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    public String getName() {
        Attribute name = this.getProtectedAttribute(NAME);
        try {
            if (name == null) {
                return "";
            }
            return (String)name.get();
        }
        catch (NamingException namingException) {
            return "";
        }
    }

    protected Attribute getProtectedAttribute(String name) {
        Attribute result = null;
        result = name.startsWith("DAV:") ? (Attribute)this.protectedAttributes.get(name.substring("DAV:".length())) : (Attribute)this.protectedAttributes.get(name);
        if (result != null) {
            return result;
        }
        return super.get(name);
    }

    public String getResourceType() {
        Attribute resourceType = this.getProtectedAttribute(TYPE);
        if (resourceType == null) {
            resourceType = this.getProtectedAttribute(ALTERNATE_TYPE);
        }
        if (resourceType == null) {
            return "";
        }
        try {
            return (String)resourceType.get();
        }
        catch (NamingException namingException) {
            return "";
        }
    }

    protected void intializeAttributes() {
        this.setCreationDate(new Date());
        this.setProtectedAttribute(NAME, "");
        this.setProtectedAttribute(TYPE, COLLECTION_TYPE);
        this.setProtectedAttribute(SOURCE, "");
        this.setContentLength(-1L);
        this.setLastModified(new Date());
    }

    public boolean isCollection() {
        return this.getResourceType().equals(COLLECTION_TYPE);
    }

    void setContentLength(long contentLength) {
        this.setProtectedAttribute(CONTENT_LENGTH, new Long(contentLength));
    }

    void setCreationDate(Date creationDate) {
        this.setProtectedAttribute(CREATION_DATE, creationDate);
    }

    void setLastModified(Date lastModified) {
        this.setProtectedAttribute(LAST_MODIFIED, lastModified);
    }

    void setName(String name) {
        this.setProtectedAttribute(NAME, name);
    }

    protected void setProtectedAttribute(String name, Object value) {
        BasicAttribute attribute = new BasicAttribute(name, value);
        this.protectedAttributes.put(name, attribute);
    }

    void setResourceType(String resourceType) {
        this.setProtectedAttribute(TYPE, resourceType);
    }

    public int size() {
        return this.protectedAttributes.size() + super.size();
    }

    public String toString() {
        String result = this.protectedAttributes.toString();
        if (super.size() > 0) {
            result = String.valueOf(result) + super.toString();
        }
        return result;
    }
}

