/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.warp.WarpConnectionHandler;
import org.apache.catalina.connector.warp.WarpConnector;
import org.apache.catalina.connector.warp.WarpDebug;
import org.apache.catalina.connector.warp.WarpHandler;
import org.apache.catalina.connector.warp.WarpHandlerTable;
import org.apache.catalina.util.LifecycleSupport;

public class WarpConnection
implements Lifecycle,
Runnable {
    private static final boolean DEBUG = false;
    private LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private WarpHandlerTable table = new WarpHandlerTable();
    private String name = null;
    private boolean started = false;
    private static int num = 0;
    private Socket socket = null;
    private WarpConnector connector = null;

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    private void debug(Exception exc) {
    }

    private void debug(String msg) {
    }

    protected WarpConnector getConnector() {
        return this.connector;
    }

    protected Socket getSocket() {
        return this.socket;
    }

    public void log(Exception exc) {
        if (this.connector != null) {
            this.connector.log(exc);
        } else {
            WarpDebug.debug((Object)this, exc);
        }
    }

    public void log(String msg) {
        if (this.connector != null) {
            this.connector.log(msg);
        } else {
            WarpDebug.debug((Object)this, msg);
        }
    }

    protected synchronized boolean registerHandler(WarpHandler han, int rid) {
        return this.table.add(han, rid);
    }

    protected synchronized WarpHandler removeHandler(int rid) {
        return this.table.remove(rid);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void run() {
        block14: {
            WarpHandler han = null;
            InputStream in = null;
            int rid = 0;
            int typ = 0;
            int len = 0;
            int ret = 0;
            int b1 = 0;
            int b2 = 0;
            byte[] buf = null;
            ++num;
            try {
                in = this.socket.getInputStream();
                while (this.started) {
                    b1 = in.read();
                    if ((b1 | (b2 = in.read())) == -1) {
                        this.log("Premature RID end");
                        break;
                    }
                    rid = (b1 & 0xFF) << 8 | b2 & 0xFF;
                    b1 = in.read();
                    if ((b1 | (b2 = in.read())) == -1) {
                        this.log("Premature TYPE end");
                        break;
                    }
                    typ = (b1 & 0xFF) << 8 | b2 & 0xFF;
                    b1 = in.read();
                    if ((b1 | (b2 = in.read())) == -1) {
                        this.log("Premature LEN end");
                        break;
                    }
                    len = (b1 & 0xFF) << 8 | b2 & 0xFF;
                    buf = new byte[len];
                    ret = in.read(buf, 0, len);
                    if (ret != len) {
                        this.log("Premature packet end (" + ret + " of " + len + ")");
                        break;
                    }
                    if (rid == 65535) {
                        this.log("Connection closing (" + new String(buf) + ")");
                        break;
                    }
                    WarpConnection warpConnection = this;
                    synchronized (warpConnection) {
                        han = this.table.get(rid);
                    }
                    if (han == null) {
                        this.log("Handler for RID " + rid + " not found");
                        break;
                    }
                    han.processData(typ, buf);
                }
            }
            catch (IOException e) {
                if (!this.started) break block14;
                e.printStackTrace(System.err);
            }
        }
        try {
            this.stop();
        }
        catch (LifecycleException e) {
            this.log((Exception)((Object)e));
        }
        --num;
    }

    public void send(int rid, int type, byte[] buffer, int offset, int len) throws IOException {
        if (this.socket == null) {
            throw new IOException("Connection closed " + type);
        }
        OutputStream out = this.socket.getOutputStream();
        byte[] hdr = new byte[]{(byte)(rid >> 8 & 0xFF), (byte)(rid & 0xFF), (byte)(type >> 8 & 0xFF), (byte)(type & 0xFF), (byte)(len >> 8 & 0xFF), (byte)(len & 0xFF)};
        WarpConnection warpConnection = this;
        synchronized (warpConnection) {
            out.write(hdr, 0, 6);
            out.write(buffer, offset, len);
            out.flush();
        }
    }

    protected void setConnector(WarpConnector connector) {
        this.connector = connector;
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void start() throws LifecycleException {
        if (this.socket == null) {
            throw new LifecycleException("Null socket");
        }
        if (this.connector == null) {
            throw new LifecycleException("Null connector");
        }
        this.started = true;
        WarpConnectionHandler h = new WarpConnectionHandler();
        h.setConnection(this);
        h.setRequestID(0);
        h.start();
        if (!this.registerHandler(h, 0)) {
            this.stop();
            throw new LifecycleException("Cannot register connection handler");
        }
        this.name = this.socket.getInetAddress().getHostAddress();
        this.name = String.valueOf(this.name) + ":" + this.socket.getPort();
        new Thread((Runnable)this, this.name).start();
    }

    public void stop() throws LifecycleException {
        this.started = false;
        WarpHandler[] handlers = this.table.handlers();
        int x = 0;
        while (x < handlers.length) {
            handlers[x].stop();
            ++x;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.log(e);
                throw new LifecycleException("Closing connection " + this.name, (Throwable)e);
            }
        }
        this.socket = null;
        this.log("Connection closed");
    }
}

