/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpConnector;
import org.apache.catalina.connector.warp.WarpContext;
import org.apache.catalina.connector.warp.WarpEngine;
import org.apache.catalina.connector.warp.WarpHandler;
import org.apache.catalina.connector.warp.WarpHost;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.connector.warp.WarpReader;
import org.apache.catalina.connector.warp.WarpRequest;
import org.apache.catalina.connector.warp.WarpRequestHandler;
import org.apache.catalina.connector.warp.WarpResponse;

public class WarpConnectionHandler
extends WarpHandler {
    private WarpReader reader = new WarpReader();
    private WarpPacket packet = new WarpPacket();
    private int request = 1;

    public boolean process(int type, byte[] buffer) {
        WarpConnector connector = this.getConnector();
        WarpEngine engine = (WarpEngine)connector.getContainer();
        this.reader.reset(buffer);
        this.packet.reset();
        try {
            switch (type) {
                case 0: {
                    String name = String.valueOf(this.reader.readString()) + "." + this.reader.readShort();
                    int hid = engine.setupChild(name).getHostID();
                    this.debug("Host " + name + " has ID=" + hid);
                    this.packet.reset();
                    this.packet.writeShort(hid);
                    this.send(1, this.packet);
                    break;
                }
                case 2: {
                    int hid = this.reader.readShort();
                    String name = this.reader.readString();
                    String path = this.reader.readString();
                    WarpHost host = engine.findChild(hid);
                    if (host == null) {
                        this.log("Host ID " + hid + " not found");
                        this.packet.reset();
                        this.send(15, this.packet);
                        return false;
                    }
                    WarpContext cont = (WarpContext)host.findChild(String.valueOf('/') + name);
                    if (cont == null) {
                        this.log("Application " + name + " with path " + path + " not found");
                        this.packet.reset();
                        this.send(15, this.packet);
                        return false;
                    }
                    int aid = cont.getApplicationID();
                    cont.setPath(String.valueOf('/') + name);
                    cont.setDisplayName(name);
                    this.debug("Application " + name + " mapped in " + host.getName() + path + " has ID " + aid);
                    this.packet.reset();
                    this.packet.writeShort(aid);
                    this.send(3, this.packet);
                    break;
                }
                case 4: {
                    int hid = this.reader.readShort();
                    int aid = this.reader.readShort();
                    this.debug("Request for HID=" + hid + " AID=" + aid);
                    int rid = this.request;
                    WarpConnection c = this.getConnection();
                    WarpRequestHandler h = new WarpRequestHandler();
                    c.registerHandler(h, rid);
                    this.request = rid + 1;
                    h.setConnection(c);
                    h.setRequestID(rid);
                    this.packet.reset();
                    this.packet.writeShort(rid);
                    this.send(5, this.packet);
                    h.request = (WarpRequest)connector.createRequest();
                    h.response = (WarpResponse)connector.createResponse();
                    h.request.setRequestID(rid);
                    h.request.setRequestedHostID(hid);
                    h.request.setRequestedApplicationID(aid);
                    h.request.setWarpRequestHandler(h);
                    h.response.setWarpRequestHandler(h);
                    try {
                        h.start();
                    }
                    catch (Exception e) {
                        this.log(e);
                        h.stop();
                    }
                    break;
                }
                default: {
                    this.log("Wrong packet type " + type + ". Closing connection");
                    this.packet.reset();
                    this.send(15, this.packet);
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            this.log(e);
            return false;
        }
    }
}

