/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpDebug;
import org.apache.catalina.connector.warp.WarpRequest;
import org.apache.catalina.connector.warp.WarpResponse;
import org.apache.catalina.net.DefaultServerSocketFactory;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.util.LifecycleSupport;

public class WarpConnector
implements Connector,
Lifecycle,
Runnable {
    private static final boolean DEBUG = false;
    private static final String info = "WarpConnector/0.5";
    private LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private ServerSocket socket = null;
    private boolean started = false;
    private int count = 10;
    private boolean enableLookups = false;
    private int redirectPort = 443;
    private boolean secure = false;
    private String scheme = "http";
    private Container container = null;
    private ServerSocketFactory factory = null;
    private int port = 8008;
    private int acceptcount = 10;

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public Request createRequest() {
        WarpRequest request = new WarpRequest();
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        WarpResponse response = new WarpResponse();
        response.setConnector(this);
        return response;
    }

    private void debug(Exception exc) {
    }

    private void debug(String msg) {
    }

    public int getAcceptCount() {
        return this.acceptcount;
    }

    public Container getContainer() {
        return this.container;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public ServerSocketFactory getFactory() {
        WarpConnector warpConnector = this;
        synchronized (warpConnector) {
            if (this.factory == null) {
                this.factory = new DefaultServerSocketFactory();
            }
        }
        return this.factory;
    }

    public String getInfo() {
        return info;
    }

    public int getPort() {
        return this.port;
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void log(Exception exc) {
        WarpDebug.debug((Object)this, exc);
    }

    public void log(String msg) {
        WarpDebug.debug((Object)this, msg);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                if (!this.started) {
                    this.socket.close();
                    return;
                }
                Socket s = this.socket.accept();
                WarpConnection c = new WarpConnection();
                c.setSocket(s);
                c.setConnector(this);
                try {
                    c.start();
                }
                catch (LifecycleException e) {
                    this.log((Exception)((Object)e));
                }
            }
        }
        catch (IOException e) {
            if (!this.started) return;
            e.printStackTrace(System.err);
        }
    }

    public void setAcceptCount(int acceptcount) {
        this.acceptcount = acceptcount;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    public void setFactory(ServerSocketFactory factory) {
        if (factory == null) {
            return;
        }
        WarpConnector warpConnector = this;
        synchronized (warpConnector) {
            this.factory = factory;
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException("Connector already started");
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        try {
            this.socket = this.getFactory().createSocket(this.port, this.count);
        }
        catch (Exception e) {
            throw new LifecycleException("Error creating server socket", (Throwable)e);
        }
        new Thread(this).start();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("Cannot stop (never started)");
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        try {
            this.socket.close();
        }
        catch (IOException e) {
            throw new LifecycleException("Error closing server socket", (Throwable)e);
        }
    }
}

