/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.warp.WarpHost;
import org.apache.catalina.connector.warp.WarpRequest;
import org.apache.catalina.core.StandardEngine;

public class WarpEngine
extends StandardEngine {
    private static final boolean DEBUG = false;
    private static final String info = "WarpEngine/0.5";
    private String mapper = "org.apache.catalina.connector.warp.WarpEngineMapper";
    private String appbase = "";
    private int hostid = 0;

    public WarpEngine() {
        super.addDefaultMapper(this.mapper);
        this.setDebug(9);
    }

    public void addChild(Container child) {
        if (child instanceof WarpHost) {
            WarpHost byid = this.findChild(((WarpHost)child).getHostID());
            if (byid != null) {
                throw new IllegalArgumentException("Host " + byid.getName() + " already configured with ID=" + byid.getHostID());
            }
        } else {
            throw new IllegalArgumentException("Child is not a WarpHost");
        }
        super.addChild(child);
    }

    protected void addDefaultMapper(String mapper) {
        super.addDefaultMapper(this.mapper);
    }

    private void debug(Exception exc) {
    }

    private void debug(String msg) {
    }

    public WarpHost findChild(int id) {
        Container[] children = this.findChildren();
        int x = 0;
        while (x < children.length) {
            WarpHost curr = (WarpHost)children[x];
            if (curr.getHostID() == id) {
                return curr;
            }
            ++x;
        }
        return null;
    }

    public String getAppBase() {
        return this.appbase;
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request req, Response res) throws ServletException, IOException {
        super.invoke(req, res);
    }

    public Container map(Request request, boolean update) {
        if (request instanceof WarpRequest) {
            WarpRequest r = (WarpRequest)request;
            Container[] children = this.findChildren();
            int x = 0;
            while (x < children.length) {
                if (children[x] instanceof WarpHost) {
                    WarpHost host = (WarpHost)children[x];
                    if (r.getRequestedHostID() == host.getHostID()) {
                        return children[x];
                    }
                }
                ++x;
            }
        }
        return super.map(request, update);
    }

    public void setAppBase(String appbase) {
        if (appbase == null) {
            return;
        }
        String old = this.appbase;
        this.appbase = appbase;
    }

    public synchronized WarpHost setupChild(String name) {
        WarpHost host = (WarpHost)this.findChild(name);
        if (host == null) {
            this.debug("Creating new host " + name);
            host = new WarpHost();
            host.setName(name);
            host.setHostID(this.hostid++);
            host.setAppBase(this.appbase);
            this.addChild((Container)host);
        }
        return host;
    }
}

