/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpConnector;
import org.apache.catalina.connector.warp.WarpDebug;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.util.LifecycleSupport;

public abstract class WarpHandler
implements Lifecycle,
Runnable {
    protected static final boolean DEBUG = true;
    private LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private int type = -1;
    private byte[] buffer = null;
    private boolean processed = false;
    private boolean stopped = false;
    private String name = null;
    private WarpConnection connection = null;
    private int rid = -1;

    public WarpHandler() {
        this.debug("New instance created");
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    protected void debug(Exception exc) {
        WarpDebug.debug((Object)this, exc);
    }

    protected void debug(String msg) {
        WarpDebug.debug((Object)this, msg);
    }

    protected WarpConnection getConnection() {
        return this.connection;
    }

    protected WarpConnector getConnector() {
        return this.connection.getConnector();
    }

    protected int getRequestID() {
        return this.rid;
    }

    protected void log(Exception exc) {
        WarpConnection connection = this.getConnection();
        if (connection != null) {
            connection.log(exc);
        } else {
            WarpDebug.debug((Object)this, exc);
        }
    }

    protected void log(String msg) {
        WarpConnection connection = this.getConnection();
        if (connection != null) {
            connection.log(msg);
        } else {
            WarpDebug.debug((Object)this, msg);
        }
    }

    public abstract boolean process(int var1, byte[] var2);

    protected final synchronized void processData(int type, byte[] buffer) {
        while (!this.processed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        this.type = type;
        this.buffer = buffer;
        this.processed = false;
        this.notifyAll();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public final synchronized void run() {
        while (true) {
            try {
                while (this.processed) {
                    this.wait();
                    if (!this.stopped) continue;
                    this.processed = true;
                    this.notifyAll();
                    this.connection.removeHandler(this.rid);
                    this.debug("Thread exited");
                }
            }
            catch (InterruptedException interruptedException) {
                this.connection.removeHandler(this.rid);
                return;
            }
            if (this.processed) continue;
            if (!this.process(this.type, this.buffer)) break;
            this.processed = true;
            this.notifyAll();
        }
        this.processed = true;
        this.notifyAll();
        this.connection.removeHandler(this.rid);
        this.debug("Thread exited");
    }

    public final void send(int type, WarpPacket packet) throws IOException {
        this.send(type, packet.getBuffer(), 0, packet.getLength());
    }

    public final void send(int type, byte[] buffer) throws IOException {
        this.send(type, buffer, 0, buffer.length);
    }

    public final void send(int type, byte[] buffer, int offset, int len) throws IOException {
        this.connection.send(this.rid, type, buffer, offset, len);
    }

    protected void setConnection(WarpConnection connection) {
        this.debug("Setting connection");
        this.connection = connection;
    }

    protected void setRequestID(int rid) {
        this.debug("Setting Request ID " + rid);
        this.rid = rid;
    }

    public final void start() throws LifecycleException {
        if (this.connection == null) {
            throw new LifecycleException("Null connection");
        }
        if (this.rid < 0) {
            throw new LifecycleException("Invalid handler request ID");
        }
        this.processed = true;
        this.stopped = false;
        String n = this.getClass().getName();
        this.name = String.valueOf(n.substring(n.lastIndexOf(46) + 1)) + "[RID=" + this.rid + "]";
        new Thread((Runnable)this, this.name).start();
    }

    public final synchronized void stop() {
        this.debug("Stopping");
        this.stopped = true;
        this.notifyAll();
        this.connection.removeHandler(this.rid);
        this.debug("Stopped");
    }
}

