/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.warp.WarpContext;
import org.apache.catalina.connector.warp.WarpRequest;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.HostConfig;

public class WarpHost
extends StandardHost {
    private static final boolean DEBUG = false;
    private static String cc = "org.apache.catalina.connector.warp.WarpContext";
    private int id = -1;
    private int applid = 0;

    public WarpHost() {
        HostConfig conf = new HostConfig();
        conf.setContextClass(cc);
        this.setContextClass(cc);
        this.addLifecycleListener((LifecycleListener)conf);
        this.setDebug(9);
    }

    public void addChild(Container container) {
        if (!(container instanceof WarpContext)) {
            throw new IllegalArgumentException("Cannot add context class " + container.getClass().getName() + " to WarpContext");
        }
        WarpContext cont = (WarpContext)container;
        cont.setApplicationID(this.applid++);
        super.addChild((Container)cont);
    }

    private void debug(Exception exc) {
    }

    private void debug(String msg) {
    }

    protected int getHostID() {
        return this.id;
    }

    public void invoke(Request req, Response res) throws ServletException, IOException {
        super.invoke(req, res);
    }

    public Container map(Request request, boolean update) {
        if (request instanceof WarpRequest) {
            WarpRequest r = (WarpRequest)request;
            Container[] children = this.findChildren();
            int x = 0;
            while (x < children.length) {
                if (children[x] instanceof WarpContext) {
                    WarpContext c = (WarpContext)children[x];
                    if (r.getRequestedApplicationID() == c.getApplicationID()) {
                        ((WarpRequest)request).setContextPath(c.getPath());
                        return children[x];
                    }
                }
                ++x;
            }
        }
        return super.map(request, update);
    }

    protected void setHostID(int id) {
        this.id = id;
    }
}

