/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.catalina.connector.warp.WarpRequestHandler;
import org.apache.catalina.connector.warp.WarpResponse;

public class WarpOutputStream
extends OutputStream {
    private WarpRequestHandler handler = null;
    private WarpResponse response = null;
    private byte[] buffer = new byte[4096];
    private int pos = 0;
    private boolean closed = false;
    private static final boolean DEBUG = false;

    private WarpOutputStream() {
    }

    public WarpOutputStream(WarpRequestHandler handler, WarpResponse response) {
        this.handler = handler;
        this.response = response;
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        this.flush();
        this.closed = true;
    }

    private void debug(Exception exc) {
    }

    private void debug(String msg) {
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        this.response.sendHeaders();
        this.handler.send(35, this.buffer, 0, this.pos);
        this.pos = 0;
    }

    public void write(int k) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        this.buffer[this.pos++] = (byte)k;
        if (this.pos == 4096) {
            this.flush();
        }
    }
}

