/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

public class WarpPacket {
    private static final int defaultsize = 4096;
    private byte[] buf = new byte[4096];
    private int pos;

    public WarpPacket() {
        this.reset();
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getLength() {
        return this.pos;
    }

    public void reset() {
        this.pos = 0;
        if (this.buf.length > 8192) {
            this.buf = new byte[4096];
        }
    }

    public void writeShort(int k) {
        if (this.pos + 2 < this.buf.length) {
            byte[] newbuf = new byte[this.buf.length + 4096];
            System.arraycopy(this.buf, 0, newbuf, 0, this.pos);
            this.buf = newbuf;
        }
        this.buf[this.pos++] = (byte)(k >> 8 & 0xFF);
        this.buf[this.pos++] = (byte)(k & 0xFF);
    }

    public void writeString(String s) {
        byte[] k = s.getBytes();
        this.writeShort(k.length);
        if (this.pos + k.length < this.buf.length) {
            byte[] newbuf = new byte[this.buf.length + k.length + 4096];
            System.arraycopy(this.buf, 0, newbuf, 0, this.pos);
            this.buf = newbuf;
        }
        System.arraycopy(k, 0, this.buf, this.pos, k.length);
        this.pos += k.length;
    }
}

